/*
 Copyright (c) 1996-2000 Logitech, Inc.  All Rights Reserved

 This program is a trade secret of LOGITECH, and it is not to be reproduced,
 published, disclosed to others, copied, adapted, distributed or displayed
 without the prior authorization of LOGITECH.

 Licensee agrees to attach or embed this notice on all copies of the program,
 including partial copies or modified versions thereof.
*/

#ifndef _LVSERVERDEFS_H_
#define _LVSERVERDEFS_H_

#define INDEO50_COMPRESSION		0x30355649
#define NO_COMPRESSION			0x00000000

typedef enum
{
	NOTIFICATIONMSG_MOTION = 1,
	NOTIFICATIONMSG_MOVIERECORDERROR = 2,
	NOTIFICATIONMSG_CAMERADETACHED = 3,
	NOTIFICATIONMSG_CAMERAREATTACHED = 4,
	NOTIFICATIONMSG_IMAGESIZECHANGE = 5,
	NOTIFICATIONMSG_CAMERAPRECHANGE = 6,
	NOTIFICATIONMSG_CAMERACHANGEFAILED = 7,
	NOTIFICATIONMSG_POSTCAMERACHANGED = 8,
	NOTIFICATIONMSG_CAMERBUTTONCLICKED = 9,
	NOTIFICATIONMSG_VIDEOHOOK = 10,
	NOTIFICATIONMSG_SETTINGDLGCLOSED = 11,
	NOTIFICATIONMSG_QUERYPRECAMERAMODIFICATION = 12,
	NOTIFICATIONMSG_MOVIESIZE = 13,

} NOTIFICATIONMSG;

typedef enum
{
	CMD_PREPARECONTROL = 1,
	CMD_ISINITIALIZED = 2,
	CMD_INITIALIZE_CAMERA = 3,
	CMD_UNINITIALIZE_CAMERA =  4,
	CMD_CAMERA_PROPERTY = 5,
	CMD_MOVIERECORDING = 6,
	CMD_TEXTSTAMP = 7,
	CMD_VIDEOFORMAT = 8,
	CMD_REGISTRY = 9,
	CMD_PREVIEWWINDOW = 10,
	CMD_CALLBACKWINDOW = 11,
	CMD_TAKEPICTURE = 12,
	CMD_GETDEVICE_COUNT = 13,
	CMD_GETDEVICE_INDEX = 14,
	CMD_GETCURRENTDEVICE = 15,
	CMD_FINDDEVICEINDEX = 16,
	CMD_GETCURRENTDEVICEINDEX = 17,
	CMD_GETREGISTRYDEVICE = 18,
	CMD_GETREGISTRYINDEX = 19,
	CMD_CAMERA_STATE = 20,
	CMD_GETCAMERACONNECTED = 21,

	CMD_GETLASTERROR = 99,

} CMDSERVER ;

typedef enum
{
	SUBCMD_STARTRECORDING = 1,
	SUBCMD_STOPRECORDING = 2,
	SUBCMD_ADDFRAME = 3,
	SUBCMD_VIDEOCOMPRESSION = 4,
	SUBCMD_AUDIOFORMAT = 5,
	SUBCMD_RECORDINGSTATUS = 6,

} SUBCMD_MOVIERECORDING;

typedef enum
{
	SUBCMD_LOADREGISTRY = 1,
	SUBCMD_SAVEREGISTRY = 2,

} SUBCMD_REGISTRY;

typedef enum
{
	CAMERA_UNKNOWN = 0,
	CAMERA_QUICKCAM_VC = 1,
	CAMERA_QUICKCAM_QUICKCLIP =2,
	CAMERA_QUICKCAM_PRO = 3,
	CAMERA_QUICKCAM_HOME = 4,
	CAMERA_QUICKCAM_PRO_B = 5,
	CAMERA_QUICKCAM_TEKCOM = 6,
	CAMERA_QUICKCAM_EXPRESS=7,
	CAMERA_QUICKCAM_FROG=8, // MIGHT CHANGE NAME, BUT ENUM STAYS THE SAME
	CAMERA_QUICKCAM_EMERALD=9, // MIGHT CHANGE NAME, BUT ENUM STAYS THE SAME


} CAMERA_TYPE;

typedef enum
{
	SUBCMD_PREVIEW_NEW = 0,
	SUBCMD_PREVIEW_REMOVE = 1,
	SUBCMD_PREVIEW_UPDATE = 2,

} SUBCMD_PREVIEWWINDOW;

typedef enum
{
	SUBCMD_CALLBACK_NEW = 0,
	SUBCMD_CALLBACK_REMOVE = 1,

} SUBCMD_CALLBACKWINDOW;

typedef enum
{
	SUBCMD_TAKEPICTURE_FILE24RGB = 0,
	SUBCMD_TAKEPICTURE_MEMORY24RGB = 1,
	SUBCMD_TAKEPICTURE_SOUND = 2,

} SUBCMD_TAKEPICTURE;



typedef enum
{
	CAMERA_OK = 0,
	CAMERA_UNPLUGGED = 1,
	CAMERA_INUSE = 2,
	CAMERA_ERROR = 3,
	CAMERA_SUSPENDED = 4,
	CAMERA_DUAL_DETACHED = 5,
	CAMERA_UNKNOWNSTATUS = 10,

} CAMERA_STATUS;

typedef struct tagPREPARE_DATA
{
	unsigned long	ulSize;
	char			szUniqueName[256];
	char			szRegistryKey[256];

} PREPARE_DATA, * LPPREPARE_DATA;

typedef struct tagDEVICE_DATA
{
	unsigned long	ulSize;
	unsigned short	usDeviceIndex;
	unsigned short	usDeviceOffset;
	char			szDescription[256];
	CAMERA_TYPE		camera_type;
	CAMERA_STATUS	camera_status;
	unsigned short	usTemporaryID;

} DEVICE_DATA, * LPDEVICE_DATA;

#define INITIALIZE_CAMERA_FLAGS_COOPERATIVE		0x00000001

typedef enum
{
	SEQUENCECAPTURE_FPS_USERSPECIFIED = 1,
	SEQUENCECAPTURE_FPS_FASTASPOSSIBLE = 2,
	STEPCAPTURE_MANUALTRIGGERED = 3, // user must call ADDFRAME add a frame...

} MOVIEMODE;


#define MOVIECREATEFLAGS_CREATENEW	1
#define MOVIECREATEFLAGS_APPEND		2

typedef struct tagMOVIERECORDING_DATA
{
	unsigned long		ulSize;
	char				sMovieName[512];
	unsigned long		ulMillisecondsPerFrame;
	MOVIEMODE			mode;
	unsigned long		ulCompressVideo;
	unsigned long		ulRecordAudio; // option not available for "step capture"
	unsigned long		ulCompressAudio;
	char				sTextOverlay[256];
	unsigned long		ulCreateFlags;

} MOVIERECORDING_DATA, * LPMOVIERECORDING_DATA;



typedef struct tagMOVIERECORDING_QUERY_DATA
{
	unsigned long	ulSize;
	MOVIEMODE	mode;
	unsigned long	ulRecording;

} MOVIERECORDING_QUERY_DATA;


typedef struct tagVIDEOCOMPRESSION_DATA
{
	unsigned long	ulSize;
	unsigned long   ulVideoCompressionFourCC;
	unsigned long   ulVideoCompressionQuality;
	unsigned long   ulVideoCompressionKeyInterval;

} VIDEOCOMPRESSION_DATA, * LPVIDEOCOMPRESSION_DATA;

typedef struct tagAUDIOFORMAT_DATA
{
	unsigned long	ulSize;
	unsigned long	ulChannels;
	unsigned long	ulSamplesPerSecond;
	unsigned long	ulBitsPerSample;
	unsigned long	ulAudioCompressionTag;
	unsigned long	ulAudioCompressionQuality;

} AUDIOFORMAT_DATA, * LPAUDIOFORMAT_DATA;

typedef struct tagTEXTSTAMP_DATA
{
	unsigned long	ulSize;
	COLORREF		textColor;
	char			cFontName[64];
	unsigned long	ulPointSize;
	unsigned long	ulShadowText;
	COLORREF		shadowColor;
	unsigned long	ulTransparent;
	COLORREF		colorOpaque;
	unsigned long	ulFormat; // unused for now, maybe later describes the CENTER...etc.

} TEXTSTAMP_DATA, * LPTEXTSTAMP_DATA;

typedef struct tagVIDEOFORMAT_DATA
{
	unsigned long	ulSize;
	unsigned long	ulWidth;
	unsigned long	ulHeight;
	unsigned long	ulBitDepth;
	unsigned long	ulCompression; // 0 = uncompressed RGB

} VIDEOFORMAT_DATA, * LPVIDEOFORMAT_DATA;

typedef struct tagPREVIEWWINDOW_DATA
{
	unsigned long	ulSize;
	unsigned long	lFlags;
	HWND			hWndPreview;
	unsigned long	ulleft; 
    unsigned long	ultop; 
    unsigned long	ulright; 
    unsigned long	ulbottom; 
	unsigned long   ulShowPreview;

} PREVIEWWINDOW_DATA, * LPPREVIEWWINDOW_DATA ;

#define PREVIEWHWND		0x00000001
#define PREVIEWRECT		0x00000002
#define PREVIEWSHOW		0x00000004

typedef enum
{
	PREVIEWSUBCMD_NEW,
	PREVIEWSUBCMD_REMOVE,
	PREVIEWSUBCMD_UPDATE,

} PREVIEWSUBCMD;


typedef struct tagTAKEPICTURE_DATA
{
	unsigned long	ulSize;
	char			sFileName[512]; // unused for TAKEPICTURE_MEMORY24RGB
	char			sTextOverlay[256];

} TAKEPICTURE_DATA, * LPTAKEPICTURE_DATA;

typedef struct tagTAKEPICTURE_SOUND_DATA
{
	unsigned long	ulSize;
	char			sSoundFile[512];

} TAKEPICTURE_SOUND_DATA, *LPTAKEPICTURE_SOUND_DATA;

typedef struct tagREGISTRY_DATA
{
	unsigned long	ulSize;
	char			sRegistryName[512];
	unsigned long	ulFlags;

}REGISTRY_DATA, * LPREGISTRY_DATA;

#define REGISTRY_NONVOLATILE_ONLY_VALUES	0x00000001
#define REGISTRY_VOLATILE_ONLY_VALUES		0x00000002
#define REGISTRY_ALL_VALUES					(REGISTRY_NONVOLATILE_ONLY_VALUES|REGISTRY_VOLATILE_ONLY_VALUES)

typedef enum
{
	ADJUSTMENT_MANUAL = 0,
	ADJUSTMENT_AUTOMATIC = 1,

} ADJUSTMENTMODE ;

typedef enum
{
	ORIENTATIONMODE_NORMAL = 0,
	ORIENTATIONMODE_MIRRORED = 1,
	ORIENTATIONMODE_FLIPPED = 2,
	ORIENTATIONMODE_FLIPPED_AND_MIRRORED = 3,

} ORIENTATIONMODE ;


typedef enum
{
	SEQUENCE_CAPTURE_RECORDING = 0,
	STEP_CAPTURE_RECORDING = 1,

} CAPTURE_RECORDING;

typedef enum
{
	COLORFLAG_RED = 1,
	COLORFLAG_BLUE = 2,

} COLORFLAG ;

typedef enum
{
	COMPRESSION_Q0 = 0,
	COMPRESSION_Q1 = 1,
	COMPRESSION_Q2 = 2,

} COMPRESSION_QUALITY;

typedef enum
{
	ANTIFLICKER_OFF,
	ANTIFLICKER_50Hz,
	ANTIFLICKER_60Hz,

} ANTIFLICKER;

typedef enum
{
	OPTIMIZE_QUALITY,
	OPTIMIZE_SPEED,

} OPTIMIZATION;

typedef enum
{
   LED_OFF,
   LED_ON,
   LED_AUTO,
   LED_MAX,

} LED_STATE;

typedef enum
{
	PROPERTY_ORIENTATION = 0,
	PROPERTY_BRIGHTNESSMODE = 1,
	PROPERTY_BRIGHTNESS = 2,
	PROPERTY_CONTRAST = 3,
	PROPERTY_COLORMODE = 4,
	PROPERTY_REDGAIN = 5,
	PROPERTY_BLUEGAIN = 6,
	PROPERTY_SATURATION = 7,
	PROPERTY_EXPOSURE = 8,
	PROPERTY_RESET = 9,
	PROPERTY_COMPRESSION = 10,
	PROPERTY_ANTIBLOOM = 11,
	PROPERTY_LOWLIGHTFILTER = 12,
	PROPERTY_IMAGEFIELD = 13,
	PROPERTY_HUE = 14,
	PROPERTY_PORT_TYPE = 15,
	PROPERTY_PICTSMART_MODE = 16,
	PROPERTY_PICTSMART_LIGHT = 17,
	PROPERTY_PICTSMART_LENS = 18,
	PROPERTY_MOTION_DETECTION_MODE = 19,
	PROPERTY_MOTION_SENSITIVITY = 20,
	PROPERTY_WHITELEVEL = 21,
	PROPERTY_AUTO_WHITELEVEL = 22,
	PROPERTY_ANALOGGAIN = 23,
	PROPERTY_AUTO_ANALOGGAIN = 24,
	PROPERTY_LOWLIGHTBOOST = 25,
	PROPERTY_COLORBOOST = 26,
	PROPERTY_ANTIFLICKER = 27,
	PROPERTY_OPTIMIZATION_SPEED_QUALITY = 28,
	PROPERTY_STREAM_HOOK = 29,
	PROPERTY_LED = 30,

} CAMERA_PROPERTY_LONG;

typedef enum
{
	STREAMHOOK_INACTIVATE = 0,
	STREAMHOOK_ACTIVE = 1,

} STREAMHOOK_STATE ;

typedef enum
{
	PORTTYPE_UNKNOWN = 0,
	PORTTYPE_LPT_NIBBLE = 1,
	PORTTYPE_LPT_BIDIRECTIONAL = 2,
	PORTTYPE_LPT_ECP = 3,
	PORTTYPE_LPT_ECPDMA = 4,
	PORTTYPE_USB = 5,

} PORTTYPE;

typedef enum
{
	WRITEFAILURE_RECORDINGSTOPPED = 0,
	WRITEFAILURE_RECORDINGSTOPPED_FILECORRUPTANDDELETED = 1,
	WRITEFAILURE_CAMERA_UNPLUGGED = 2,
	WRITEFAILURE_CAMERA_SUSPENDED = 3,
} LCERROR ;


/*--- picture smart light settings ---*/
typedef enum
{
	PICTSMART_LIGHTCORRECTION_NONE = 0,
	PICTSMART_LIGHTCORRECTION_COOLFLORESCENT = 1,
	PICTSMART_LIGHTCORRECTION_WARMFLORESCENT = 2,
	PICTSMART_LIGHTCORRECTION_OUTSIDE = 3,
	PICTSMART_LIGHTCORRECTION_TUNGSTEN = 4,

} PICTSMART_LIGHTCORRECTION;

typedef enum
{
	PICTSMART_LENSCORRECTION_NORMAL = 0,
	PICTSMART_LENSCORRECTION_WIDEANGLE = 1,
	PICTSMART_LENSCORRECTION_TELEPHOTO = 2,

} PICTSMART_LENSCORRECTION ;

typedef enum
{
	UIELEMENT_640x480,
	UIELEMENT_320x240,
	UIELEMENT_PCSMART,
	UIELEMENT_STATUSBAR,
	UIELEMENT_UI, // disables user access to status bar and dialog configuration...
	UIELEMENT_CAMERA,
	UIELEMENT_160x120,

} UIELEMENT;

typedef enum
{
	CAMERADLG_GENERAL = 0,
	CAMERADLG_ADVANCED = 1,

} CAMERADLG;


typedef enum
{
	VIDEOHOOK_COOPERATIVE = 0,
	VIDEOHOOK_EXCLUSIVE = 1,
	VIDEOHOOK_DISABLED = 2,
	VIDEOHOOK_NONE = 3,

} VIDEOHOOK_STATE;

typedef enum
{
	INTERNAL_THUMBNAIL,
	INTERNAL_PICTURE,

} INTERNAL_IMAGETYPE;

#define VERROR_BASE										(0)
#define VERROR_NONE							  (VERROR_BASE)
#define VERROR_UNKNOWN						(VERROR_BASE+1) //"unknown"
#define VERROR_CAMERA_NOT_INITIALIZED		(VERROR_BASE+2) //"You must first initialize a camera before calling this method"
#define VERROR_DEVICE_UNPLUGGED				(VERROR_BASE+3)	//"The USB camera device has been unplugged from USB port"
#define VERROR_DEVICE_ALREADY_INITIALIZED	(VERROR_BASE+4)	//"A device has already been initialized for this control, you must call UnInitialize() to use another camera"
#define VERROR_NO_ENUMERATED_DEVICES_FOUND	(VERROR_BASE+5)	//"There are no devices attached to the system"
#define VERROR_ENUMERATED_DEVICE_NOT_FOUND	(VERROR_BASE+6)	//"Specified enumerated device not found"
#define VERROR_UNABLE_TO_OPEN_DEVICE		(VERROR_BASE+7)	//"Unable to open device, VFW connect failed"
#define VERROR_INVALID_PARAMETER			(VERROR_BASE+8)	//"Invalid parameter"
#define VERROR_UNSUPPORTED_PROPERTY			(VERROR_BASE+9)	//"The connected device does not support this property"
#define VERROR_SEQUENCECAPTURE_IN_PROGRESS			(VERROR_BASE+10) //"A movie is currently being recording, this method is not available at this time"
#define VERROR_UNABLE_TO_OPEN_REGISTRY				(VERROR_BASE+11)	 //"Unable to open the registry sub key, an example key would be  \"HKEY_CURRENT_USER\\Software\\Logitech\\TestApp\""
#define VERROR_MOTION_DETECTION_EXISTS_ELSEWHERE    (VERROR_BASE+12)	 //There can be only one video control instance using the motion detector"
#define VERROR_MOTION_DETECTION_ACCESS_DENIED		(VERROR_BASE+13)	 //There is a video contro instance using the motion detector, you cannot access this method"

#define VERROR_AUDIO_WOULDNOTOPEN					(VERROR_BASE+14)
#define VERROR_NOAUDIODEVICE_FOUND					(VERROR_BASE+15)
#define VERROR_AUDIODEVICE_INUSE					(VERROR_BASE+16)
#define VERROR_UNABLE_CREATEAVIFILE					(VERROR_BASE+17)

#define VERROR_STREAMING_IN_PROGRESS				(VERROR_BASE+20) //""




#endif //_LVSERVERDEFS_H_
