// LegoCamDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CATCH.h"
#include "LegoCamDlg.h"

#include "LVServerDefs.H"

#include <sys/timeb.h>
#include <time.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


UINT ImageProcessThread(LPVOID pParam)
{
	CLegoIP* LegoIP = (CLegoIP*)pParam;

	LegoIP->CalculateThresholds();

	LegoIP->CleanUp();

	LegoIP->BinarySimple(); 

	LegoIP->BinaryExtended(); 

	LegoIP->CalculateMarks();

	LegoIP->CalculateBlobs();

	LegoIP->DrawBlobs();

	LegoIP->SendCoordinates();
	
	return 0;				// return 0 represents success
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_MESSAGE_MAP(CLegoCamDlg, CDialog)
	//{{AFX_MSG_MAP(CLegoCamDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_start_task, OnBUTTONstarttask)
	ON_BN_CLICKED(IDC_BUTTON_stop_task, OnBUTTONstoptask)
	ON_BN_CLICKED(IDC_BUTTON_reset_cam_settings, OnBUTTONresetcamsettings)
	ON_BN_CLICKED(IDC_BUTTON_connect_disconnect_RCX, OnBUTTONconnectdisconnectRCX)
	ON_BN_CLICKED(IDC_BUTTON_check_connection, OnBUTTONcheckconnection)
	ON_BN_CLICKED(IDC_BUTTON_get_new_ref, OnBUTTONgetnewref)
	ON_EN_CHANGE(IDC_EDIT_add_threshold_BLUE, OnChangeEDITaddthresholdBLUE)
	ON_EN_CHANGE(IDC_EDIT_add_threshold_GREEN, OnChangeEDITaddthresholdGREEN)
	ON_EN_CHANGE(IDC_EDIT_add_threshold_RED, OnChangeEDITaddthresholdRED)
	ON_EN_CHANGE(IDC_EDIT_binary_ext_threshold, OnChangeEDITbinaryextthreshold)
	ON_EN_CHANGE(IDC_EDIT_binary_simple_threshold, OnChangeEDITbinarysimplethreshold)
	ON_EN_CHANGE(IDC_EDIT_cleaned_pic_norm_factor, OnChangeEDITcleanedpicnormfactor)
	ON_EN_CHANGE(IDC_EDIT_minimum_blob_size, OnChangeEDITminimumblobsize)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_add_threshold_BLUE, OnReleasedcaptureSLIDERaddthresholdBLUE)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_add_threshold_GREEN, OnReleasedcaptureSLIDERaddthresholdGREEN)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_add_threshold_RED, OnReleasedcaptureSLIDERaddthresholdRED)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_binary_ext_threshold, OnReleasedcaptureSLIDERbinaryextthreshold)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_binary_simple_threshold, OnReleasedcaptureSLIDERbinarysimplethreshold)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_minimum_blob_size, OnReleasedcaptureSLIDERminimumblobsize)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_cleaned_pic_norm_factor, OnReleasedcaptureSLIDERcleanedpicnormfactor)
	ON_BN_CLICKED(IDC_STATIC_binary_ext_pic, OnSTATICbinaryextpic)
	ON_BN_CLICKED(IDC_STATIC_binary_simple_pic, OnSTATICbinarysimplepic)
	ON_BN_CLICKED(IDC_STATIC_cleaned_pic, OnSTATICcleanedpic)
	ON_BN_CLICKED(IDC_CHECK_task1, OnCHECKtask1)
	ON_BN_CLICKED(IDC_CHECK_task2, OnCHECKtask2)
	ON_BN_CLICKED(IDC_CHECK_task3, OnCHECKtask3)
	ON_BN_CLICKED(IDC_CHECK_task4, OnCHECKtask4)
	ON_BN_CLICKED(IDC_CHECK_task5, OnCHECKtask5)
	ON_BN_CLICKED(IDC_CHECK_task6, OnCHECKtask6)
	ON_BN_CLICKED(IDC_CHECK_task7, OnCHECKtask7)
	ON_BN_CLICKED(IDC_CHECK_task8, OnCHECKtask8)
	ON_BN_CLICKED(IDC_CHECK_task9, OnCHECKtask9)
	ON_BN_CLICKED(IDCANCEL, OnClose)
	ON_CBN_SELCHANGE(IDC_COMBO_Comm, OnSelchangeCOMBOComm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_EVENTSINK_MAP(CLegoCamDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CLegoCamDlg)
	ON_EVENT(CLegoCamDlg, IDC_VIDEOPORTAL1, 1 /* PortalNotification */, OnPortalNotificationVideoportal1, VTS_I4 VTS_I4 VTS_I4 VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLegoCamDlg dialog

CLegoCamDlg::CLegoCamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLegoCamDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLegoCamDlg)
	m_v_edit_add_threshold_BLUE = 0;
	m_v_edit_add_threshold_GREEN = 0;
	m_v_edit_add_threshold_RED = 0;
	m_v_edit_binary_ext_threshold = 0;
	m_v_edit_binary_simple_threshold = 0;
	m_v_edit_cleaned_pic_norm_factor = 0;
	m_v_slider_add_threshold_BLUE = 0;
	m_v_slider_add_threshold_GREEN = 0;
	m_v_slider_add_threshold_RED = 0;
	m_v_slider_binary_ext_threshold = 0;
	m_v_slider_binary_simple_threshold = 0;
	m_v_slider_cleaned_pic_norm_factor = 0;
	m_v_slider_minimum_blob_size = 0;
	m_v_edit_minimum_blob_size = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLegoCamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLegoCamDlg)
	DDX_Control(pDX, IDC_BUTTON_reset_cam_settings, m_c_button_reset_cam);
	DDX_Control(pDX, IDC_BUTTON_get_new_ref, m_c_button_new_ref);
	DDX_Control(pDX, IDC_COMBO_Comm, m_c_combo_comm);
	DDX_Control(pDX, IDC_BUTTON_check_connection, m_c_button_check_connection);
	DDX_Control(pDX, IDC_BUTTON_stop_task, m_c_button_stop_task);
	DDX_Control(pDX, IDC_BUTTON_start_task, m_c_button_start_task);
	DDX_Control(pDX, IDC_BUTTON_connect_disconnect_RCX, m_c_button_connect_disconnect_RCX);
	DDX_Control(pDX, IDC_STATIC_binary_ext_pic, m_c_LegoDIB_binary_ext_pic);
	DDX_Control(pDX, IDC_STATIC_binary_simple_pic, m_c_LegoDIB_binary_simple_pic);
	DDX_Control(pDX, IDC_STATIC_cleaned_pic, m_c_LegoDIB_cleaned_pic);
	DDX_Control(pDX, IDC_STATIC_result_pic, m_c_LegoDIB_result_pic);
	DDX_Control(pDX, IDC_STATIC_ref_pic, m_c_LegoDIB_ref_pic);
	DDX_Control(pDX, IDC_SLIDER_minimum_blob_size, m_c_slider_minimum_blob_size);
	DDX_Control(pDX, IDC_SLIDER_binary_simple_threshold, m_c_slider_binary_simple_threshold);
	DDX_Control(pDX, IDC_SLIDER_binary_ext_threshold, m_c_slider_binary_ext_threshold);
	DDX_Control(pDX, IDC_SLIDER_cleaned_pic_norm_factor, m_c_slider_cleaned_pic_norm_factor);
	DDX_Control(pDX, IDC_SLIDER_add_threshold_RED, m_c_slider_add_threshold_RED);
	DDX_Control(pDX, IDC_SLIDER_add_threshold_GREEN, m_c_slider_add_threshold_GREEN);
	DDX_Control(pDX, IDC_SLIDER_add_threshold_BLUE, m_c_slider_add_threshold_BLUE);
	DDX_Control(pDX, IDC_EDIT_minimum_blob_size, m_c_edit_minimum_blob_size);
	DDX_Control(pDX, IDC_EDIT_cleaned_pic_norm_factor, m_c_edit_cleaned_pic_norm_factor);
	DDX_Control(pDX, IDC_EDIT_binary_simple_threshold, m_c_edit_binary_simple_threshold);
	DDX_Control(pDX, IDC_EDIT_binary_ext_threshold, m_c_edit_binary_ext_threshold);
	DDX_Control(pDX, IDC_EDIT_add_threshold_RED, m_c_edit_add_threshold_RED);
	DDX_Control(pDX, IDC_EDIT_add_threshold_GREEN, m_c_edit_add_threshold_GREEN);
	DDX_Control(pDX, IDC_EDIT_add_threshold_BLUE, m_c_edit_add_threshold_BLUE);
	DDX_Control(pDX, IDC_VIDEOPORTAL1, m_c_Video);
	DDX_Control(pDX, IDC_SPIRITCTRL1, m_c_Spirit);
	DDX_Text(pDX, IDC_EDIT_add_threshold_BLUE, m_v_edit_add_threshold_BLUE);
	DDV_MinMaxInt(pDX, m_v_edit_add_threshold_BLUE, -50, 50);
	DDX_Text(pDX, IDC_EDIT_add_threshold_GREEN, m_v_edit_add_threshold_GREEN);
	DDV_MinMaxInt(pDX, m_v_edit_add_threshold_GREEN, -50, 50);
	DDX_Text(pDX, IDC_EDIT_add_threshold_RED, m_v_edit_add_threshold_RED);
	DDV_MinMaxInt(pDX, m_v_edit_add_threshold_RED, -50, 50);
	DDX_Text(pDX, IDC_EDIT_binary_ext_threshold, m_v_edit_binary_ext_threshold);
	DDV_MinMaxInt(pDX, m_v_edit_binary_ext_threshold, 0, 100);
	DDX_Text(pDX, IDC_EDIT_binary_simple_threshold, m_v_edit_binary_simple_threshold);
	DDV_MinMaxInt(pDX, m_v_edit_binary_simple_threshold, 0, 255);
	DDX_Text(pDX, IDC_EDIT_cleaned_pic_norm_factor, m_v_edit_cleaned_pic_norm_factor);
	DDV_MinMaxInt(pDX, m_v_edit_cleaned_pic_norm_factor, 0, 255);
	DDX_Slider(pDX, IDC_SLIDER_add_threshold_BLUE, m_v_slider_add_threshold_BLUE);
	DDX_Slider(pDX, IDC_SLIDER_add_threshold_GREEN, m_v_slider_add_threshold_GREEN);
	DDX_Slider(pDX, IDC_SLIDER_add_threshold_RED, m_v_slider_add_threshold_RED);
	DDX_Slider(pDX, IDC_SLIDER_binary_ext_threshold, m_v_slider_binary_ext_threshold);
	DDX_Slider(pDX, IDC_SLIDER_binary_simple_threshold, m_v_slider_binary_simple_threshold);
	DDX_Slider(pDX, IDC_SLIDER_cleaned_pic_norm_factor, m_v_slider_cleaned_pic_norm_factor);
	DDX_Slider(pDX, IDC_SLIDER_minimum_blob_size, m_v_slider_minimum_blob_size);
	DDX_Text(pDX, IDC_EDIT_minimum_blob_size, m_v_edit_minimum_blob_size);
	DDV_MinMaxInt(pDX, m_v_edit_minimum_blob_size, 0, 1000);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CLegoCamDlg message handlers

BOOL CLegoCamDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here


	long lSize = 0;

	m_tasks = 0;
	m_BMPbuffer = NULL;

	m_cam_button_hit_counter = 0;
	
	m_c_combo_comm.InitStorage(5, 10);
	m_c_combo_comm.LimitText(5);
	m_c_combo_comm.AddString("Com 1");
	m_c_combo_comm.AddString("Com 2");
	m_c_combo_comm.AddString("Com 3");
	m_c_combo_comm.AddString("Com 4");
	m_c_combo_comm.AddString("No tower");

	m_c_slider_add_threshold_BLUE.SetRange(-50,50);
	m_c_slider_add_threshold_BLUE.SetPos(-50);
	m_c_edit_add_threshold_BLUE.SetWindowText("0");
	OnChangeEDITaddthresholdBLUE();

	m_c_slider_add_threshold_GREEN.SetRange(-50,50);
	m_c_slider_add_threshold_GREEN.SetPos(-50);
	m_c_edit_add_threshold_GREEN.SetWindowText("0");
	OnChangeEDITaddthresholdGREEN();

	m_c_slider_add_threshold_RED.SetRange(-50,50);
	m_c_slider_add_threshold_RED.SetPos(-50);
	m_c_edit_add_threshold_RED.SetWindowText("0");
	OnChangeEDITaddthresholdRED();

	m_c_slider_binary_ext_threshold.SetRange(0,50);
	m_c_edit_binary_ext_threshold.SetWindowText("25");
	OnChangeEDITbinaryextthreshold();

	m_c_slider_binary_simple_threshold.SetRange(0,255);
	m_c_edit_binary_simple_threshold.SetWindowText("100");
	OnChangeEDITbinarysimplethreshold();

	m_c_slider_cleaned_pic_norm_factor.SetRange(0,255);
	m_c_edit_cleaned_pic_norm_factor.SetWindowText("180");
	OnChangeEDITcleanedpicnormfactor();
	
	m_c_slider_minimum_blob_size.SetRange(0,1000);
	m_c_edit_minimum_blob_size.SetWindowText("250");
	OnChangeEDITminimumblobsize();

	m_RCX_connected = false;
	m_c_button_check_connection.EnableWindow(false);
	m_c_button_start_task.EnableWindow(false);
	m_c_button_stop_task.EnableWindow(false);
	m_c_button_new_ref.EnableWindow(false);
	m_c_button_reset_cam.EnableWindow(false);

	m_task_running = false;
	m_getting_reference_now = false;

	char sReg[] = "HKEY_LOCAL_MACHINE\\Software\\CATCH";
	if (!m_c_Video.PrepareControl ("LegoCamera", sReg, 0)){
		AfxMessageBox("Unable to initialize video server component !", MB_ICONINFORMATION | MB_OK, 0);
	}
	m_c_Video.EnableUIElements (UIELEMENT_STATUSBAR, 0, TRUE);
	m_c_Video.EnableUIElements (UIELEMENT_UI, 0, TRUE);
	m_c_Video.EnableUIElements (UIELEMENT_320x240, 0, TRUE);

	m_c_Video.ConnectCamera2();

	m_c_Video.SetEnablePreview (TRUE);
	m_c_Video.SetVideoFormat(320,240,24,0);
	m_c_Video.GetWindowRect(m_rcVid);
    ScreenToClient(m_rcVid);

	
	m_LegoIP.SetComm(&m_c_Spirit,1);					// give Spirit control to m_LegoIP.m_LegoComm
	
	m_c_combo_comm.SetCurSel(m_LegoIP.SearchAvailablePort());

	if (m_c_combo_comm.GetCurSel() == 4){
		m_c_combo_comm.SetCurSel(0);
		Connect_Disconnect();
		m_c_combo_comm.SetCurSel(4);
		m_c_button_connect_disconnect_RCX.EnableWindow(false);
	}
	else{
		Connect_Disconnect();		
	}


	// Check if a camera is available and data is accesible 
	// (sad but true, m_c_Video.ConnectCamera2() returns a 1 if a camera is accesible or not.)
	m_c_Video.PictureToMemory(0, 24, NULL, &lSize, NULL);
	if (lSize == 0){
	//		CDialog::OnCancel();
		AfxMessageBox("There MUST be a Logitech or LEGO VC\nCamera connected to this Computer !", MB_ICONINFORMATION | MB_OK, 0);
	}
	else{
		SetCameraSettings();
		GetReference();
		m_c_Video.StartVideoHook(0);
	}
	// end of camera checking


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLegoCamDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLegoCamDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLegoCamDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CLegoCamDlg::OnPortalNotificationVideoportal1(long lMsg, long lParam1, long lParam2, long lParam3) 
{
	// TODO: Add your control notification handler code here

// #define NOTIFICATIONMSG_VIDEOHOOK 10

	DWORD ExitCode;

	switch( lMsg ) {
    case NOTIFICATIONMSG_MOTION:
        {
			// don't care about motion
        }
        break;
    case NOTIFICATIONMSG_MOVIERECORDERROR:
        {
			// don't care, not going to capture movies
        }
        break;
    case NOTIFICATIONMSG_CAMERADETACHED:
        {
			// Oooops, no camera anymore !
			m_c_button_new_ref.EnableWindow(false);
			m_c_button_reset_cam.EnableWindow(false);
		
			m_c_Video.StopVideoHook(0);

			AfxMessageBox("Oooops, where is the camera gone ?", MB_ICONINFORMATION | MB_OK);
		}
        break;
    case NOTIFICATIONMSG_CAMERAREATTACHED:
        {
			// Here it is again !		
		    AfxMessageBox("Found a camera !!", MB_ICONINFORMATION | MB_OK);
			SetCameraSettings();
			GetReference();
			m_c_Video.StartVideoHook(0);

		}
        break;
    case NOTIFICATIONMSG_IMAGESIZECHANGE:
        {
			// Image resolution was changed
			AfxMessageBox("When changing image resolution it is REQUIRED to take a new reference picture !\n\nPlease prepare camera for taking this picture !\n\nPlease do NOT use the extended camera menu to change the resolution.\nIt is not possible to catch this event ! The software will fail !", MB_ICONINFORMATION | MB_OK , 0);
			GetReference();
		}
        break;
    case NOTIFICATIONMSG_CAMERAPRECHANGE:
        {
			// NOT USED ! so don't care
        }
        break;
    case NOTIFICATIONMSG_CAMERACHANGEFAILED:
        {
			// Not going to switch between several cameras, so don't care
        }
        break;
    case NOTIFICATIONMSG_POSTCAMERACHANGED:
        {
			// Again not going to switch between several cameras , so don't care
        }
        break;
    case NOTIFICATIONMSG_CAMERBUTTONCLICKED:
        {
			// Hmmm, what interesting could happen if someone presses the camera-button ?
			CamButton();
        }
        break;
    case NOTIFICATIONMSG_VIDEOHOOK:
        {
            LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER) lParam1;
            LPBYTE lpBytes = (LPBYTE) lParam2;

			if (!m_task_running){				// Is another task running ??
				if (!m_getting_reference_now){	// Is the software getting a reference picture in this moment ??
					m_task_running = true;		// Prevent software to start another task
					m_LegoIP.GetValues(	m_v_edit_cleaned_pic_norm_factor,
										m_v_edit_binary_simple_threshold,
										m_v_edit_add_threshold_RED,
										m_v_edit_add_threshold_GREEN,
										m_v_edit_add_threshold_BLUE,
										m_v_edit_binary_ext_threshold,
										m_v_edit_minimum_blob_size);				

					m_LegoDIB_work_pic = lpbi;
					
					IPThread = AfxBeginThread(ImageProcessThread,&m_LegoIP,THREAD_PRIORITY_NORMAL,0,CREATE_SUSPENDED);
					IPThread->m_bAutoDelete = FALSE;
					IPThread->ResumeThread();
				}
			}
			else{
				::GetExitCodeThread(IPThread->m_hThread,&ExitCode);
				if (ExitCode != STILL_ACTIVE)
					m_task_running = false;	// Task is done, allow to start a new task
			}
		}
        break;
    case NOTIFICATIONMSG_SETTINGDLGCLOSED:
        {
			// NOT USED ! so don't care
        }
        break;
    case NOTIFICATIONMSG_QUERYPRECAMERAMODIFICATION:
        {
			// NOT USED ! so don't care
        }
        break;
    case NOTIFICATIONMSG_MOVIESIZE:
        {
			// don't care, not going to capture movies
        }
        break;
    default:
        break;
    } // switch
}

void CLegoCamDlg::OnBUTTONstarttask() 
{
	// TODO: Add your control notification handler code here
	m_LegoIP.StartTasks(m_tasks);
}

void CLegoCamDlg::OnBUTTONstoptask()
{
	// TODO: Add your control notification handler code here
	m_LegoIP.StopTasks(m_tasks);
}

void CLegoCamDlg::OnBUTTONresetcamsettings() 
{
	// TODO: Add your control notification handler code here
	SetCameraSettings();
	if (AfxMessageBox("It's recommended to take a new reference picture !\n\nShould this be done now ?", MB_ICONINFORMATION | MB_YESNO   , 0) == IDYES)
		GetReference();
}

void CLegoCamDlg::OnBUTTONconnectdisconnectRCX() 
{
	// TODO: Add your control notification handler code here
	Connect_Disconnect();
}

void CLegoCamDlg::OnBUTTONcheckconnection() 
{
	// TODO: Add your control notification handler code here
	m_LegoIP.CheckConnection();
}

void CLegoCamDlg::OnBUTTONgetnewref() 
{
	// TODO: Add your control notification handler code here
	GetReference();
}

void CLegoCamDlg::OnChangeEDITaddthresholdBLUE() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
	CString temptext;
	
	m_c_edit_add_threshold_BLUE.GetWindowText(temptext);
	m_v_edit_add_threshold_BLUE = atoi(temptext);
	m_c_slider_add_threshold_BLUE.SetPos(m_v_edit_add_threshold_BLUE);
}

void CLegoCamDlg::OnChangeEDITaddthresholdGREEN() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
	CString temptext;
	
	m_c_edit_add_threshold_GREEN.GetWindowText(temptext);
	m_v_edit_add_threshold_GREEN = atoi(temptext);
	m_c_slider_add_threshold_GREEN.SetPos(m_v_edit_add_threshold_GREEN);
}

void CLegoCamDlg::OnChangeEDITaddthresholdRED() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
	CString temptext;
	
	m_c_edit_add_threshold_RED.GetWindowText(temptext);
	m_v_edit_add_threshold_RED = atoi(temptext);
	m_c_slider_add_threshold_RED.SetPos(m_v_edit_add_threshold_RED);
}

void CLegoCamDlg::OnChangeEDITbinaryextthreshold() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	CString temptext;
	
	m_c_edit_binary_ext_threshold.GetWindowText(temptext);
	m_v_edit_binary_ext_threshold = atoi(temptext);
	m_c_slider_binary_ext_threshold.SetPos(m_v_edit_binary_ext_threshold);
}

void CLegoCamDlg::OnChangeEDITbinarysimplethreshold() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	CString temptext;
	
	m_c_edit_binary_simple_threshold.GetWindowText(temptext);
	m_v_edit_binary_simple_threshold = atoi(temptext);
	m_c_slider_binary_simple_threshold.SetPos(m_v_edit_binary_simple_threshold);
}

void CLegoCamDlg::OnChangeEDITcleanedpicnormfactor() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	CString temptext;
	
	m_c_edit_cleaned_pic_norm_factor.GetWindowText(temptext);
	m_v_edit_cleaned_pic_norm_factor = atoi(temptext);
	m_c_slider_cleaned_pic_norm_factor.SetPos(m_v_edit_cleaned_pic_norm_factor);
}

void CLegoCamDlg::OnChangeEDITminimumblobsize() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
	CString temptext;
	
	m_c_edit_minimum_blob_size.GetWindowText(temptext);
	m_v_edit_minimum_blob_size = atoi(temptext);
	m_c_slider_minimum_blob_size.SetPos(m_v_edit_minimum_blob_size);
}

void CLegoCamDlg::OnReleasedcaptureSLIDERaddthresholdBLUE(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_add_threshold_BLUE = m_c_slider_add_threshold_BLUE.GetPos();
	itoa (m_v_edit_add_threshold_BLUE,temptext,10);
	m_c_edit_add_threshold_BLUE.SetWindowText(temptext);

	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERaddthresholdGREEN(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_add_threshold_GREEN = m_c_slider_add_threshold_GREEN.GetPos();
	itoa (m_v_edit_add_threshold_GREEN,temptext,10);
	m_c_edit_add_threshold_GREEN.SetWindowText(temptext);

	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERaddthresholdRED(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_add_threshold_RED = m_c_slider_add_threshold_RED.GetPos();
	itoa (m_v_edit_add_threshold_RED,temptext,10);
	m_c_edit_add_threshold_RED.SetWindowText(temptext);
	
	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERbinaryextthreshold(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	char* temptext;

	temptext = new char [10];
	
	m_v_edit_binary_ext_threshold = m_c_slider_binary_ext_threshold.GetPos();
	itoa (m_v_edit_binary_ext_threshold,temptext,10);
	m_c_edit_binary_ext_threshold.SetWindowText(temptext);
	
	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERbinarysimplethreshold(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_binary_simple_threshold = m_c_slider_binary_simple_threshold.GetPos();
	itoa (m_v_edit_binary_simple_threshold,temptext,10);
	m_c_edit_binary_simple_threshold.SetWindowText(temptext);
	
	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERcleanedpicnormfactor(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_cleaned_pic_norm_factor = m_c_slider_cleaned_pic_norm_factor.GetPos();
	itoa (m_v_edit_cleaned_pic_norm_factor,temptext,10);
	m_c_edit_cleaned_pic_norm_factor.SetWindowText(temptext);
	
	*pResult = 0;
}

void CLegoCamDlg::OnReleasedcaptureSLIDERminimumblobsize(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	char* temptext;
	
	temptext = new char [10];
	
	m_v_edit_minimum_blob_size = m_c_slider_minimum_blob_size.GetPos();
	itoa (m_v_edit_minimum_blob_size,temptext,10);
	m_c_edit_minimum_blob_size.SetWindowText(temptext);
	
	*pResult = 0;
}

void CLegoCamDlg::OnSTATICbinaryextpic() 
{
	// TODO: Add your control notification handler code here

}

void CLegoCamDlg::OnSTATICbinarysimplepic() 
{
	// TODO: Add your control notification handler code here
	
}

void CLegoCamDlg::OnSTATICcleanedpic() 
{
	// TODO: Add your control notification handler code here
	
}


void CLegoCamDlg::OnCHECKtask1() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x1;					// set/unset bit 1 as mark for task 1 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask2() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x2;					// set/unset bit 2 as mark for task 2 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask3() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x4;					// set/unset bit 3 as mark for task 3 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask4() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x8;					// set/unset bit 4 as mark for task 4 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask5() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x10;					// set/unset bit 5 as mark for task 5 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask6() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x20;					// set/unset bit 6 as mark for task 6 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask7() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x40;					// set/unset bit 7 as mark for task 7 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask8() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x80;					// set/unset bit 8 as mark for task 8 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnCHECKtask9() 
{
	// TODO: Add your control notification handler code here
	m_tasks ^= 0x100;				// set/unset bit 9 as mark for task 9 should be started/stoped
	if (m_tasks > 0 && m_RCX_connected){
		m_c_button_start_task.EnableWindow(true);
		m_c_button_stop_task.EnableWindow(true);
	}
	else{
		m_c_button_start_task.EnableWindow(false);
		m_c_button_stop_task.EnableWindow(false);
	}
}


void CLegoCamDlg::OnClose() 
{
	// TODO: Add your control notification handler code here
	if (m_RCX_connected)
		m_LegoIP.CloseComm();


	CDialog::OnCancel();

	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}


int CLegoCamDlg::Connect_Disconnect()
{
	if (m_RCX_connected){
		if (m_LegoIP.CloseComm()){
			m_RCX_connected = false;
			m_c_combo_comm.EnableWindow(true);
			m_c_button_check_connection.EnableWindow(false);
			m_c_button_start_task.EnableWindow(false);
			m_c_button_stop_task.EnableWindow(false);
			m_c_button_connect_disconnect_RCX.SetWindowText("Connect to RCX");
			return 1;
		}
		else{
			AfxMessageBox("Disconnect failed !", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	}
	else {
		if (m_LegoIP.InitComm(m_c_combo_comm.GetCurSel()+1)){
			m_RCX_connected = true;
			m_c_combo_comm.EnableWindow(false);
			m_c_button_check_connection.EnableWindow(true);
			m_c_button_connect_disconnect_RCX.SetWindowText("Disconnect from RCX");
			if (m_tasks > 0){
				m_c_button_start_task.EnableWindow(true);
				m_c_button_stop_task.EnableWindow(true);
			}
			return 1;
		}
		else{
//			AfxMessageBox("Connect failed !", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	}
}


void CLegoCamDlg::SetCameraSettings()
{
	int timestampold = 0;
	int timestampnew = 0;
	long propertyvalue = 0;
	struct _timeb timebuffer;

	AfxMessageBox("Calibrating camera settings !!\n\nThis will take about 20 seconds !!\n\nPlease be patient !!", MB_ICONINFORMATION | MB_OK, 0);

	_ftime( &timebuffer );
	timestampold = timebuffer.time + 18;  // wait 18 seconds for autogain and autowhite

	m_c_Video.SetCameraPropertyLong (PROPERTY_AUTO_WHITELEVEL,ADJUSTMENT_AUTOMATIC);
	m_c_Video.SetCameraPropertyLong (PROPERTY_AUTO_ANALOGGAIN,ADJUSTMENT_AUTOMATIC);
	m_c_Video.SetCameraPropertyLong (PROPERTY_COLORBOOST,TRUE);
	m_c_Video.SetCameraPropertyLong (PROPERTY_ANTIFLICKER,ANTIFLICKER_50Hz);
	m_c_Video.SetCameraPropertyLong (PROPERTY_OPTIMIZATION_SPEED_QUALITY,OPTIMIZE_QUALITY);
	m_c_Video.SetCameraPropertyLong (PROPERTY_SATURATION,255);

	while (timestampnew < timestampold){
		_ftime( &timebuffer );
		timestampnew = timebuffer.time;
	}

	_ftime( &timebuffer );
	timestampold = timebuffer.time + 2;  // wait 2 seconds for increased analoggain

	m_c_Video.SetCameraPropertyLong (PROPERTY_AUTO_WHITELEVEL,ADJUSTMENT_MANUAL);
	m_c_Video.SetCameraPropertyLong (PROPERTY_AUTO_ANALOGGAIN,ADJUSTMENT_MANUAL);
	m_c_Video.GetCameraPropertyLong(PROPERTY_ANALOGGAIN,&propertyvalue);
	m_c_Video.SetCameraPropertyLong (PROPERTY_ANALOGGAIN,propertyvalue+35);

	while (timestampnew < timestampold){
		_ftime( &timebuffer );
		timestampnew = timebuffer.time;
	}
}

void CLegoCamDlg::GetReference()
{
	long lSize = 0;
	long i = 0;
	m_getting_reference_now = true;		// prevent image processing thread to start again while
							// taking reference picture
	m_c_button_new_ref.EnableWindow(true);
	m_c_button_reset_cam.EnableWindow(true);
	
	m_c_Video.PictureToMemory(0, 24, NULL, &lSize, NULL);
    if (!m_BMPbuffer) {
		m_BMPbuffer = (LPBYTE)malloc(lSize);
	}
    if (!m_BMPbuffer) {
        AfxMessageBox("Insufficient memory (?!?)", MB_ICONINFORMATION | MB_OK);
    }
    m_c_Video.PictureToMemory(0, 24, (long)m_BMPbuffer, &lSize, NULL);
    LPBITMAPINFOHEADER pbi = (LPBITMAPINFOHEADER)(m_BMPbuffer + sizeof (BITMAPFILEHEADER));
	m_c_LegoDIB_ref_pic = pbi;
	Invalidate(true);
	
	m_LegoDIB_work_pic = pbi;
	m_c_LegoDIB_cleaned_pic = pbi;
	m_c_LegoDIB_binary_simple_pic = pbi;
	m_c_LegoDIB_binary_ext_pic = pbi;
	m_LegoDIB_blobs_pic = pbi;
	m_c_LegoDIB_result_pic = pbi;

	m_c_LegoDIB_cleaned_pic.ClearPic(255);
	m_c_LegoDIB_binary_simple_pic.ClearPic(255);
	m_c_LegoDIB_binary_ext_pic.ClearPic(255);
	m_LegoDIB_blobs_pic.ClearPic(255);
	m_c_LegoDIB_result_pic.ClearPic(255);


	m_LegoIP.GetWorkDIB(&m_LegoDIB_work_pic);
	m_LegoIP.GetRefDIB(&m_c_LegoDIB_ref_pic);
	m_LegoIP.GetCleanedDIB(&m_c_LegoDIB_cleaned_pic);
	m_LegoIP.GetBinarySimpleDIB (&m_c_LegoDIB_binary_simple_pic);
	m_LegoIP.GetBinaryExtDIB(&m_c_LegoDIB_binary_ext_pic);
	m_LegoIP.GetResultDIB (&m_c_LegoDIB_result_pic);
	m_LegoIP.GetBlobDIB (&m_LegoDIB_blobs_pic);

	m_LegoIP.SetArraySize (m_LegoDIB_work_pic.NoOfPixel());
    
	m_LegoIP.SetupMarksArray();

	m_LegoIP.SetupEquiListArray();
	
	m_LegoIP.SetupBlobsArray();

	free (m_BMPbuffer);
	m_BMPbuffer = NULL;

	m_getting_reference_now = false;		// allow image processing thread to start again
								// ready with taking reference picture
}


void CLegoCamDlg::OnSelchangeCOMBOComm() 
{
	// TODO: Add your control notification handler code here
	if (m_c_combo_comm.GetCurSel() == 4){
		m_c_button_connect_disconnect_RCX.EnableWindow(false);
	}
	else{
		m_c_button_connect_disconnect_RCX.EnableWindow(true);
	}
 
}

void CLegoCamDlg::CamButton()
{
	m_cam_button_hit_counter++;
	switch (m_cam_button_hit_counter){

	case 1 :	AfxMessageBox("Hey, you found me ! I'm the camera button !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 2 :	AfxMessageBox("Yeah, i'm the camera-button !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 3 :	AfxMessageBox("Yes, i am the camera-button !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 4 :	AfxMessageBox("You don't believe me ?", MB_ICONQUESTION | MB_OK);
				break;
	case 5 :	AfxMessageBox("Believe me ! I am the camera button !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 6 :	AfxMessageBox("What do you expect me to do ?\nMake a picture ?\nGrab a video ?\n\nNo, thanks !", MB_ICONQUESTION | MB_OK);
				break;
	case 7 :	AfxMessageBox("Booh !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 8 :	AfxMessageBox("How often are you going to hit me ?", MB_ICONQUESTION | MB_OK);
				break;
	case 9 :	AfxMessageBox("Well, that's boring ! I won't answer you any longer !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 10 :	// AfxMessageBox("", MB_ICONINFORMATION | MB_OK);
				break;
	case 11 :	// AfxMessageBox("", MB_ICONINFORMATION | MB_OK);
				break;
	case 12 :	// AfxMessageBox("", MB_ICONINFORMATION | MB_OK);
				break;
	case 13 :	AfxMessageBox("Okay, okay, I'm here !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 14 :	AfxMessageBox("Why do you pester me ?", MB_ICONQUESTION | MB_OK);
				break;
	case 15 :	AfxMessageBox("Formating drive C:\n\nAll data will be lost !\n\nAre you sure ?", MB_ICONEXCLAMATION     | MB_OK);
				break;
	case 16 :	AfxMessageBox("Hehehe !", MB_ICONEXCLAMATION     | MB_OK);
				break;
	case 17 :	AfxMessageBox("Okay, it was funny till now. If you don't stop bothering me, I'll kill this application !", MB_ICONEXCLAMATION    | MB_OK);
				break;
	case 18 :	AfxMessageBox("You don't believe anything do you ?", MB_ICONQUESTION | MB_OK);
				break;
	case 19 :	AfxMessageBox("Stop it now ! Your last chance !", MB_ICONSTOP | MB_OK);
				break;
	case 20 :	OnClose();
				break;
	}
}
