// LegoComm.cpp: implementation of the CLegoComm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CATCH.h"
#include "LegoComm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLegoComm::CLegoComm()
{
	m_Spirit = NULL;
}

CLegoComm::~CLegoComm()
{

}


void CLegoComm::SetComm(CSpirit *DlgComm, int port)
{
	m_Spirit = DlgComm;										// m_Spirit is the same instance of CSpirit as the instance
															// of CSpirit in the LegoCamDlg !!  ->  ATTENTION !

	m_Spirit->SetLinkType(0);								// 0 = IR
	m_Spirit->SetPBrick(1);									// 1 = RCX, 0 = CyberMaster
	m_Spirit->SetRetransmitRetries(0,5);					// don't try to send immediate data again
}															// try to download data 5 times 

int CLegoComm::InitComm (int CommNumber)
{
				
	connected = false;

	m_Spirit->SetComPortNo(CommNumber);						// set COMport to open (CommNumber)
	
	if (!m_Spirit->InitComm()) {							// Set up the comms	
		AfxMessageBox("Unable to open serial port !!", MB_ICONINFORMATION | MB_OK, 0);
		return 0;
	}
	else {
		if (!m_Spirit->TowerAndCableConnected()){			// There's no tower or cable present at COM (port)
			AfxMessageBox("Cable or Tower NOT OK !!", MB_ICONINFORMATION | MB_OK, 0);
			m_Spirit->CloseComm();
			return 0;
		}
		else{
			if (!m_Spirit->TowerAlive ()){					// The tower is not alive, battery will be bad 
				AfxMessageBox("Tower not alive !! \nBad battery ??", MB_ICONINFORMATION | MB_OK, 0);
				m_Spirit->CloseComm();
				return 0;
			}
			else {
				m_Spirit->PBTxPower(1);
				if (!m_Spirit->PBAliveOrNot()){				// No RCX in reach or reaching distance
					AfxMessageBox("Can't reach RCX !!", MB_ICONINFORMATION | MB_OK, 0);
					m_Spirit->CloseComm();
					return 0;
				}
				else{
					if (!m_Spirit->StartTask(0)){			// Try to start task 0 on RCX but doesn't work 	
						AfxMessageBox("Unable to start task main (task 0) !!", MB_ICONINFORMATION | MB_OK, 0);
						m_Spirit->CloseComm();
						return 0;
					}
					else{
						m_Spirit->PlaySystemSound(3);
						connected = true;
						return 1;							// 1 -> true ; Task main on RCX started !!
					}
				}
			}
		}
	}
}

int CLegoComm::CheckPort (int CommNumber)
{
				
	m_Spirit->SetComPortNo(CommNumber);						// set COMport to open (CommNumber)
	
	if (!m_Spirit->InitComm()) {							// Set up the comms	
		return 0;
	}
	else {
		if (!m_Spirit->TowerAndCableConnected()){			// There's no tower or cable present at COM (port)
			m_Spirit->CloseComm();
			return 0;
		}
		else{
			m_Spirit->CloseComm();
			return 1;									// 1 -> true ; Tower available at this port !!
		}
	}
}

int CLegoComm::CloseComm()
{
	connected = false;
	m_Spirit->StopAllTasks();
	m_Spirit->PlaySystemSound(2);
	return m_Spirit->CloseComm();
}

void CLegoComm::CheckConnection()
{
	m_Spirit->PlaySystemSound(5);
}

int CLegoComm::StartTasks(USHORT bit_per_task)
{
	int rc = 0;
	if (bit_per_task & 0x1)
		if (m_Spirit->StartTask(1)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 1 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x2)
		if (m_Spirit->StartTask(2)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 2 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x4)
		if (m_Spirit->StartTask(3)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 3 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x8)
		if (m_Spirit->StartTask(4)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 4 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x10)
		if (m_Spirit->StartTask(5)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 5 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x20)
		if (m_Spirit->StartTask(6)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 6 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x40)
		if (m_Spirit->StartTask(7)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 7 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x80)
		if (m_Spirit->StartTask(8)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 8 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x100)
		if (m_Spirit->StartTask(9)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to start task 9 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	return rc;
}

int CLegoComm::StopTasks(USHORT bit_per_task)
{
	int rc = 0;
	if (bit_per_task & 0x1FF)
		if (m_Spirit->StopAllTasks()){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop all tasks !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}

	if (bit_per_task & 0x1)
		if (m_Spirit->StopTask(1)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 1 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x2)
		if (m_Spirit->StopTask(2)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 2 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x4)
		if (m_Spirit->StopTask(3)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 3 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x8)
		if (m_Spirit->StopTask(4)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 4 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x10)
		if (m_Spirit->StopTask(5)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 5 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x20)
		if (m_Spirit->StopTask(6)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 6 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x40)
		if (m_Spirit->StopTask(7)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 7 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x80)
		if (m_Spirit->StopTask(8)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 8 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	if (bit_per_task & 0x100)
		if (m_Spirit->StopTask(9)){
			rc = 1;
		}
		else {
			AfxMessageBox("Unable to stop task 9 !!", MB_ICONINFORMATION | MB_OK, 0);
			return 0;
		}
	return rc;
}


void CLegoComm::SendData (	short blue_x,
							short blue_y,
							short green_x,
							short green_y,
							short cyan_x,
							short cyan_y,
							short red_x,
							short red_y,
							short magenta_x,
							short magenta_y,
							short yellow_x,
							short yellow_y)
{

	if (connected){				// No RCX in reach or reaching distance
		if (m_Spirit->Poll(0,12)){  // is it allowed to send data ? (Is RCX ready and waiting for new data ?)
	
			if (blue_x && blue_y){
				// Send X - Y Coordinates of blue blob to Variable 0 and 1
				m_Spirit->SetVar( 0,2,(short)blue_x);
				m_Spirit->SetVar( 1,2,(short)blue_y);
			}
			if (green_x && green_y){
				// Send X - Y Coordinates of green blob to Variable 0 and 1
				m_Spirit->SetVar( 2,2,(short)green_x);
				m_Spirit->SetVar( 3,2,(short)green_y);
			}
			if (cyan_x && cyan_y){
				// Send X - Y Coordinates of cyan blob to Variable 0 and 1
				m_Spirit->SetVar( 4,2,(short)cyan_x);
				m_Spirit->SetVar( 5,2,(short)cyan_y);
			}
			if (red_x && red_y){
				// Send X - Y Coordinates of red blob to Variable 0 and 1
				m_Spirit->SetVar( 6,2,(short)red_x);
				m_Spirit->SetVar( 7,2,(short)red_y);
			}
			if (magenta_x && magenta_y){
				// Send X - Y Coordinates of magenta blob to Variable 0 and 1
				m_Spirit->SetVar( 8,2,(short)magenta_x);
				m_Spirit->SetVar( 9,2,(short)magenta_y);
			}
			if (yellow_x && yellow_y){
				// Send X - Y Coordinates of yellow blob to Variable 0 and 1
				m_Spirit->SetVar(10,2,(short)yellow_x);
				m_Spirit->SetVar(11,2,(short)yellow_y);
			}		
			m_Spirit->SetVar(12,2,(short)0);	// Let RCX know that valid data were send !
		}
	}
}

