// LegoDIB.cpp : implementation file
//

#include "stdafx.h"
#include "CATCH.h"
#include "LegoDIB.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define on_full		255
#define off			0

static int BmiRowSize(const LPBITMAPINFOHEADER pbi)
{
    return ((pbi->biBitCount * pbi->biWidth) + 31) / 32 * 4;
}

static int BmiColors(const LPBITMAPINFOHEADER pbi)
{
    int nColors = pbi->biClrUsed;
    if (nColors == 0) {
        nColors = (1 << pbi->biBitCount) & 0x1FF;
    }
    return nColors;
}


static size_t BmiSize(const LPBITMAPINFOHEADER pbi)
{
    size_t s = pbi->biSize + BmiColors(pbi) * sizeof (RGBQUAD);
    if (pbi->biSizeImage) {
        s += pbi->biSizeImage;
    } else {
        s += pbi->biHeight * BmiRowSize(pbi);
    }
    return s;
} // BmiSize


static BYTE* BmiFindBits(LPBITMAPINFOHEADER pbi)
{
    BYTE* lp = (BYTE*)pbi;
    return lp + pbi->biSize + BmiColors(pbi) * sizeof (RGBQUAD);
} // BmiFindBits




/////////////////////////////////////////////////////////////////////////////
// CLegoDIB

CLegoDIB::CLegoDIB()
{
	m_pDIB = NULL;
	m_pDIBpixel = NULL;
}

CLegoDIB::CLegoDIB( const CLegoDIB & copythis)
{
    if (m_pDIB) {
        free(m_pDIB); m_pDIB = NULL; m_pDIBpixel = NULL;
    }
    if (copythis.m_pDIB) {
        size_t nb = BmiSize(copythis.m_pDIB);
        m_pDIB = (LPBITMAPINFOHEADER)malloc(nb);
        memcpy(m_pDIB, copythis.m_pDIB, nb);
        m_pDIBpixel = BmiFindBits(m_pDIB);
    }
}

CLegoDIB::CLegoDIB( const LPBITMAPINFOHEADER copythis)
{
    if (m_pDIB) {
        free(m_pDIB); m_pDIB = NULL; m_pDIBpixel = NULL;
    }
    if (copythis) {
        size_t nb = BmiSize(copythis);
        m_pDIB = (LPBITMAPINFOHEADER)malloc(nb);
        memcpy(m_pDIB, copythis, nb);
        m_pDIBpixel = BmiFindBits(m_pDIB);
    }
}


CLegoDIB::~CLegoDIB()
{
}


BEGIN_MESSAGE_MAP(CLegoDIB, CStatic)
	//{{AFX_MSG_MAP(CLegoDIB)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLegoDIB message handlers



void CLegoDIB::operator = (const CLegoDIB & assign_this)
{
    if (m_pDIB) {
        free(m_pDIB); m_pDIB = NULL; m_pDIBpixel = NULL;
    }
    if (assign_this.m_pDIB) {
        size_t nb = BmiSize(assign_this.m_pDIB);
        m_pDIB = (LPBITMAPINFOHEADER)malloc(nb);
        memcpy(m_pDIB, assign_this.m_pDIB, nb);
        m_pDIBpixel = BmiFindBits(m_pDIB);
    }
}

void CLegoDIB::operator = (const LPBITMAPINFOHEADER assign_this)
{
    if (m_pDIB) {
        free(m_pDIB); m_pDIB = NULL; m_pDIBpixel = NULL;
    }
    if (assign_this) {
        size_t nb = BmiSize(assign_this);
        m_pDIB = (LPBITMAPINFOHEADER)malloc(nb);
        memcpy(m_pDIB, assign_this, nb);
        m_pDIBpixel = BmiFindBits(m_pDIB);
    }
}

void CLegoDIB::operator /= (const CLegoDIB & divisor)
{
	long size_this = m_pDIB->biSizeImage;
	long size_divisor = divisor.m_pDIB->biSizeImage;

	if (size_this != 0 && size_divisor != 0){
		if (size_this == size_divisor){
			for (int i = 0; i < size_this; i++){
				if (divisor.m_pDIBpixel[i] > 0)
					m_pDIBpixel[i] /= divisor.m_pDIBpixel[i];
			}
		}
	}
}

void CLegoDIB::operator *= (const BYTE multi)
{
	long size_this = m_pDIB->biSizeImage;

	if (size_this != 0){
		for (int i = 0; i < size_this; i++){
			m_pDIBpixel[i] *= multi;
		}
	}
}


LPBITMAPINFOHEADER CLegoDIB::GetBMPHeader()
{
	return m_pDIB;
}

void CLegoDIB::CopyDIBToScreen(LPBITMAPINFOHEADER pDIB)
{
    if (m_pDIB) {
        free(m_pDIB); m_pDIB = NULL; m_pDIBpixel = NULL;
    }
    if (pDIB) {
        size_t nb = BmiSize(pDIB);
        m_pDIB = (LPBITMAPINFOHEADER)malloc(nb);
        memcpy(m_pDIB, pDIB, nb);
        m_pDIBpixel = BmiFindBits(m_pDIB);
    }
    if (m_hWnd) {
        Invalidate(TRUE);
    }
}



void CLegoDIB::DrawDIB(CDC &dc, CRect rc)
{
    if (m_pDIB) {
        HDRAWDIB hdd = DrawDibOpen();
        if (hdd) {
            DrawDibDraw(hdd, dc.m_hDC,
                rc.left, rc.top,       // xDst, yDst,
                rc.Width(), rc.Height(),
                m_pDIB,
                m_pDIBpixel,
                0,
				0,
                m_pDIB->biWidth, m_pDIB->biHeight,
                0);
            
            DrawDibClose(hdd);
        }
    } else {
        dc.FillSolidRect(rc, RGB(192, 192, 192));
    }
}

void CLegoDIB::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CStatic::OnPaint() for painting messages

    CRect rc;
    GetClientRect(rc);
    DrawDIB(dc, rc);
}


void CLegoDIB::BinarySimple(int threshold_red, int threshold_green, int threshold_blue, CLegoDIB* work)
{
	int i = 0;
	int height = m_pDIB->biHeight;
	int width = m_pDIB->biWidth;
	int pixel_size = sizeof (RGBTRIPLE);
	int row = width  * pixel_size;
	int size = row * height;

	for (i = 0; i < size; i += pixel_size){					// every pixel
		if (work->m_pDIBpixel[i] >= threshold_blue)
			m_pDIBpixel[i] = on_full;							// this pixel is blue !
		else
			m_pDIBpixel[i] = off;								// this pixel is not blue !
		if (work->m_pDIBpixel[i+1] >= threshold_green)
			m_pDIBpixel[i+1] = on_full;							// this pixel is green !
		else
			m_pDIBpixel[i+1] = off;							// this pixel is not green !
		if (work->m_pDIBpixel[i+2] >= threshold_red)
			m_pDIBpixel[i+2] = on_full;							// this pixel is red !
		else
			m_pDIBpixel[i+2] = off;							// this pixel is not red !
	}
    if (m_hWnd) {
        Invalidate(TRUE);
	}

}

void CLegoDIB::Binary(int threshold_red, int threshold_green, int threshold_blue, int threshold_ext, CLegoDIB* work)
{
	int i = 0;
	int height = m_pDIB->biHeight;
	int width = m_pDIB->biWidth;
	int pixel_size = sizeof (RGBTRIPLE);
	int row = width  * pixel_size;
	long size = row * height;
	int extended = threshold_ext;
	
	long this_pixel_blue = off;
	long left_pixel_blue = off;
	long upper_pixel_blue = off;

	long this_pixel_green = off;
	long left_pixel_green = off;
	long upper_pixel_green = off;
	
	long this_pixel_red = off;
	long left_pixel_red = off;
	long upper_pixel_red = off;

	for (i = 0; i < row; i += pixel_size){						// first (bottom) row has to be background
																// color (white) for binarysation		
		m_pDIBpixel[i]		= on_full;								// full blue
		m_pDIBpixel[i+1]	= on_full;								// full green				
		m_pDIBpixel[i+2]	= on_full;								// full red
	}
	for (i = 0; i < size; i += row){							// first (very left) column has to be background
																// color (white) for binarysation		
		m_pDIBpixel[i]		= on_full;								// full blue
		m_pDIBpixel[i+1]	= on_full;								// full green
		m_pDIBpixel[i+2]	= on_full;								// full red
	}
	
	for (i = row+pixel_size; i < size; i += pixel_size){					// every pixel except first row
		if (i % row){											// every pixel except first column
			extended = threshold_ext;

			this_pixel_blue = i;
			left_pixel_blue = i - pixel_size;
			upper_pixel_blue = i - row;

			this_pixel_green = i + 1;
			left_pixel_green = (i - pixel_size) + 1;
			upper_pixel_green = (i - row) + 1;
	
			this_pixel_red = i + 2;
			left_pixel_red = (i - pixel_size) + 2;
			upper_pixel_red = (i - row) + 2;

//	check blue
			if (m_pDIBpixel[left_pixel_blue] && m_pDIBpixel[upper_pixel_blue]){		// previous column (blue) && previous row (blue)
				extended *= -1;									// -> with negativ threshold	
				extended /= 2;									// for a better result	
			}
			else if (m_pDIBpixel[left_pixel_blue] || m_pDIBpixel[upper_pixel_blue]){	// previous column (blue) || previous row (blue)
				extended = 0;									// -> without any threshold	
			}
//			else	-> default, so don't check this explicit	// !previous column (blue) && !previous row (blue)
																// -> with positiv threshold
			if (work->m_pDIBpixel[this_pixel_blue] >= (threshold_blue + extended))
				m_pDIBpixel[this_pixel_blue] = on_full;							// this pixel is blue !
			else
				m_pDIBpixel[this_pixel_blue] = off;								// this pixel is not blue !

//	check green
			if (m_pDIBpixel[left_pixel_green] && m_pDIBpixel[upper_pixel_green]){		// previous column (green) && previous row (blue)
				extended *= -1;									// -> with negativ threshold	
				extended /= 2;									// for a better result	
			}
			else if (m_pDIBpixel[left_pixel_green] || m_pDIBpixel[upper_pixel_green]){	// previous column (green) || previous row (blue)
				extended = 0;									// -> without any threshold	
			}
//			else	-> default, so don't check this explicit	// !previous column (green) && !previous row (blue)
																// -> with positiv threshold
			if (work->m_pDIBpixel[this_pixel_green] >= (threshold_green + extended))
				m_pDIBpixel[this_pixel_green] = on_full;							// this pixel is green !
			else
				m_pDIBpixel[this_pixel_green] = off;							// this pixel is not green !

//	check red
			if (m_pDIBpixel[left_pixel_red] && m_pDIBpixel[upper_pixel_red]){		// previous column (red) && previous row (blue)
				extended *= -1;									// -> with negativ threshold	
				extended /= 2;									// for a better result	
			}
			else if (m_pDIBpixel[left_pixel_red] || m_pDIBpixel[upper_pixel_red]){	// previous column (red) || previous row (blue)
				extended = 0;								// -> without any threshold	
			}
//			else	-> default, so don't check this explicit	// !previous column (red) && !previous row (blue)
																// -> with positiv threshold
			if (work->m_pDIBpixel[this_pixel_red] >= (threshold_red + extended))
				m_pDIBpixel[this_pixel_red] = on_full;							// this pixel is red !
			else
				m_pDIBpixel[this_pixel_red] = off;							// this pixel is not red !

		}
	}
    if (m_hWnd) {
        Invalidate(TRUE);
	}

}

void CLegoDIB::DividePic(const int multi,const CLegoDIB* work, const CLegoDIB* divisor)
{
	long size_work = work->m_pDIB->biSizeImage;
	long size_divisor = divisor->m_pDIB->biSizeImage;
	float result;
	if (size_work != 0 && size_divisor != 0){
		if (size_work == size_divisor){
			for (int i = 0; i < size_work; i++){
				if (divisor->m_pDIBpixel[i] == 0)
					divisor->m_pDIBpixel[i] = 1;
				result = multi * ((float)work->m_pDIBpixel[i] / (float)divisor->m_pDIBpixel[i]);
				if (result > on_full)
					m_pDIBpixel[i] = on_full;
				else
					m_pDIBpixel[i] = (BYTE)result;
			}
		}
	}
    if (m_hWnd) {
        Invalidate(TRUE);
	}

}

long CLegoDIB::NoOfPixel ()
{
	return m_pDIB->biWidth * m_pDIB->biHeight;
}

long CLegoDIB::GetWidth ()
{
	return m_pDIB->biWidth;
}

long CLegoDIB::GetHeight ()
{
	return m_pDIB->biHeight;
}

BYTE CLegoDIB::GetColorOfPixel (long counter)
{
	BYTE color = 0;
	if (m_pDIBpixel[counter])						// blue
		color |= 0x01;
	if (m_pDIBpixel[counter+1])						// green
		color |= 0x02;
	if (m_pDIBpixel[counter+2])						// red
		color |= 0x04;
													// 0x00  ->  black
													// 0x01  ->  blue
													// 0x02  ->  green
													// 0x03  ->  cyan
													// 0x04  ->  red
													// 0x05  ->  magenta
													// 0x06  ->  yellow
													// 0x07  ->  white
	return color;
}

void CLegoDIB::SetColorOfPixel (long counter, BYTE color)
{
	if (color & 0x01)
		m_pDIBpixel[counter] = on_full;
	else
		m_pDIBpixel[counter] = off;
	if (color & 0x02)
		m_pDIBpixel[counter+1] = on_full;
	else
		m_pDIBpixel[counter+1] = off;
	if (color & 0x04)
		m_pDIBpixel[counter+2] = on_full;
	else
		m_pDIBpixel[counter+2] = off;
}


void CLegoDIB::ClearPic(BYTE brightness)
{
	int i = 0;
	int height = m_pDIB->biHeight;
	int width = m_pDIB->biWidth;
	int pixel_size = sizeof (RGBTRIPLE);
	int row = width  * pixel_size;
	int size = row * height;

	for (i = 0; i < size; i++){								// every pixel
		m_pDIBpixel[i] = brightness;						// all pixel on -> some kind of grey !
	}
    if (m_hWnd) {
        Invalidate(TRUE);
	}
}

void CLegoDIB::DrawMyHandle()
{
    if (m_hWnd) {
        Invalidate(TRUE);
	}
}

void CLegoDIB::DrawLine()
{
	int i = 0;

	for (i = 480; i < 57600; i+=960){
		m_pDIBpixel[i] = 128;						// all pixel on -> some kind of grey !
		m_pDIBpixel[i+1] = 128;						// all pixel on -> some kind of grey !
		m_pDIBpixel[i+2] = 128;						// all pixel on -> some kind of grey !
	}
}
