// LegoIP.cpp: implementation of the CLegoIP class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CATCH.h"
#include "LegoIP.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLegoIP::CLegoIP()
{
	m_LegoDIB_work_DIB = NULL;
	m_LegoDIB_ref_DIB = NULL;
	m_LegoDIB_cleaned_DIB = NULL;
	m_LegoDIB_binary_simple_DIB = NULL;
	m_LegoDIB_binary_ext_DIB = NULL;
	m_LegoDIB_blobs_DIB = NULL;
	m_LegoDIB_result_DIB = NULL;
	m_marks_array = NULL;
	m_equilist_array = NULL;
	m_blobs_array = NULL;

}

CLegoIP::~CLegoIP()
{

}


void CLegoIP::GetWorkDIB (CLegoDIB *here)
{
	m_LegoDIB_work_DIB = here;
}

void CLegoIP::GetRefDIB(CLegoDIB *here)
{
	m_LegoDIB_ref_DIB = here;
}

void CLegoIP::GetCleanedDIB(CLegoDIB *here)
{
	m_LegoDIB_cleaned_DIB = here;
}

void CLegoIP::GetBinarySimpleDIB (CLegoDIB *here)
{
	m_LegoDIB_binary_simple_DIB = here;
}

void CLegoIP::GetBinaryExtDIB(CLegoDIB *here)
{
	m_LegoDIB_binary_ext_DIB = here;
}

void CLegoIP::GetResultDIB (CLegoDIB *here)
{
	m_LegoDIB_result_DIB = here;
}

void CLegoIP::GetBlobDIB (CLegoDIB *here)
{
	m_LegoDIB_blobs_DIB = here;
}

void CLegoIP::DisconnectControls()
{
	m_LegoDIB_work_DIB = NULL;
	m_LegoDIB_ref_DIB = NULL;
	m_LegoDIB_cleaned_DIB = NULL;
	m_LegoDIB_binary_simple_DIB = NULL;
	m_LegoDIB_binary_ext_DIB = NULL;
	m_LegoDIB_blobs_DIB = NULL;
	m_LegoDIB_result_DIB = NULL;
}

void CLegoIP::GetValues (int n_f, int t_s, int a_r, int a_g, int a_b, int t_e, int m_s)
{
	m_normalize_factor = n_f;
	m_threshold_simple = t_s;
	m_add_red = a_r;
	m_add_green = a_g;
	m_add_blue = a_b;
	m_threshold_ext = t_e;
	m_min_size = m_s;
}

long CLegoIP::LastMark(long mark)
{
	if (mark == m_equilist_array[mark]){
		return mark;
	}
	else{
		return LastMark(m_equilist_array[mark]);
	}
}

void CLegoIP::CorrectMarks()
{
	long i;
	for (i = 1; i <= m_markscounter; i++)
		m_equilist_array[i] = FillEquiList(i);
	ClearList();
	for (i = 0; i < m_arraysize;i++)
		if (m_marks_array[i])
			m_marks_array[i] = m_equilist_array[m_marks_array[i]];
}

long CLegoIP::FillEquiList(long mark)
{
	long temp_mark;
	temp_mark = m_equilist_array[mark];
	if (temp_mark == m_equilist_array[temp_mark]){
		return temp_mark;
	}
	else
	{
		return (m_equilist_array[temp_mark] = FillEquiList(temp_mark));
	}
}

void CLegoIP::ClearList()
{
	long i,j,Old,New;
	New = -1;
	for (i = 1; i < m_markscounter; i++)
	{
		Old = m_equilist_array[i];
		if (Old >= 0)
		{
			for (j = i; j < m_markscounter; j++)
				if (m_equilist_array[j] == Old)
					m_equilist_array[j] = New;
			New--;
		}
	}
	for (i = 1; i < m_markscounter; i++)
		m_equilist_array[i] = abs(m_equilist_array[i]);

	for (i = 0; i < m_arraysize;i++)
		if (m_marks_array[i])
			m_marks_array[i] = m_marks_array[i];
}

void CLegoIP::CalculateMarks()
{
	long i = 0;
	long leftmark = 0;
	long uppermark = 0;
	BYTE color_this_pixel = 0;
	BYTE color_left_pixel = 0;
	BYTE color_upper_pixel = 0;
	int height = m_LegoDIB_binary_ext_DIB->GetHeight();
	int width = m_LegoDIB_binary_ext_DIB->GetWidth();
	long no_of_pixel = height * width;	
	int pixel_size = sizeof (RGBTRIPLE);
	int row = width  * pixel_size;
	long size = row * height;

	m_markscounter = 0;

	memset (m_marks_array, 0, m_arraysize*sizeof(long));
	memset (m_equilist_array, 0, m_arraysize*sizeof(long));

	for (i = 0; i < m_arraysize; i++){
		m_blobs_array[i].clear();
	}

	for (i = width+1; i < m_arraysize; i ++){					// every pixel except first row
		if (i % width){											// every pixel except first column
			color_this_pixel = m_LegoDIB_binary_ext_DIB->GetColorOfPixel(i*pixel_size);
			color_left_pixel = m_LegoDIB_binary_ext_DIB->GetColorOfPixel((i-1)*pixel_size);
			color_upper_pixel = m_LegoDIB_binary_ext_DIB->GetColorOfPixel((i-width)*pixel_size);

			if (color_this_pixel != 0x07) {		// red, green and blue are set -> white -> background -> no blob !!
				if (color_this_pixel == color_upper_pixel && color_this_pixel != color_left_pixel){
					m_marks_array[i] = m_marks_array[i-width];
				}
				else if (color_this_pixel != color_upper_pixel && color_this_pixel == color_left_pixel){
					m_marks_array[i] = m_marks_array[i-1];
				}	
				else if (color_this_pixel == color_upper_pixel && color_this_pixel == color_left_pixel){
					m_marks_array[i] = m_marks_array[i-1];
					if (m_marks_array[i-1] != m_marks_array[i-width]){
						leftmark = LastMark(m_marks_array[i-1]);
						uppermark = LastMark(m_marks_array[i-width]);
						m_equilist_array[leftmark] = uppermark;
					}
				}
				else {
					if (m_markscounter >= m_arraysize){
						AfxMessageBox("markscounter is larger than the number of pixel. markscounter set back to 0 -> mars are not valid !)",IDOK,0);
						m_markscounter = 0;
					}
					else{
						m_markscounter++;
						m_equilist_array[m_markscounter] = m_markscounter;
						m_marks_array[i] = m_markscounter;
					}
				}
			}
		}
	}
	CorrectMarks();
}


void CLegoIP::CalculateBlobs()
{
	long i = 0;	
	long number_of_blobs = 0;

	int width = m_LegoDIB_binary_ext_DIB->GetWidth();
	int pixel_size = sizeof (RGBTRIPLE);

	// blue
	m_blue_blob.clear();
	// green
	m_green_blob.clear();
	// cyan
	m_cyan_blob.clear();
	// red
	m_red_blob.clear();
	// magenta
	m_magenta_blob.clear();
	// yellow
	m_yellow_blob.clear();


	for (i = 0; i < m_arraysize; i++)
	{
		if (m_marks_array[i] > number_of_blobs){
			number_of_blobs = m_marks_array[i];
		}
		if (m_marks_array[i]){

			m_blobs_array[m_marks_array[i]].SetCenter_x (m_blobs_array[m_marks_array[i]].GetCenter_x() + (i%width));		// x - coordinate -> center of gravity fromblob
			m_blobs_array[m_marks_array[i]].SetCenter_y (m_blobs_array[m_marks_array[i]].GetCenter_y() + (i/width));		// y - coordinate -> center of gravity from blob
			m_blobs_array[m_marks_array[i]].SetSize(m_blobs_array[m_marks_array[i]].GetSize()+1);					// size of blob 
			m_blobs_array[m_marks_array[i]].SetColor(m_LegoDIB_binary_ext_DIB->GetColorOfPixel (i * pixel_size)) ;		// color of blob

		}
	}	

	for (i = 0; i < number_of_blobs; i++){
		if (m_blobs_array[i].GetSize() >=  m_min_size &&						// greater or equal minimum blob size
			m_blobs_array[i].GetColor() != 0x00 &&							// no black blobs !
			m_blobs_array[i].GetColor() != 0x07){							// no white blobs !
			
			m_blobs_array[i].SetCenter_x(m_blobs_array[i].GetCenter_x() / m_blobs_array[i].GetSize());		// calculate x position of center of garavity of blob 
			m_blobs_array[i].SetCenter_y(m_blobs_array[i].GetCenter_y() / m_blobs_array[i].GetSize());		// calculate y position of center of garavity of blob

			if (m_blobs_array[i].GetColor() == 0x01){					// 0x01  ->  blue
				if (m_blobs_array[i].GetSize() > m_blue_blob.GetSize()){
					m_blue_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_blue_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_blue_blob.SetSize(m_blobs_array[i].GetSize());
					m_blue_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
			else if (m_blobs_array[i].GetColor() == 0x02){				// 0x02  ->  green
				if (m_blobs_array[i].GetSize() > m_green_blob.GetSize()){
					m_green_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_green_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_green_blob.SetSize(m_blobs_array[i].GetSize());
					m_green_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
			else if (m_blobs_array[i].GetColor() == 0x03){				// 0x03  ->  cyan
				if (m_blobs_array[i].GetSize() > m_cyan_blob.GetSize()){
					m_cyan_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_cyan_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_cyan_blob.SetSize(m_blobs_array[i].GetSize());
					m_cyan_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
			else if (m_blobs_array[i].GetColor() == 0x04){				// 0x04  ->  red
				if (m_blobs_array[i].GetSize() > m_red_blob.GetSize()){
					m_red_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_red_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_red_blob.SetSize(m_blobs_array[i].GetSize());
					m_red_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
			else if (m_blobs_array[i].GetColor() == 0x05){				// 0x05  ->  magenta

				if (m_blobs_array[i].GetSize() > m_magenta_blob.GetSize()){
					m_magenta_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_magenta_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_magenta_blob.SetSize(m_blobs_array[i].GetSize());
					m_magenta_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
			else if (m_blobs_array[i].GetColor() == 0x06){				// 0x06  ->  yellow
				if (m_blobs_array[i].GetSize() > m_yellow_blob.GetSize()){
					m_yellow_blob.SetCenter_x(m_blobs_array[i].GetCenter_x());
					m_yellow_blob.SetCenter_y(m_blobs_array[i].GetCenter_y());
					m_yellow_blob.SetSize(m_blobs_array[i].GetSize());
					m_yellow_blob.SetColor(m_blobs_array[i].GetColor());
				}
			}
		}
	}

}

void CLegoIP::DrawBlobs()
{
	long i = 0;
	long circle_value = 0;
	int j = 0;
	int root = 0;
	int s = 0, c = 0;
	int divisor = 1;
	double temp;
	double PI = 3.1415927;

	int height = m_LegoDIB_binary_ext_DIB->GetHeight();
	int width = m_LegoDIB_binary_ext_DIB->GetWidth();
	int pixel_size = sizeof (RGBTRIPLE);
	int row = width  * pixel_size;
	long size = row * height;

	m_LegoDIB_result_DIB->ClearPic(170);

	if (m_blue_blob.GetSize()){
		root = (int)(sqrt(m_blue_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_blue_blob.GetCenter_x() * pixel_size + m_blue_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_blue_blob.GetCenter_x() + (m_blue_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x01);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x01);
			}
		}
	}
	if (m_green_blob.GetSize()){
		root = (int)(sqrt(m_green_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_green_blob.GetCenter_x() * pixel_size + m_green_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_green_blob.GetCenter_x() + (m_green_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x02);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x02);
			}
		}
	}
	if (m_cyan_blob.GetSize()){
		root = (int)(sqrt(m_cyan_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_cyan_blob.GetCenter_x() * pixel_size + m_cyan_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_cyan_blob.GetCenter_x() + (m_cyan_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x03);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x03);
			}
		}
	}
	if (m_red_blob.GetSize()){
		root = (int)(sqrt(m_red_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_red_blob.GetCenter_x() * pixel_size + m_red_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_red_blob.GetCenter_x() + (m_red_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x04);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x04);
			}
		}
	}
	if (m_magenta_blob.GetSize()){
		root = (int)(sqrt(m_magenta_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_magenta_blob.GetCenter_x() * pixel_size + m_magenta_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_magenta_blob.GetCenter_x() + (m_magenta_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x05);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x05);
			}
		}
	}
	if (m_yellow_blob.GetSize()){
		root = (int)(sqrt(m_yellow_blob.GetSize())/2);
		m_LegoDIB_result_DIB->SetColorOfPixel(m_yellow_blob.GetCenter_x() * pixel_size + m_yellow_blob.GetCenter_y() * row, 0x00);
		for (j = 0; j < 360; j += 5)
		{
			temp = ((2*PI) / 360) * j;
			s = (int)(sin(temp)*root);
			s *= width;
			c = (int)(cos(temp)*root);
			circle_value = (m_yellow_blob.GetCenter_x() + (m_yellow_blob.GetCenter_y() * width) + s + c) * pixel_size;
			if (circle_value > 0 && circle_value < size) {
				m_LegoDIB_result_DIB->SetColorOfPixel(circle_value, 0x06);
				if (width > 960)
					m_LegoDIB_result_DIB->SetColorOfPixel(circle_value+1, 0x06);
			}
		}
	}
	m_LegoDIB_result_DIB->DrawMyHandle();
}


void CLegoIP::SendCoordinates()
{
	m_LegoComm.SendData (	(short)m_blue_blob.GetCenter_x(),
							(short)m_blue_blob.GetCenter_y(),
							(short)m_green_blob.GetCenter_x(),
							(short)m_green_blob.GetCenter_y(),
							(short)m_cyan_blob.GetCenter_x(),
							(short)m_cyan_blob.GetCenter_y(),
							(short)m_red_blob.GetCenter_x(),
							(short)m_red_blob.GetCenter_y(),
							(short)m_magenta_blob.GetCenter_x(),
							(short)m_magenta_blob.GetCenter_y(),
							(short)m_yellow_blob.GetCenter_x(),
							(short)m_yellow_blob.GetCenter_y());
}


int CLegoIP::StartTasks(USHORT bit_per_task)
{
	return m_LegoComm.StartTasks(bit_per_task);
}

int CLegoIP::StopTasks(USHORT bit_per_task)
{
	return m_LegoComm.StopTasks(bit_per_task);
}

void CLegoIP::CheckConnection()
{
	m_LegoComm.CheckConnection();
}

int CLegoIP::CloseComm()
{
	return m_LegoComm.CloseComm();
}

int CLegoIP::InitComm (int CommNumber)
{
	return m_LegoComm.InitComm(CommNumber);
}

void CLegoIP::SetArraySize (long size)
{
	m_arraysize = size;
}

long CLegoIP::GetArraySize ()
{
	return m_arraysize;
}


void CLegoIP::SetupMarksArray ()
{
	if (m_marks_array) {
        free(m_marks_array);
		m_marks_array = NULL;
    }
    if (m_arraysize) {
        m_marks_array = (long*)malloc(m_arraysize*sizeof(long));
		if (!m_marks_array){
	        AfxMessageBox("m_LegoIP.m_marks_array - Unable to allocate memory !!\n\n (Memory full ?!?!)", MB_ICONINFORMATION | MB_OK);
		}
		else {
			memset (m_marks_array, 0, m_arraysize*sizeof(long));	
		}
	}
	else {
        AfxMessageBox("m_LegoIP.m_marks_array - No size for allocation)", MB_ICONINFORMATION | MB_OK);
	}
}



void CLegoIP::SetupEquiListArray ()
{
	if (m_equilist_array) {
        free(m_equilist_array);
		m_equilist_array = NULL;
    }
    if (m_arraysize) {
        m_equilist_array = (long*)malloc(m_arraysize*sizeof(long));
		if (!m_equilist_array){
	        AfxMessageBox("m_LegoIP.m_equilist_array - Unable to allocate memory !!\n\n (Memory full ?!?!)", MB_ICONINFORMATION | MB_OK);
		}
		else {
			memset (m_equilist_array, 0, m_arraysize*sizeof(long));	
		}
	}
	else {
        AfxMessageBox("m_LegoIP.m_equilist_array - No size for allocation)", MB_ICONINFORMATION | MB_OK);
	}
}

  
	
void CLegoIP::SetupBlobsArray ()
{
	int i = 0;
	if (m_blobs_array) {
        free(m_blobs_array);
		m_blobs_array = NULL;
    }
    if (m_arraysize) {
        m_blobs_array = (CBlob*)malloc(m_arraysize*sizeof(CBlob));
		if (!m_equilist_array){
	        AfxMessageBox("m_LegoIP.m_blobs_array - Unable to allocate memory !!\n\n (Memory full ?!?!)", MB_ICONINFORMATION | MB_OK);
		}
		else {
			for (i = 0; i < m_arraysize; i++){
				m_blobs_array[i].SetCenter_x(0);
				m_blobs_array[i].SetCenter_y(0);
				m_blobs_array[i].SetSize(0);
				m_blobs_array[i].SetColor(0);			
			}
		}
	}
	else {
        AfxMessageBox("m_LegoIP.m_equilist_array - No size for allocation)", MB_ICONINFORMATION | MB_OK);
	}
}

void CLegoIP::CalculateThresholds()
{
	m_threshold_red = m_threshold_simple + m_add_red;
	if (m_threshold_red > 255)
		m_threshold_red = 255;
	else if (m_threshold_red < 0)
		m_threshold_red = 0;

	m_threshold_green = m_threshold_simple + m_add_green;
	if (m_threshold_green > 255)
		m_threshold_green = 255;
	else if (m_threshold_green < 0)
		m_threshold_green = 0;

	m_threshold_blue = m_threshold_simple + m_add_blue;
	if (m_threshold_blue > 255)
		m_threshold_blue = 255;
	else if (m_threshold_blue < 0)
		m_threshold_blue = 0;
}

void CLegoIP::CleanUp()
{
	m_LegoDIB_cleaned_DIB->DividePic(m_normalize_factor,
									 m_LegoDIB_work_DIB,
									 m_LegoDIB_ref_DIB);
}

void CLegoIP::BinarySimple()
{
	m_LegoDIB_binary_simple_DIB->BinarySimple(m_threshold_red, m_threshold_green, m_threshold_blue, m_LegoDIB_cleaned_DIB); 
}

void CLegoIP::BinaryExtended()
{
	m_LegoDIB_binary_ext_DIB->Binary(m_threshold_red, m_threshold_green, m_threshold_blue, m_threshold_ext, m_LegoDIB_cleaned_DIB); 
}


void CLegoIP::SetComm(CSpirit *DlgComm, int port)
{
	m_LegoComm.SetComm(DlgComm, port);
}

int CLegoIP::SearchAvailablePort()
{
	if (m_LegoComm.CheckPort (1)){					// Check COM 1 for tower
		return 0;
	}
	else if (m_LegoComm.CheckPort (2)){				// Check COM 2 for tower
		return 1;
	}
	else if (m_LegoComm.CheckPort (3)){				// Check COM 3 for tower
		return 2;
	}
	else if (m_LegoComm.CheckPort (4)){				// Check COM 4 for tower	
		return 3;
	}
	else {
		AfxMessageBox("Unable to find an IR tower.\n\nPlease check the connection !", MB_ICONINFORMATION | MB_OK, 0);
		return 4;
	}
}