// LegoIP.h: interface for the CLegoIP class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LEGOIP_H__14F4BA20_8105_11D5_8F70_0060084B8EE8__INCLUDED_)
#define AFX_LEGOIP_H__14F4BA20_8105_11D5_8F70_0060084B8EE8__INCLUDED_

#include "Blob.h"	// Added by ClassView
#include "LegoDIB.h"	// Added by ClassView
#include "LegoComm.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CLegoIP  
{
public:

	
	void SetComm(CSpirit* DlgComm,int port);
	int SearchAvailablePort ();

	void CleanUp();
	void SendCoordinates();
	void BinaryExtended();
	void BinarySimple();
	void CalculateThresholds();

	void DrawBlobs();
	void CalculateMarks();
	void CalculateBlobs();

	void GetWorkDIB (CLegoDIB *here);
	void GetRefDIB(CLegoDIB *here);
	void GetCleanedDIB(CLegoDIB *here);
	void GetBinarySimpleDIB (CLegoDIB *here);
	void GetBinaryExtDIB(CLegoDIB *here);
	void GetBlobDIB (CLegoDIB *here);
	void GetResultDIB (CLegoDIB *here);

	void GetValues (int n_f, int t_s, int a_r, int a_g, int a_b, int t_e, int m_s);

	void DisconnectControls();
	
	int StopTasks(USHORT bit_per_task);
	int StartTasks(USHORT bit_per_task);
	void CheckConnection();
	int CloseComm();
	int InitComm (int CommNumber);

	void SetArraySize (long size);
	long GetArraySize ();

	void SetupMarksArray ();
	void SetupEquiListArray ();
	void SetupBlobsArray ();


	CLegoIP();
	virtual ~CLegoIP();

private:

	void ClearList();
	long FillEquiList(long mark);
	long LastMark(long mark);
	void CorrectMarks();
	
	int m_normalize_factor;
	int m_threshold_simple;
	int m_add_red;
	int m_add_green;
	int m_add_blue;
	int m_threshold_red;
	int m_threshold_green;
	int m_threshold_blue;
	int m_threshold_ext;
	int m_min_size;

	long m_markscounter;

	long m_arraysize;
	
	long* m_marks_array;
	long* m_equilist_array;

	CBlob* m_blobs_array;

	CBlob m_red_blob;
	CBlob m_green_blob;
	CBlob m_blue_blob;
	CBlob m_yellow_blob;
	CBlob m_cyan_blob;
	CBlob m_magenta_blob;

	CLegoDIB *m_LegoDIB_work_DIB;
	CLegoDIB *m_LegoDIB_ref_DIB;
	CLegoDIB *m_LegoDIB_cleaned_DIB;
	CLegoDIB *m_LegoDIB_binary_simple_DIB;
	CLegoDIB *m_LegoDIB_binary_ext_DIB;
	CLegoDIB *m_LegoDIB_blobs_DIB;
	CLegoDIB *m_LegoDIB_result_DIB;

	CLegoComm m_LegoComm;
	
};

#endif // !defined(AFX_LEGOIP_H__14F4BA20_8105_11D5_8F70_0060084B8EE8__INCLUDED_)
