/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.Free;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.List;

public final class DBQueryStageCompiler {
    public static DBQuery compile(DBQueryStageCompiler dBQueryStageCompiler, DBQueryHandler dBQueryHandler, SpecializedGraph specializedGraph, List list, List list2, ExpressionSet expressionSet) {
        DBQuery dBQuery = new DBQuery(specializedGraph, list, dBQueryHandler.queryOnlyStmt, dBQueryHandler.queryOnlyReif, dBQueryHandler.queryFullReif);
        if (!dBQuery.isEmpty) {
            for (int i = 0; i < list2.size(); ++i) {
                DBQueryStageCompiler.compilePattern(dBQueryStageCompiler, dBQuery, (DBPattern)list2.get(i));
            }
            DBQueryStageCompiler.compileConstraints(dBQueryStageCompiler, dBQuery, expressionSet);
            DBQueryStageCompiler.compileQuery(dBQueryStageCompiler, dBQuery);
        }
        return dBQuery;
    }

    private static void compilePattern(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery, DBPattern dBPattern) {
        Element element = dBPattern.S;
        Element element2 = dBPattern.O;
        Element element3 = dBPattern.P;
        String string = null;
        int n = dBQuery.aliasCnt;
        if (dBQuery.isReifier) {
            char c;
            boolean bl = true;
            if (!(element3 instanceof Fixed)) {
                throw new JenaException("Reifier predicate not bound");
            }
            Node node = ((Fixed)element3).asNodeMatch(null);
            if (node.equals(RDF.Nodes.subject)) {
                c = 'S';
            } else if (node.equals(RDF.Nodes.predicate)) {
                c = 'P';
            } else if (node.equals(RDF.Nodes.object)) {
                c = 'O';
            } else if (node.equals(RDF.Nodes.type)) {
                c = 'T';
            } else {
                throw new JenaException("Unexpected reifier predicate");
            }
            if (!element.equals(Element.ANY)) {
                if (dBQuery.qryFullReif && element instanceof Free && dBQuery.getBinding(((Free)element).getListing()).isBoundToCol()) {
                    n = dBQuery.getBinding((int)((Free)element).getListing()).alias;
                    bl = false;
                } else {
                    string = dBQuery.sqlAnd.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'N', element));
                }
            }
            string = string + dBQuery.sqlAnd.gen(DBQueryStageCompiler.getQual(dBQuery, n, c, element2));
            string = string + dBQuery.sqlAnd.gen(dBQuery.driver.genSQLQualGraphId(n, dBQuery.graphId));
            if (bl) {
                dBQuery.newAlias();
            }
        } else {
            string = dBQuery.sqlAnd.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'S', element));
            string = string + dBQuery.sqlAnd.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'P', element3));
            string = string + dBQuery.sqlAnd.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'O', element2));
            string = string + dBQuery.sqlAnd.gen(dBQuery.driver.genSQLQualGraphId(n, dBQuery.graphId));
            dBQuery.newAlias();
        }
        dBQuery.stmt = dBQuery.stmt + string;
    }

    private static String getQual(DBQuery dBQuery, int n, char c, Element element) {
        String string = "";
        if (element instanceof Fixed) {
            Node node = ((Fixed)element).asNodeMatch(null);
            string = dBQuery.isReifier ? dBQuery.driver.genSQLReifQualConst(n, c, node) : dBQuery.driver.genSQLQualConst(n, c, node);
        } else if (element instanceof Free) {
            Free free = (Free)element;
            VarDesc varDesc = dBQuery.getBinding(free.getListing());
            if (free.isArg() && !varDesc.isBoundToCol) {
                ++dBQuery.argCnt;
                dBQuery.argType = dBQuery.argType + c;
                dBQuery.argIndex.add(new Integer(free.getMapping()));
                string = dBQuery.driver.genSQLQualParam(n, c);
                varDesc.bindToCol(n, c);
            } else if (varDesc.isBoundToCol()) {
                string = dBQuery.driver.genSQLJoin(varDesc.alias, varDesc.column, n, c);
            } else {
                varDesc.bindToCol(n, c);
                string = "";
            }
        } else if (element != Element.ANY) {
            throw new JenaException("Invalid Element in qualifier");
        }
        return string;
    }

    private static void compileConstraints(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery, ExpressionSet expressionSet) {
        Iterator iterator = expressionSet.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            VarDesc varDesc = dBQuery.findBinding(expression.getArg(0).getName());
            if (varDesc == null) {
                throw new JenaException("Unbound variable in constraint");
            }
            String string = ((Expression.Fixed)expression.getArg(1)).toString();
            dBQuery.stmt = dBQuery.stmt + dBQuery.sqlAnd.gen(dBQuery.driver.genSQLStringMatch(varDesc.alias, varDesc.column, expression.getFun(), string));
        }
    }

    private static void compileQuery(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery) {
        int n = dBQuery.vars.length - dBQuery.argCnt;
        dBQuery.resList = new int[n];
        dBQuery.stmt = dBQuery.driver.genSQLSelectStmt(dBQuery.driver.genSQLResList(dBQuery.resList, dBQuery.vars), dBQuery.driver.genSQLFromList(dBQuery.aliasCnt, dBQuery.table), dBQuery.stmt);
    }
}

