/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Driver_PostgreSQL
extends DriverRDB {
    public Driver_PostgreSQL() {
        String string = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "PostgreSQL";
        this.DRIVER_NAME = "org.postgresql.Driver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 250;
        this.INDEX_KEY_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.LONG_OBJECT_LENGTH_MAX = 250;
        this.TABLE_NAME_LENGTH_MAX = 63;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = true;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/postgresql.sql";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = false;
        this.setTableNames(this.TABLE_NAME_PREFIX);
        this.m_psetClassName = string + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = string + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = string + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = string + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_dbcon = iDBConnection;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, iDBConnection, this.ID_SQL_TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            logger.error("Unable to set connection for Driver:", exception);
        }
    }

    public int graphIdAlloc(String string) {
        Object var2_2 = null;
        int n = 0;
        try {
            n = this.getInsertID(this.GRAPH_TABLE);
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("insertGraph", this.GRAPH_TABLE);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return n;
    }

    public void graphIdDealloc(int n) {
        Object var2_2 = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("deleteGraph", this.GRAPH_TABLE);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to delete graph ID: " + sQLException);
        }
    }

    public int getInsertID(String string) {
        DBIDInt dBIDInt = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("getInsertID", string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new RDFRDBException("No insert ID");
            }
            dBIDInt = this.wrapDBID(resultSet.getObject(1));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to insert ID: " + sQLException);
        }
        return dBIDInt.getIntID();
    }

    protected void getTblParams(String[] stringArray) {
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        if (this.INDEX_KEY_LENGTH > 4000) {
            throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String string = "VARCHAR(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        stringArray[0] = string;
        String string2 = "VARCHAR(" + this.INDEX_KEY_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        stringArray[1] = string2;
        stringArray[2] = this.TABLE_NAME_PREFIX;
    }

    protected String[] getDbInitTablesParams() {
        String[] stringArray = new String[3];
        this.getTblParams(stringArray);
        this.EOS_LEN = this.EOS.length();
        return stringArray;
    }

    protected String[] getCreateTableParams(int n, boolean bl) {
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[2];
        this.getTblParams(stringArray);
        int n2 = this.getTableCount(n);
        stringArray2[0] = this.genTableName(n, n2, bl);
        stringArray2[1] = stringArray[0];
        return stringArray2;
    }

    public String genSQLStringMatchOp_IC(String string) {
        return "I" + this.genSQLLikeKW();
    }
}

