/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;

public abstract class SpecializedGraph_TripleStore
extends SpecializedGraphBase {
    public IPSet m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;

    SpecializedGraph_TripleStore(DBPropLSet dBPropLSet, IPSet iPSet, Integer n) {
        this.m_pset = iPSet;
        this.m_dbPropLSet = dBPropLSet;
        this.my_GID = new DBIDInt(n);
    }

    public SpecializedGraph_TripleStore(IPSet iPSet, Integer n) {
        this.m_pset = iPSet;
        this.my_GID = new DBIDInt(n);
    }

    public void add(Graph graph, SpecializedGraph.CompletionFlag completionFlag) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            this.add((Triple)extendedIterator.next(), completionFlag);
        }
        completionFlag.setDone();
    }

    public void add(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        this.m_pset.storeTriple(triple, this.my_GID);
        completionFlag.setDone();
    }

    public void add(List list, SpecializedGraph.CompletionFlag completionFlag) {
        this.m_pset.storeTripleList(list, this.my_GID);
        completionFlag.setDone();
    }

    public void delete(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        this.m_pset.deleteTriple(triple, this.my_GID);
        completionFlag.setDone();
    }

    public void delete(List list, SpecializedGraph.CompletionFlag completionFlag) {
        this.m_pset.deleteTripleList(list, this.my_GID);
        completionFlag.setDone();
    }

    public int tripleCount() {
        return this.m_pset.tripleCount();
    }

    public boolean contains(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        completionFlag.setDone();
        return this.m_pset.statementTableContains(this.my_GID, triple);
    }

    public ExtendedIterator find(TripleMatch tripleMatch, SpecializedGraph.CompletionFlag completionFlag) {
        completionFlag.setDone();
        return this.m_pset.find(tripleMatch, this.my_GID);
    }

    public void close() {
        this.m_pset.close();
    }

    public void clear() {
        this.m_pset.removeStatementsFromDB(this.my_GID);
    }

    public int getGraphId() {
        return ((DBIDInt)this.my_GID).getIntID();
    }

    public IPSet getPSet() {
        return this.m_pset;
    }

    public DBPropLSet getDBPropLSet() {
        return this.m_dbPropLSet;
    }
}

