/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.GraphRDBMaker;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestDBSpec
extends ModelTestBase {
    public TestDBSpec(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDBSpec.class);
    }

    public void testCreateFailsUser() {
        try {
            Resource resource = ResourceFactory.createResource();
            Model model = ModelFactory.createDefaultModel().add(resource, RDF.type, JenaModelSpec.RDBMakerSpec);
            ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
            TestDBSpec.assertTrue(modelMaker.getGraphMaker() instanceof GraphRDBMaker);
            TestDBSpec.fail("should not be able to make RDB model from empty specification");
        }
        catch (Exception exception) {
            TestDBSpec.pass();
        }
    }

    public void testCreateSuccessUser() throws ClassNotFoundException {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        String string = TestPackage.M_DB;
        String string2 = TestPackage.M_DBDRIVER_CLASS;
        Model model = ModelFactory.createDefaultModel().add(resource, JenaModelSpec.maker, resource3).add(resource3, RDF.type, JenaModelSpec.RDBMakerSpec).add(resource3, JenaModelSpec.hasConnection, resource2).add(resource2, JenaModelSpec.dbUser, TestPackage.M_DB_USER).add(resource2, JenaModelSpec.dbPassword, TestPackage.M_DB_PASSWD).add(resource2, JenaModelSpec.dbURL, TestDBSpec.resource(TestPackage.M_DB_URL)).add(resource2, JenaModelSpec.dbType, string).add(resource2, JenaModelSpec.dbClass, string2);
        ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
        TestDBSpec.assertTrue(modelMaker.getGraphMaker() instanceof GraphRDBMaker);
        modelMaker.openModel("something").close();
        modelMaker.removeModel("something");
        modelMaker.close();
    }

    public void testCreateDBModelSpec() {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        String string = TestPackage.M_DB;
        String string2 = TestPackage.M_DBDRIVER_CLASS;
        Model model = ModelFactory.createDefaultModel().add(resource, JenaModelSpec.maker, resource2).add(resource2, RDF.type, JenaModelSpec.RDBMakerSpec).add(resource2, JenaModelSpec.hasConnection, resource3).add(resource3, JenaModelSpec.dbUser, TestPackage.M_DB_USER).add(resource3, JenaModelSpec.dbPassword, TestPackage.M_DB_PASSWD).add(resource3, JenaModelSpec.dbURL, TestDBSpec.resource(TestPackage.M_DB_URL)).add(resource3, JenaModelSpec.dbType, string).add(resource3, JenaModelSpec.dbClass, string2);
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = modelSpec.createModel();
        TestDBSpec.assertTrue(model2 instanceof ModelRDB);
    }
}

