/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced.test;

import com.hp.hpl.jena.enhanced.AlreadyLinkedViewException;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.enhanced.test.TestAllImpl;
import com.hp.hpl.jena.enhanced.test.TestModelImpl;
import com.hp.hpl.jena.enhanced.test.TestNode;
import com.hp.hpl.jena.enhanced.test.TestObject;
import com.hp.hpl.jena.enhanced.test.TestObjectImpl;
import com.hp.hpl.jena.enhanced.test.TestProperty;
import com.hp.hpl.jena.enhanced.test.TestPropertyImpl;
import com.hp.hpl.jena.enhanced.test.TestSubject;
import com.hp.hpl.jena.enhanced.test.TestSubjectImpl;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import junit.framework.TestSuite;

public class TestPackage
extends GraphTestBase {
    private static final GraphPersonality split = new GraphPersonality();
    private static final GraphPersonality combo = new GraphPersonality();
    private static final GraphPersonality bitOfBoth = new GraphPersonality();
    private static final GraphPersonality broken = new GraphPersonality();
    static final int S = 1;
    static final int P = 2;
    static final int O = 3;

    public TestPackage(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPackage.class);
    }

    public void testEquals() {
        EnhNode enhNode = new EnhNode(Node.create("eg:example"), null);
        TestPackage.assertEquals(enhNode, enhNode);
    }

    private static void miniAsSupports(String string, TestNode testNode, Class clazz, boolean bl) {
        TestPackage.assertTrue(string + ":sanity", testNode instanceof Polymorphic);
        TestNode testNode2 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        TestNode testNode3 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        TestPackage.assertTrue(string + ":idempotency", testNode2 == testNode3);
        TestPackage.assertEquals(string + ":support", bl, ((EnhNode)((Object)testNode2)).supports(clazz));
    }

    private static void oneNodeAsSupports(String string, TestNode testNode, boolean[] blArray) {
        TestPackage.miniAsSupports(string + "/TestSubject", testNode, TestSubject.class, blArray[0]);
        TestPackage.miniAsSupports(string + "/TestProperty", testNode, TestProperty.class, blArray[1]);
        TestPackage.miniAsSupports(string + "/TestObject", testNode, TestObject.class, blArray[2]);
    }

    private static void manyNodeAsSupports(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        for (int i = 0; i < testNodeArray.length; ++i) {
            TestPackage.oneNodeAsSupports(string + "[" + i + "]", testNodeArray[i], blArray[i]);
        }
    }

    private static void basic(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "x R y;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        TestPackage.manyNodeAsSupports(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(graphMem, "y R x;");
        TestPackage.manyNodeAsSupports(string + "(b)", testNodeArray, new boolean[][]{{true, false, true}, {false, true, false}, {true, false, true}});
        graphMem.delete(TestPackage.triple("x R y"));
        TestPackage.manyNodeAsSupports(string + "(c)", testNodeArray, new boolean[][]{{false, false, true}, {false, true, false}, {true, false, false}});
    }

    private void canImplement(String string, TestNode testNode, int n, boolean bl) {
        try {
            switch (n) {
                case 1: {
                    testNode.asSubject().aProperty();
                    break;
                }
                case 2: {
                    testNode.asProperty().anObject();
                    break;
                }
                case 3: {
                    testNode.asObject().aSubject();
                }
            }
            TestPackage.assertTrue("IllegalStateException expected.", bl);
        }
        catch (IllegalStateException illegalStateException) {
            TestPackage.assertFalse("IllegalStateException at the wrong time.", bl);
        }
    }

    private void canImplement(String string, TestNode testNode, boolean[] blArray) {
        this.canImplement(string + "/TestSubject", testNode, 1, blArray[0]);
        this.canImplement(string + "/TestProperty", testNode, 2, blArray[1]);
        this.canImplement(string + "/TestObject", testNode, 3, blArray[2]);
    }

    private void canImplement(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        for (int i = 0; i < testNodeArray.length; ++i) {
            this.canImplement(string + "[" + i + "]", testNodeArray[i], blArray[i]);
        }
    }

    private void follow(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "a b c;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        this.canImplement(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(graphMem, "b a c;");
        this.canImplement(string + "(b)", testNodeArray, new boolean[][]{{true, true, false}, {true, true, false}, {false, false, true}});
        graphMem.delete(TestPackage.triple("a b c"));
        this.canImplement(string + "(c)", testNodeArray, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        this.canImplement(string + "(c)", new TestNode[]{testNodeArray[1].asSubject().aProperty(), testNodeArray[2].asObject().aSubject(), testNodeArray[0].asProperty().anObject()}, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        TestPackage.assertTrue("Model cache test", testNodeArray[0].asProperty().anObject() == testNodeArray[2]);
    }

    private void cache(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "a b a;");
        TestPackage.assertTrue("Caching is on", testModelImpl.aSubject().asObject() == testModelImpl.anObject());
        testModelImpl.getNodeCacheControl().setEnabled(false);
        TestPackage.assertFalse("Caching is off", testModelImpl.aSubject() == testModelImpl.anObject());
    }

    public static void testSplitBasic() {
        TestPackage.basic("Split: ", split);
    }

    public static void testComboBasic() {
        TestPackage.basic("Combo: ", combo);
    }

    public void testSplitFollow() {
        this.follow("Split: ", split);
    }

    public void testComboFollow() {
        this.follow("Combo: ", combo);
    }

    public void testSplitCache() {
        this.cache("Split: ", split);
    }

    public void testComboCache() {
        this.cache("Combo: ", combo);
    }

    public static void testBitOfBothBasic() {
        TestPackage.basic("bob: ", bitOfBoth);
    }

    public void testBitOfBothFollow() {
        this.follow("bob: ", bitOfBoth);
    }

    public void testBitOfBothCache() {
        this.cache("bob: ", bitOfBoth);
    }

    public static void testBitOfBothSurprise() {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, bitOfBoth);
        TestPackage.graphAdd(graphMem, "a a a;");
        TestSubject testSubject = testModelImpl.aSubject();
        TestPackage.assertTrue("BitOfBoth makes subjects using TestSubjectImpl", testSubject instanceof TestSubjectImpl);
        TestProperty testProperty = testSubject.aProperty();
        TestPackage.assertTrue("BitOfBoth makes properties using TestAllImpl", testProperty instanceof TestAllImpl);
        TestPackage.assertTrue("turning a TestAllImpl into a TestSubject is a no-op", testProperty == testProperty.asSubject());
        TestPackage.assertTrue("turning a TestAllImpl into a TestSubject is a no-op", testSubject != testProperty.asSubject());
        TestPackage.assertTrue("turning a TestAllImpl into a TestSubject is a no-op", testSubject.asSubject() != testSubject.asSubject().asProperty().asSubject());
    }

    public static void testBrokenBasic() {
        try {
            TestPackage.basic("Broken: ", broken);
            TestPackage.fail("broken is a misconfigured personality, but it wasn't detected.");
        }
        catch (PersonalityConfigException personalityConfigException) {
            // empty catch block
        }
    }

    public void testSimple() {
        GraphMem graphMem = new GraphMem();
        Personality personality = BuiltinPersonalities.model.copy().add(Example.class, Example.factory);
        EnhGraph enhGraph = new EnhGraph(graphMem, personality);
        Node node = Node.createURI("spoo:bar");
        EnhNode enhNode = new EnhNode(Node.createURI("spoo:bar"), enhGraph);
        EnhNode enhNode2 = new EnhNode(Node.createAnon(), enhGraph);
        TestPackage.assertTrue("URI node can be an Example", enhNode.supports(Example.class));
        TestPackage.assertFalse("Blank node cannot be an Example", enhNode2.supports(Example.class));
    }

    public void testAlreadyLinkedViewException() {
        GraphMem graphMem = new GraphMem();
        Personality personality = BuiltinPersonalities.model.copy().add(Example.class, Example.factory);
        EnhGraph enhGraph = new EnhGraph(graphMem, personality);
        Node node = Node.create("spoo:bar");
        EnhNode enhNode = new EnhNode(node, enhGraph);
        enhNode.viewAs(Example.class);
        try {
            enhNode.addView(enhNode);
            TestPackage.fail("should raise an AlreadyLinkedViewException ");
        }
        catch (AlreadyLinkedViewException alreadyLinkedViewException) {
            // empty catch block
        }
    }

    public void testNullPointerTrap() {
        EnhGraph enhGraph = new EnhGraph(new GraphMem(), BuiltinPersonalities.model);
        Node node = Node.create("eh:something");
        EnhNode enhNode = new EnhNode(node, enhGraph);
        try {
            enhNode.as(TestPackage.class);
            TestPackage.fail("oops");
        }
        catch (UnsupportedPolymorphismException unsupportedPolymorphismException) {
            TestPackage.assertTrue("exception should have cuplprit graph", enhGraph == unsupportedPolymorphismException.getBadGraph());
            TestPackage.assertTrue("exception should have culprit class", TestPackage.class == unsupportedPolymorphismException.getBadClass());
        }
    }

    static {
        split.add(TestObject.class, TestObjectImpl.factory);
        split.add(TestSubject.class, TestSubjectImpl.factory);
        split.add(TestProperty.class, TestPropertyImpl.factory);
        combo.add(TestObject.class, TestAllImpl.factory);
        combo.add(TestSubject.class, TestAllImpl.factory);
        combo.add(TestProperty.class, TestAllImpl.factory);
        bitOfBoth.add(TestObject.class, TestObjectImpl.factory);
        bitOfBoth.add(TestSubject.class, TestSubjectImpl.factory);
        bitOfBoth.add(TestProperty.class, TestAllImpl.factory);
        broken.add(TestObject.class, TestObjectImpl.factory);
        broken.add(TestSubject.class, TestSubjectImpl.factory);
        broken.add(TestProperty.class, TestObjectImpl.factory);
    }

    static class AnotherExample {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node node, EnhGraph enhGraph) {
                return new EnhNode(node, enhGraph);
            }

            public boolean canWrap(Node node, EnhGraph enhGraph) {
                return node.isURI();
            }
        };

        AnotherExample() {
        }
    }

    static class Example {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node node, EnhGraph enhGraph) {
                return new EnhNode(node, enhGraph);
            }

            public boolean canWrap(Node node, EnhGraph enhGraph) {
                return node.isURI();
            }
        };

        Example() {
        }
    }
}

