/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;

public class GraphExtract {
    protected final TripleBoundary b;

    public GraphExtract(TripleBoundary tripleBoundary) {
        this.b = tripleBoundary;
    }

    public Graph extract(Node node, Graph graph) {
        return this.extractInto(new GraphMem(), node, graph);
    }

    public Graph extractInto(Graph graph, Node node, Graph graph2) {
        new Extraction(this.b, graph, graph2).extractInto(node);
        return graph;
    }

    protected static class Extraction {
        protected Graph toUpdate;
        protected Graph extractFrom;
        protected Set active;
        protected TripleBoundary b;

        Extraction(TripleBoundary tripleBoundary, Graph graph, Graph graph2) {
            this.toUpdate = graph;
            this.extractFrom = graph2;
            this.active = CollectionFactory.createHashedSet();
            this.b = tripleBoundary;
        }

        public void extractInto(Node node) {
            this.active.add(node);
            ExtendedIterator extendedIterator = this.extractFrom.find(node, Node.ANY, Node.ANY);
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                Node node2 = triple.getObject();
                this.toUpdate.add(triple);
                if (this.active.contains(node2) || this.b.stopAt(triple)) continue;
                this.extractInto(node2);
            }
        }
    }
}

