/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestMultiUnion
extends AbstractTestGraph {
    public TestMultiUnion(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestMultiUnion.class);
    }

    public Graph getGraph() {
        Graph graph = TestMultiUnion.graphWith("");
        Graph graph2 = TestMultiUnion.graphWith("");
        return new MultiUnion(new Graph[]{graph, graph2});
    }

    public void testEmptyGraph() {
        MultiUnion multiUnion = new MultiUnion();
        Graph graph = TestMultiUnion.graphWith("x p y");
        TestMultiUnion.assertEquals("Empty model should have size zero", 0, multiUnion.size());
        TestMultiUnion.assertFalse("Empty model should not contain another graph", multiUnion.dependsOn(graph));
    }

    public void testGraphSize1() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph graph3 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph, graph2});
        MultiUnion multiUnion2 = new MultiUnion(new Graph[]{graph2, graph});
        MultiUnion multiUnion3 = new MultiUnion(new Graph[]{graph2, graph3});
        MultiUnion multiUnion4 = new MultiUnion(new Graph[]{graph3, graph2});
        MultiUnion multiUnion5 = new MultiUnion(new Graph[]{graph, graph3});
        MultiUnion multiUnion6 = new MultiUnion(new Graph[]{graph3, graph});
        MultiUnion multiUnion7 = new MultiUnion(new Graph[]{graph, graph});
        int n = graph.size();
        int n2 = graph2.size();
        int n4 = graph3.size();
        TestMultiUnion.assertEquals("Size of union of g0 and g1 not correct", n + n2, multiUnion.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", n + n2, multiUnion2.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g2 not correct", n2 + n4, multiUnion3.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g1 not correct", n2 + n4, multiUnion4.size());
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", n + n4 - 1, multiUnion5.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g0 not correct", n + n4 - 1, multiUnion6.size());
        TestMultiUnion.assertEquals("Size of union of g0 with itself not correct", n, multiUnion7.size());
    }

    public void testGraphSize2() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph graph3 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion multiUnion = new MultiUnion(this.iterateOver(graph, graph2));
        MultiUnion multiUnion2 = new MultiUnion(this.iterateOver(graph2, graph));
        MultiUnion multiUnion3 = new MultiUnion(this.iterateOver(graph2, graph3));
        MultiUnion multiUnion4 = new MultiUnion(this.iterateOver(graph3, graph2));
        MultiUnion multiUnion5 = new MultiUnion(this.iterateOver(graph, graph3));
        MultiUnion multiUnion6 = new MultiUnion(this.iterateOver(graph3, graph));
        MultiUnion multiUnion7 = new MultiUnion(this.iterateOver(graph, graph));
        int n = graph.size();
        int n2 = graph2.size();
        int n4 = graph3.size();
        TestMultiUnion.assertEquals("Size of union of g0 and g1 not correct", n + n2, multiUnion.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", n + n2, multiUnion2.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g2 not correct", n2 + n4, multiUnion3.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g1 not correct", n2 + n4, multiUnion4.size());
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", n + n4 - 1, multiUnion5.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g0 not correct", n + n4 - 1, multiUnion6.size());
        TestMultiUnion.assertEquals("Size of union of g0 with itself not correct", n, multiUnion7.size());
    }

    public void testGraphAddSize() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph graph3 = TestMultiUnion.graphWith("x p y; z p a");
        int n = graph.size();
        int n2 = graph2.size();
        int n4 = graph3.size();
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph});
        TestMultiUnion.assertEquals("Size of union of g0 not correct", n, multiUnion.size());
        multiUnion.addGraph(graph2);
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", n + n2, multiUnion.size());
        multiUnion.addGraph(graph3);
        TestMultiUnion.assertEquals("Size of union of g0, g1 and g2 not correct", n + n2 + n4 - 1, multiUnion.size());
        multiUnion.removeGraph(graph2);
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", n + n4 - 1, multiUnion.size());
        multiUnion.removeGraph(graph);
        TestMultiUnion.assertEquals("Size of union of g2 not correct", n4, multiUnion.size());
        multiUnion.removeGraph(graph);
        TestMultiUnion.assertEquals("Size of union of g2 not correct", n4, multiUnion.size());
        multiUnion.removeGraph(graph3);
        TestMultiUnion.assertEquals("Size of empty union not correct", 0, multiUnion.size());
    }

    public void testAdd() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph graph3 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph, graph2});
        int n = graph.size();
        int n2 = graph2.size();
        int n4 = graph3.size();
        int n5 = multiUnion.size();
        multiUnion.add(TestMultiUnion.triple("a q b"));
        TestMultiUnion.assertEquals("m.size should have increased by one", n5 + 1, multiUnion.size());
        TestMultiUnion.assertEquals("g0.size should have increased by one", n + 1, graph.size());
        TestMultiUnion.assertEquals("g1 size should be constant", n2, graph2.size());
        multiUnion.setBaseGraph(graph2);
        n = graph.size();
        n2 = graph2.size();
        n4 = graph3.size();
        n5 = multiUnion.size();
        multiUnion.add(TestMultiUnion.triple("a1 q b1"));
        TestMultiUnion.assertEquals("m.size should have increased by one", n5 + 1, multiUnion.size());
        TestMultiUnion.assertEquals("g0 size should be constant", n, graph.size());
        TestMultiUnion.assertEquals("g1.size should have increased by one", n2 + 1, graph2.size());
        boolean bl = false;
        try {
            multiUnion.setBaseGraph(graph3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        TestMultiUnion.assertTrue("Should not have been able to make g2 the updater", bl);
    }

    public void testDelete() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph, graph2});
        this.checkDeleteSizes(1, 2, 3, graph, graph2, multiUnion);
        multiUnion.delete(TestMultiUnion.triple("x p y"));
        this.checkDeleteSizes(0, 2, 2, graph, graph2, multiUnion);
        multiUnion.delete(TestMultiUnion.triple("x p y"));
        this.checkDeleteSizes(0, 2, 2, graph, graph2, multiUnion);
        multiUnion.setBaseGraph(graph2);
        multiUnion.delete(TestMultiUnion.triple("x p z"));
        this.checkDeleteSizes(0, 1, 1, graph, graph2, multiUnion);
        multiUnion.delete(TestMultiUnion.triple("z p zz"));
        this.checkDeleteSizes(0, 0, 0, graph, graph2, multiUnion);
    }

    public void testContains() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph, graph2});
        TestMultiUnion.assertTrue("m should contain triple", multiUnion.contains(TestMultiUnion.triple("x p y ")));
        TestMultiUnion.assertTrue("m should contain triple", multiUnion.contains(TestMultiUnion.triple("x p z ")));
        TestMultiUnion.assertTrue("m should contain triple", multiUnion.contains(TestMultiUnion.triple("z p zz ")));
        TestMultiUnion.assertFalse("m should not contain triple", multiUnion.contains(TestMultiUnion.triple("zz p z ")));
    }

    public void testModel() {
        Graph graph = TestMultiUnion.graphWith("x p y");
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph});
        Model model = ModelFactory.createModelForGraph(multiUnion);
        TestMultiUnion.assertEquals("Model size not correct", 1L, model.size());
        Graph graph2 = TestMultiUnion.graphWith("x p z; z p zz");
        multiUnion.addGraph(graph2);
        TestMultiUnion.assertEquals("Model size not correct", 3L, model.size());
        model.read("file:testing/ontology/list0.rdf");
        TestMultiUnion.assertEquals("Model size not correct", 4L, model.size());
    }

    protected void checkDeleteSizes(int n, int n2, int n4, Graph graph, Graph graph2, Graph graph3) {
        TestMultiUnion.assertEquals("Delete check: g0 size", n, graph.size());
        TestMultiUnion.assertEquals("Delete check: g1 size", n2, graph2.size());
        TestMultiUnion.assertEquals("Delete check: m size", n4, graph3.size());
    }

    protected Iterator iterateOver(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList.iterator();
    }

    protected Iterator iterateOver(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        return arrayList.iterator();
    }

    protected Iterator iterateOver(Object object, Object object2, Object object3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        return arrayList.iterator();
    }
}

