/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.graph.compose.PolyadicPrefixMappingImpl;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import junit.framework.TestSuite;

public class TestPolyadicPrefixMapping
extends AbstractTestPrefixMapping {
    Graph gBase;
    Graph g1;
    Graph g2;
    Polyadic poly;
    protected static final String alpha = "something:alpha#";
    protected static final String beta = "something:beta#";

    public TestPolyadicPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPolyadicPrefixMapping.class);
    }

    public void setUp() {
        this.gBase = Factory.createDefaultGraph();
        this.g1 = Factory.createDefaultGraph();
        this.g2 = Factory.createDefaultGraph();
        this.poly = new MultiUnion(new Graph[]{this.gBase, this.g1, this.g2});
        this.poly.setBaseGraph(this.gBase);
    }

    protected PrefixMapping getMapping() {
        Graph graph = Factory.createDefaultGraph();
        Graph graph2 = Factory.createDefaultGraph();
        Graph graph3 = Factory.createDefaultGraph();
        MultiUnion multiUnion = new MultiUnion(new Graph[]{graph, graph2, graph3});
        return new PolyadicPrefixMappingImpl(multiUnion);
    }

    public void testOnlyBaseMutated() {
        this.poly.getPrefixMapping().setNsPrefix("a", alpha);
        TestPolyadicPrefixMapping.assertEquals(null, this.g1.getPrefixMapping().getNsPrefixURI("a"));
        TestPolyadicPrefixMapping.assertEquals(null, this.g2.getPrefixMapping().getNsPrefixURI("a"));
        TestPolyadicPrefixMapping.assertEquals(alpha, this.gBase.getPrefixMapping().getNsPrefixURI("a"));
    }

    public void testUpdatesVisible() {
        this.g1.getPrefixMapping().setNsPrefix("a", alpha);
        this.g2.getPrefixMapping().setNsPrefix("b", beta);
        TestPolyadicPrefixMapping.assertEquals(alpha, this.poly.getPrefixMapping().getNsPrefixURI("a"));
        TestPolyadicPrefixMapping.assertEquals(beta, this.poly.getPrefixMapping().getNsPrefixURI("b"));
    }

    public void testUpdatesOverridden() {
        this.g1.getPrefixMapping().setNsPrefix("x", alpha);
        this.poly.getPrefixMapping().setNsPrefix("x", beta);
        TestPolyadicPrefixMapping.assertEquals(beta, this.poly.getPrefixMapping().getNsPrefixURI("x"));
    }

    public void testQNameComponents() {
        this.g1.getPrefixMapping().setNsPrefix("x", alpha);
        this.g2.getPrefixMapping().setNsPrefix("y", beta);
        TestPolyadicPrefixMapping.assertEquals("x:hoop", this.poly.getPrefixMapping().qnameFor("something:alpha#hoop"));
        TestPolyadicPrefixMapping.assertEquals("y:lens", this.poly.getPrefixMapping().qnameFor("something:beta#lens"));
    }
}

