/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleEventManager
implements GraphEventManager {
    protected Graph graph;
    protected List listeners;

    SimpleEventManager(Graph graph) {
        this.graph = graph;
        this.listeners = new ArrayList();
    }

    public GraphEventManager register(GraphListener graphListener) {
        this.listeners.add(graphListener);
        return this;
    }

    public GraphEventManager unregister(GraphListener graphListener) {
        this.listeners.remove(graphListener);
        return this;
    }

    public boolean listening() {
        return this.listeners.size() > 0;
    }

    public void notifyAddTriple(Graph graph, Triple triple) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddTriple(graph, triple);
        }
    }

    public void notifyAddArray(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddArray(graph, tripleArray);
        }
    }

    public void notifyAddList(Graph graph, List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddList(graph, list);
        }
    }

    public void notifyAddIterator(Graph graph, List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddIterator(graph, list.iterator());
        }
    }

    public void notifyAddIterator(Graph graph, Iterator iterator) {
        this.notifyAddIterator(graph, IteratorCollection.iteratorToList(iterator));
    }

    public void notifyAddGraph(Graph graph, Graph graph2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddGraph(graph, graph2);
        }
    }

    public void notifyDeleteTriple(Graph graph, Triple triple) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteTriple(graph, triple);
        }
    }

    public void notifyDeleteArray(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteArray(graph, tripleArray);
        }
    }

    public void notifyDeleteList(Graph graph, List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteList(graph, list);
        }
    }

    public void notifyDeleteIterator(Graph graph, List list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteIterator(graph, list.iterator());
        }
    }

    public void notifyDeleteIterator(Graph graph, Iterator iterator) {
        this.notifyDeleteIterator(graph, IteratorCollection.iteratorToList(iterator));
    }

    public void notifyDeleteGraph(Graph graph, Graph graph2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteGraph(graph, graph2);
        }
    }

    public void notifyEvent(Graph graph, Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyEvent(graph, object);
        }
    }

    public static ExtendedIterator notifyingRemove(final Graph graph, Iterator iterator) {
        return new TrackingTripleIterator(iterator){
            protected final GraphEventManager gem;
            {
                super(iterator);
                this.gem = graph.getEventManager();
            }

            public void remove() {
                super.remove();
                this.gem.notifyDeleteTriple(graph, this.current);
            }
        };
    }
}

