/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.QueryStageException;
import java.util.NoSuchElementException;

public class BufferPipe
implements Pipe {
    private boolean open = true;
    private BoundedBuffer buffer = new BoundedBuffer(5);
    private Object pending = null;
    private static final Finished finished = new Finished();

    private Object fetch() {
        try {
            return this.buffer.take();
        }
        catch (Exception exception) {
            throw new BoundedBufferTakeException(exception);
        }
    }

    private void putAny(Object object) {
        try {
            this.buffer.put(object);
            return;
        }
        catch (Exception exception) {
            throw new BoundedBufferPutException(exception);
        }
    }

    public void put(Domain domain) {
        this.putAny(domain);
    }

    public void close() {
        this.putAny(finished);
    }

    public void close(Exception exception) {
        this.putAny(new Finished(exception));
    }

    public boolean hasNext() {
        if (this.open) {
            if (this.pending == null) {
                this.pending = this.fetch();
                if (this.pending instanceof Finished) {
                    Finished finished = (Finished)this.pending;
                    RuntimeException runtimeException = finished.getCause();
                    if (runtimeException == null) {
                        this.open = false;
                    } else {
                        throw runtimeException;
                    }
                }
                return this.open;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain get() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Domain domain = (Domain)this.pending;
            return domain;
        }
        finally {
            this.pending = null;
        }
    }

    public static class BoundedBufferPutException
    extends JenaException {
        BoundedBufferPutException(Exception exception) {
            super(exception);
        }
    }

    public static class BoundedBufferTakeException
    extends JenaException {
        BoundedBufferTakeException(Exception exception) {
            super(exception);
        }
    }

    public static class Finished {
        protected RuntimeException e;

        public Finished() {
        }

        public Finished(Exception exception) {
            this.e = new QueryStageException(exception);
        }

        public RuntimeException getCause() {
            return this.e;
        }
    }
}

