/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Set;

public class SimpleTreeQueryPlan
implements TreeQueryPlan {
    private Graph pattern;
    private Graph target;

    public SimpleTreeQueryPlan(Graph graph, Graph graph2) {
        this.target = graph;
        this.pattern = graph2;
    }

    public Graph executeTree() {
        GraphMem graphMem = new GraphMem();
        Set set = SimpleTreeQueryPlan.getRoots(this.pattern);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.handleRoot(graphMem, (Node)iterator.next(), CollectionFactory.createHashedSet());
        }
        return graphMem;
    }

    private Iterator findFromTriple(Graph graph, Triple triple) {
        return graph.find(this.asPattern(triple.getSubject()), this.asPattern(triple.getPredicate()), this.asPattern(triple.getObject()));
    }

    private Node asPattern(Node node) {
        return node.isBlank() ? null : node;
    }

    private void handleRoot(Graph graph, Node node, Set set) {
        ExtendedIterator extendedIterator = this.pattern.find(node, null, null);
        if (!extendedIterator.hasNext()) {
            this.absorb(graph, set);
            return;
        }
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            Iterator iterator = this.findFromTriple(this.target, triple);
            while (iterator.hasNext()) {
                Triple triple2 = (Triple)iterator.next();
                set.add(triple2);
                this.handleRoot(graph, triple.getObject(), set);
            }
        }
    }

    private void absorb(Graph graph, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            graph.add((Triple)iterator.next());
        }
        set.clear();
    }

    public static Set getRoots(Graph graph) {
        Set set = CollectionFactory.createHashedSet();
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            set.add(((Triple)extendedIterator.next()).getSubject());
        }
        ExtendedIterator extendedIterator2 = GraphUtil.findAll(graph);
        while (extendedIterator2.hasNext()) {
            set.remove(((Triple)extendedIterator2.next()).getObject());
        }
        return set;
    }
}

