/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees;

import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;

public abstract class Text
extends RegexpTree {
    public static Text create(String string) {
        return string.length() == 1 ? new TextChar(string.charAt(0)) : new TextString(string);
    }

    public static Text create(char c) {
        return new TextChar(c);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getString();

    static class TextChar
    extends Text {
        protected char ch;

        TextChar(char c) {
            this.ch = c;
        }

        public String getString() {
            return "" + this.ch;
        }

        public String toString() {
            return "<text.ch '" + this.ch + "'>";
        }

        public boolean equals(Object object) {
            return object instanceof TextChar && this.ch == ((TextChar)object).ch;
        }

        public int hashCode() {
            return this.ch;
        }
    }

    static class TextString
    extends Text {
        protected String literal;

        TextString(String string) {
            this.literal = string;
        }

        public String getString() {
            return this.literal;
        }

        public String toString() {
            return "<text.s '" + this.literal + "'>";
        }

        public boolean equals(Object object) {
            return object instanceof TextString && this.literal.equals(((TextString)object).literal);
        }

        public int hashCode() {
            return this.literal.hashCode();
        }
    }
}

