/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.Nothing;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.PerlPatternParser;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestPerlyParser
extends GraphTestBase {
    public TestPerlyParser(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPerlyParser.class);
    }

    public void testAlternateGenerator() {
        SimpleGenerator simpleGenerator = new SimpleGenerator(){

            public RegexpTree getAnySingle() {
                throw new FlagException();
            }
        };
        PerlPatternParser perlPatternParser = new PerlPatternParser(".", simpleGenerator);
        try {
            perlPatternParser.parseAtom();
            TestPerlyParser.fail("should be using supplied generator");
        }
        catch (FlagException flagException) {
            TestPerlyParser.pass();
        }
    }

    public void testLit() {
        TestPerlyParser.assertEquals(Text.create("a"), Text.create("a"));
        TestPerlyParser.assertDiffer(Text.create("a"), Text.create("b"));
        TestPerlyParser.assertEquals(Text.create("aga").hashCode(), Text.create("aga").hashCode());
    }

    public void testInitialParserState() {
        TestPerlyParser.assertEquals(0, new PerlPatternParser("hello").getPointer());
        TestPerlyParser.assertEquals("hello", new PerlPatternParser("hello").getString());
    }

    public void testLetterAtoms() {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            if (!Character.isLetter(c)) continue;
            PerlPatternParser perlPatternParser = new PerlPatternParser("" + c);
            TestPerlyParser.assertEquals(Text.create(c), perlPatternParser.parseAtom());
            TestPerlyParser.assertEquals(1, perlPatternParser.getPointer());
        }
    }

    public void testEmptyExpression() {
        TestPerlyParser.assertEquals(new Nothing(), this.element(""));
    }

    public void testDotAtom() {
        this.testSimpleSpecialAtom(RegexpTree.ANY, ".");
    }

    public void testHatAtom() {
        this.testSimpleSpecialAtom(RegexpTree.SOL, "^");
    }

    public void testDollarAtom() {
        this.testSimpleSpecialAtom(RegexpTree.EOL, "$");
    }

    public void testTerminatorsReturnNull() {
        TestPerlyParser.assertEquals(new Nothing(), this.element("|"));
    }

    public void testSimpleBackslashEscapes() {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            if ("bBAZnrtfdDwWSsxc0123456789".indexOf(c) >= 0) continue;
            TestPerlyParser.assertEquals(Text.create(c), new PerlPatternParser("\\" + c).parseAtom());
        }
    }

    public void testSpecialBackslashEscapes() {
        String string = "bBAZ";
        for (int i = 0; i < string.length(); ++i) {
            try {
                new PerlPatternParser("\\" + string.charAt(i)).parseAtom();
                TestPerlyParser.fail("backslash escape " + string.charAt(i));
                continue;
            }
            catch (PerlPatternParser.SyntaxException syntaxException) {
                TestPerlyParser.pass();
            }
        }
    }

    public void testWordEscapes() {
        String string = "abcdefghijklmnopqrstuvwxyz";
        String string2 = "0123456789" + string + "_" + string.toUpperCase();
        TestPerlyParser.assertEquals(new AnyOf(string2), this.element("\\w"));
        TestPerlyParser.assertEquals(new NoneOf(string2), this.element("\\W"));
    }

    public void testDigitEscapes() {
        TestPerlyParser.assertEquals(new AnyOf("0123456789"), this.element("\\d"));
        TestPerlyParser.assertEquals(new NoneOf("0123456789"), this.element("\\D"));
    }

    public void testWhitespaceEscapes() {
        TestPerlyParser.assertEquals(Text.create("\n"), this.element("\\n"));
        TestPerlyParser.assertEquals(Text.create("\t"), this.element("\\t"));
        TestPerlyParser.assertEquals(Text.create("\f"), this.element("\\f"));
        TestPerlyParser.assertEquals(Text.create("\r"), this.element("\\r"));
        TestPerlyParser.assertEquals(new AnyOf(" \r\n\t\f"), this.element("\\s"));
        TestPerlyParser.assertEquals(new NoneOf(" \r\n\t\f"), this.element("\\S"));
    }

    public void testHexEscapes() {
        this.assertParse(Text.create("\u00ac"), "\\xac");
        this.assertParse(Text.create("\u00ff"), "\\xff");
        this.assertParse(Text.create("\u0012"), "\\x12");
        this.assertParse(Text.create("\u00af"), "\\xAF");
    }

    public void testControlEscapes() {
        this.assertParse(Text.create("\u0001"), "\\cA");
        this.assertParse(Text.create("\u001a"), "\\cZ");
    }

    public void testNoQuantifier() {
        RegexpTree regexpTree = RegexpTree.ANY;
        TestPerlyParser.assertSame(regexpTree, this.quantifier("", regexpTree));
        TestPerlyParser.assertSame(regexpTree, this.quantifier("x", regexpTree));
        TestPerlyParser.assertSame(regexpTree, this.quantifier("[", regexpTree));
        TestPerlyParser.assertSame(regexpTree, this.quantifier("(", regexpTree));
        TestPerlyParser.assertSame(regexpTree, this.quantifier(".", regexpTree));
        TestPerlyParser.assertSame(regexpTree, this.quantifier("\\", regexpTree));
    }

    public void testStarQuantifier() {
        RegexpTree regexpTree = RegexpTree.EOL;
        TestPerlyParser.assertEquals(new ZeroOrMore(regexpTree), this.quantifier("*", regexpTree));
    }

    public void testPlusQuantifier() {
        RegexpTree regexpTree = RegexpTree.SOL;
        TestPerlyParser.assertEquals(new OneOrMore(regexpTree), this.quantifier("+", regexpTree));
    }

    public void testQueryQuantifier() {
        RegexpTree regexpTree = RegexpTree.ANY;
        TestPerlyParser.assertEquals(new Optional(regexpTree), this.quantifier("?", regexpTree));
    }

    public void testUnboundQuantifiers() {
        this.testUnboundQuantifier("*");
        this.testUnboundQuantifier("+");
        this.testUnboundQuantifier("?");
        this.testUnboundQuantifier("{");
    }

    private void testUnboundQuantifier(String string) {
        PerlPatternParser perlPatternParser = new PerlPatternParser(string);
        try {
            perlPatternParser.parseElement();
            TestPerlyParser.fail("must trap unbound quantifier " + string);
        }
        catch (PerlPatternParser.SyntaxException syntaxException) {
            TestPerlyParser.pass();
        }
    }

    public void testUnitSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("x");
        TestPerlyParser.assertEquals(Text.create("x"), perlPatternParser.parseSeq());
    }

    public void testSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("^.$");
        TestPerlyParser.assertEquals(this.seq3(new StartOfLine(), new AnySingle(), new EndOfLine()), perlPatternParser.parseSeq());
    }

    public void testBracketConstruction() {
        this.assertParse(new Paren(Text.create("x")), "(x)");
    }

    public void testBracketClosure() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("()y");
        TestPerlyParser.assertEquals(this.seq2(new Paren(new Nothing()), Text.create("y")), perlPatternParser.parseAlts());
    }

    public void testDetectsMissingClosingBracket() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("(x");
        try {
            perlPatternParser.parseAlts();
            TestPerlyParser.fail("should detect missing close bracket");
        }
        catch (PerlPatternParser.SyntaxException syntaxException) {
            TestPerlyParser.pass();
        }
    }

    public void testAlt() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("abc");
        PerlPatternParser perlPatternParser2 = new PerlPatternParser("def");
        PerlPatternParser perlPatternParser3 = new PerlPatternParser("abc|def");
        TestPerlyParser.assertEquals(this.alt(perlPatternParser.parseSeq(), perlPatternParser2.parseSeq()), perlPatternParser3.parseAlts());
    }

    public void testSimpleClass() {
        this.assertParse(new AnyOf("x1B"), "[x1B]");
    }

    public void testSimpleClassNegated() {
        this.assertParse(new NoneOf("b0#"), "[^b0#]");
    }

    public void testClassRangeAlphabet() {
        this.assertParse(new AnyOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "[A-Z]");
    }

    public void testClassRangeSomeLetters() {
        this.assertParse(new AnyOf("abcdef"), "[a-f]");
    }

    public void testClassRangeDigits() {
        this.assertParse(new AnyOf("abc0123456789rst"), "[a-c0-9r-t]");
    }

    public void testClassHats() {
        this.assertParse(new AnyOf("ab^cd"), "[ab^cd]");
    }

    public void testClassRange() {
        this.assertParse(new AnyOf("-R"), "[-R]");
    }

    public void testClassBackslash() {
        this.assertParse(new AnyOf("]"), "[\\]]");
    }

    public void testBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), new BackReference(1)), "(x)\\1");
    }

    public void testOctalNonBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), Text.create("\b")), "(x)\\10");
    }

    protected RegexpTree seq2(RegexpTree regexpTree, RegexpTree regexpTree2) {
        return Sequence.create(Arrays.asList(regexpTree, regexpTree2));
    }

    protected RegexpTree seq3(RegexpTree regexpTree, RegexpTree regexpTree2, RegexpTree regexpTree3) {
        return Sequence.create(Arrays.asList(regexpTree, regexpTree2, regexpTree3));
    }

    protected RegexpTree alt(RegexpTree regexpTree, RegexpTree regexpTree2) {
        return Alternatives.create(Arrays.asList(regexpTree, regexpTree2));
    }

    public void testPerlParse() {
        TestPerlyParser.assertTrue(PerlPatternParser.parse("this is|a pattern") instanceof Alternatives);
        TestPerlyParser.assertTrue(PerlPatternParser.parse("this is|a pattern", new SimpleGenerator()) instanceof Alternatives);
    }

    public void testOldSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("hello");
        TestPerlyParser.assertEquals(Text.create("h"), perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(1, perlPatternParser.getPointer());
        TestPerlyParser.assertEquals(Text.create("e"), perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(2, perlPatternParser.getPointer());
        TestPerlyParser.assertEquals(Text.create("l"), perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(3, perlPatternParser.getPointer());
        TestPerlyParser.assertEquals(Text.create("l"), perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(4, perlPatternParser.getPointer());
        TestPerlyParser.assertEquals(Text.create("o"), perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(5, perlPatternParser.getPointer());
        TestPerlyParser.assertEquals(new Nothing(), perlPatternParser.parseAtom());
    }

    public void assertParse(RegexpTree regexpTree, String string) {
        TestPerlyParser.assertEquals(regexpTree, new PerlPatternParser(string).parseAlts());
    }

    public void testSimpleSpecialAtom(Object object, String string) {
        PerlPatternParser perlPatternParser = new PerlPatternParser(string);
        TestPerlyParser.assertEquals(object, perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals(1, perlPatternParser.getPointer());
    }

    protected RegexpTree quantifier(String string, RegexpTree regexpTree) {
        return new PerlPatternParser(string).parseQuantifier(regexpTree);
    }

    protected RegexpTree element(String string) {
        return new PerlPatternParser(string).parseElement();
    }

    protected static class FlagException
    extends RuntimeException {
        protected FlagException() {
        }
    }
}

