/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.QueryStageException;
import junit.framework.TestSuite;

public class TestBufferPipe
extends GraphTestBase {
    public TestBufferPipe(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBufferPipe.class);
    }

    public void testEmpty() {
        BufferPipe bufferPipe = new BufferPipe();
        bufferPipe.close();
        TestBufferPipe.assertFalse(bufferPipe.hasNext());
    }

    public void testNonEmpty() {
        BufferPipe bufferPipe = new BufferPipe();
        bufferPipe.put(new Domain(0));
        bufferPipe.close();
        TestBufferPipe.assertTrue(bufferPipe.hasNext());
        bufferPipe.get();
        TestBufferPipe.assertFalse(bufferPipe.hasNext());
    }

    public void testExceptions() {
        BufferPipe bufferPipe = new BufferPipe();
        JenaException jenaException = new JenaException("bang");
        bufferPipe.close(jenaException);
        try {
            bufferPipe.get();
            TestBufferPipe.fail("bang disappeared");
        }
        catch (QueryStageException queryStageException) {
            TestBufferPipe.pass();
        }
    }
}

