/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.PatternLiteral;
import com.hp.hpl.jena.graph.query.Rewrite;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import junit.framework.TestSuite;

public class TestExpressions
extends QueryTestBase {
    public TestExpressions(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestExpressions.class);
    }

    public void testExpressionPatternLanguages() {
        TestExpressions.assertEquals("http://jena.hpl.hp.com/2003/07/query/RDQL", "http://jena.hpl.hp.com/2003/07/query/RDQL");
    }

    public void testBooleanEquality() {
        TestExpressions.assertEquals(Expression.TRUE, Expression.TRUE);
        TestExpressions.assertEquals(Expression.FALSE, Expression.FALSE);
        TestExpressions.assertDiffer(Expression.TRUE, Expression.FALSE);
        TestExpressions.assertDiffer(Expression.FALSE, Expression.TRUE);
    }

    public void testDyadicEquality() {
        Expression expression = this.lit("Aaa");
        Expression expression2 = this.lit("Bee");
        TestExpressions.assertDiffer(expression, expression2);
        TestExpressions.assertEquals(this.contains(expression, "groo"), this.contains(expression, "groo"));
        TestExpressions.assertEquals(this.contains(expression2, "oops"), this.contains(expression2, "oops"));
        TestExpressions.assertDiffer(this.contains(expression, "groo"), this.contains(expression, "glue"));
        TestExpressions.assertDiffer(this.contains(expression, "groo"), this.contains(expression2, "groo"));
        TestExpressions.assertDiffer(this.contains(expression, "blue"), this.startsWith(expression, "blue"));
        TestExpressions.assertDiffer(this.contains(expression, "blue"), this.endsWith(expression, "blue"));
        TestExpressions.assertDiffer(this.endsWith(expression, "blue"), this.startsWith(expression, "blue"));
    }

    public Expression contains(Expression expression, PatternLiteral patternLiteral) {
        return Rewrite.contains(expression, patternLiteral.getPatternString(), patternLiteral.getPatternModifiers());
    }

    public Expression contains(Expression expression, String string) {
        return Rewrite.contains(expression, string, "");
    }

    public Expression endsWith(Expression expression, String string) {
        return Rewrite.endsWith(expression, string, "");
    }

    public Expression endsWith(Expression expression, PatternLiteral patternLiteral) {
        return Rewrite.endsWith(expression, patternLiteral.getPatternString(), patternLiteral.getPatternModifiers());
    }

    public Expression startsWith(Expression expression, String string) {
        return Rewrite.startsWith(expression, string, "");
    }

    public Expression startsWith(Expression expression, PatternLiteral patternLiteral) {
        return Rewrite.startsWith(expression, patternLiteral.getPatternString(), patternLiteral.getPatternModifiers());
    }

    public void testLiterals() {
        TestExpressions.assertTrue(Expression.TRUE.isConstant());
        TestExpressions.assertTrue(Expression.FALSE.isConstant());
        TestExpressions.assertEquals(Boolean.TRUE, Expression.TRUE.getValue());
        TestExpressions.assertEquals(Boolean.FALSE, Expression.FALSE.getValue());
    }

    public void testPrepareTRUE() {
        Valuator valuator = Expression.TRUE.prepare(emptyMapping);
        TestExpressions.assertEquals(true, valuator.evalBool(noIVs));
        TestExpressions.assertEquals(Boolean.TRUE, valuator.evalObject(noIVs));
    }

    public void testPrepareFALSE() {
        Valuator valuator = Expression.FALSE.prepare(emptyMapping);
        TestExpressions.assertEquals(false, valuator.evalBool(noIVs));
        TestExpressions.assertEquals(Boolean.FALSE, valuator.evalObject(noIVs));
    }

    public void testFixed() {
        this.testFixed("hello");
        this.testFixed("goodbye");
        this.testFixed(Boolean.TRUE);
        this.testFixed(new int[]{17, 27, 42});
    }

    protected void testFixed(Object object) {
        Expression expression = this.lit(object);
        TestExpressions.assertEquals(object, expression.getValue());
        TestExpressions.assertEquals(object, this.evalObject(expression));
    }

    public void testDyadic() {
        Expression expression = this.lit("a");
        Expression expression2 = this.lit("b");
        Dyadic dyadic = new Dyadic(expression, "eh:op", expression2){

            public Object evalObject(Object object, Object object2) {
                return "" + object + "--" + object2;
            }
        };
        TestExpressions.assertEquals(2, dyadic.argCount());
        TestExpressions.assertSame(expression, dyadic.getArg(0));
        TestExpressions.assertSame(expression2, dyadic.getArg(1));
        TestExpressions.assertEquals("eh:op", dyadic.getFun());
        TestExpressions.assertEquals((Object)"a--b", this.evalObject(dyadic));
    }

    public void testStartsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "h")));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "he")));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("HELLO"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "HEL")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "e")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "llo")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "xhe")));
    }

    public void testStartsInsensitiveWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), this.pli("H"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hEllo"), this.pli("he"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("heLlo"), this.pli("hEl"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("HELLO"), this.pli("hel"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), this.pli("HEL"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("e"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("llo"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("xhe"))));
    }

    public void testIsContains() {
        TestExpressions.assertEquals(true, Rewrite.isContains(this.pl("ambulance")));
        TestExpressions.assertEquals(true, Rewrite.isContains(this.pl("tendonitis", "i")));
        TestExpressions.assertEquals(false, Rewrite.isContains(this.pl("finishing", "z")));
    }

    public void testSensitiveContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "h")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "e")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("heLLo"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "LL")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "x")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "the")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "lot")));
    }

    public void testInsensitiveContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("Hello"), this.pli("h"))));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), this.pli("E"))));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("heLlo"), this.pli("lL"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("X"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("the"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("lot"))));
    }

    public void testEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "o")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "lo")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "hello")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("HELLO"), "hello")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "HELLO")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "quantum")));
    }

    public void testInsensitiveEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hellO"), this.pli("o"))));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), this.pli("lO"))));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("HeLLo"), this.pli("HELlo"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("ll"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("hel"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("quantum"))));
    }

    private Object evalObject(Expression expression) {
        return expression.prepare(emptyMapping).evalObject(noIVs);
    }

    private boolean evalBool(Expression expression) {
        return expression.prepare(emptyMapping).evalBool(noIVs);
    }

    protected Expression lit(Object object) {
        return new Expression.Fixed(object);
    }

    protected PatternLiteral pl(String string) {
        return this.pl(string, "");
    }

    protected PatternLiteral pli(String string) {
        return this.pl(string, "i");
    }

    protected PatternLiteral pl(final String string, final String string2) {
        return new PatternLiteral(){

            public String getPatternString() {
                return string;
            }

            public String getPatternModifiers() {
                return string2;
            }

            public String getPatternLanguage() {
                return "http://jena.hpl.hp.com/2003/07/query/RDQL";
            }
        };
    }
}

