/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.db.impl.DBReifier;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class AbstractTestReifier
extends GraphTestBase {
    protected static final ReificationStyle Minimal = ReificationStyle.Minimal;
    protected static final ReificationStyle Standard = ReificationStyle.Standard;
    protected static final ReificationStyle Convenient = ReificationStyle.Convenient;
    protected static final Triple ALL = Triple.create("?? ?? ??");

    public AbstractTestReifier(String string) {
        super(string);
    }

    public Graph getGraph() {
        return this.getGraph(Minimal);
    }

    public abstract Graph getGraph(ReificationStyle var1);

    protected final Graph getGraphWith(String string) {
        Graph graph = this.getGraph();
        AbstractTestReifier.graphAdd(graph, string);
        return graph;
    }

    protected final Graph graphWithUnless(boolean bl, String string) {
        return AbstractTestReifier.graphWith(bl ? "" : string);
    }

    protected final Graph graphWithIf(boolean bl, String string) {
        return this.graphWithUnless(!bl, string);
    }

    public void testStyle() {
        AbstractTestReifier.assertSame(Minimal, this.getGraph(Minimal).getReifier().getStyle());
        AbstractTestReifier.assertSame(Standard, this.getGraph(Standard).getReifier().getStyle());
        AbstractTestReifier.assertSame(Convenient, this.getGraph(Convenient).getReifier().getStyle());
    }

    public void testEmptyReifiers() {
        AbstractTestReifier.assertFalse(this.getGraphWith("x R y").getReifier().findExposed(ALL).hasNext());
        AbstractTestReifier.assertFalse(this.getGraphWith("x R y; p S q").getReifier().findExposed(ALL).hasNext());
    }

    public void testSameReifier() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.add(AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertTrue("same reifier", reifier == graph.getReifier());
    }

    public void testReifierClosed() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.close();
    }

    public void testParent() {
        Graph graph = this.getGraph();
        Graph graph2 = this.getGraph();
        AbstractTestReifier.assertTrue("correct reifier (G)", graph == graph.getReifier().getParentGraph());
        AbstractTestReifier.assertTrue("correct reifier (H)", graph2 == graph2.getReifier().getParentGraph());
    }

    public void testIntercept() {
        Graph graph = this.getGraph(Convenient);
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("sub");
        Node node2 = AbstractTestReifier.node("obj");
        Node node3 = AbstractTestReifier.node("http://example.org/type");
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(Triple.create(node, RDF.Nodes.type, node3)));
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(Triple.create(node, node, RDF.Nodes.subject)));
        AbstractTestReifier.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(Triple.create(node, node, RDF.Nodes.type)));
        AbstractTestReifier.assertTrue("reifier must intercept quadlet", reifier.handledAdd(Triple.create(node, RDF.Nodes.predicate, node2)));
        AbstractTestReifier.assertTrue("reifier must intercept quadlet", reifier.handledAdd(Triple.create(node, RDF.Nodes.type, RDF.Nodes.Statement)));
    }

    public void testStandard() {
        Graph graph = this.getGraph(Standard);
        AbstractTestReifier.assertFalse(graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
        graph.add(Triple.create("x rdf:subject s"));
        AbstractTestReifier.assertEquals(1, graph.size());
        graph.add(Triple.create("x rdf:predicate p"));
        AbstractTestReifier.assertEquals(2, graph.size());
        graph.add(Triple.create("x rdf:object o"));
        AbstractTestReifier.assertEquals(3, graph.size());
        graph.add(Triple.create("x rdf:type rdf:Statement"));
        AbstractTestReifier.assertEquals(4, graph.size());
        AbstractTestReifier.assertTrue(graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
    }

    public void testStandardExplode() {
        Graph graph = this.getGraph(Standard);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        Graph graph2 = Factory.createDefaultGraph(Minimal);
        AbstractTestReifier.graphAdd(graph2, "a rdf:type rdf:Statement; a rdf:subject p; a rdf:predicate Q; a rdf:object r");
        AbstractTestReifier.assertEquals(4, graph.size());
        AbstractTestReifier.assertIsomorphic(graph2, graph);
    }

    public void testMinimalExplode() {
        Graph graph = this.getGraph(Minimal);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        AbstractTestReifier.assertEquals(0, graph.size());
    }

    public void testReificationTriplesConvenient() {
        this.testReificationTriples(Convenient);
    }

    public void testReificationTriplesStandard() {
        this.testReificationTriples(Standard);
    }

    public void testReificationQuadletsMinimal() {
        this.testReificationTriples(Minimal);
    }

    protected void testReificationTriples(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Graph graph2 = AbstractTestReifier.getReificationTriples(graph.getReifier());
        String string = "SSS rdf:predicate PPP";
        String string2 = "SSS rdf:subject SSS";
        graph.add(AbstractTestReifier.triple(string));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(reificationStyle == Minimal, string), graph2);
        graph.add(AbstractTestReifier.triple(string2));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(reificationStyle == Minimal, string + "; " + string2), graph2);
        AbstractTestReifier.assertEquals("convenient hides quadlets", reificationStyle == Convenient, graph.size() == 0);
    }

    public void testOverspecificationSuppressesReification() {
        Graph graph = this.getGraph(Standard);
        Reifier reifier = graph.getReifier();
        AbstractTestReifier.graphAdd(graph, "x rdf:subject A; x rdf:predicate P; x rdf:object O; x rdf:type rdf:Statement");
        AbstractTestReifier.assertEquals(AbstractTestReifier.triple("A P O"), reifier.getTriple(AbstractTestReifier.node("x")));
        try {
            AbstractTestReifier.graphAdd(graph, "x rdf:subject BOOM");
            AbstractTestReifier.assertEquals(null, reifier.getTriple(AbstractTestReifier.node("x")));
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            if (reifier instanceof DBReifier) {
                System.err.println("! Db reifier must fix over-specification problem");
            }
            throw alreadyReifiedException;
        }
    }

    public void testReificationSubjectClash() {
        this.testReificationClash("x rdf:subject SS");
    }

    public void testReificationPredicateClash() {
        this.testReificationClash("x rdf:predicate PP");
    }

    public void testReificationObjectClash() {
        this.testReificationClash("x rdf:object OO");
    }

    protected void testReificationClash(String string) {
        Graph graph = this.getGraph(Standard);
        Triple triple = Triple.create("S P O");
        graph.getReifier().reifyAs(AbstractTestReifier.node("x"), triple);
        AbstractTestReifier.assertTrue(graph.getReifier().hasTriple(triple));
        try {
            AbstractTestReifier.graphAdd(graph, string);
            AbstractTestReifier.assertEquals(null, graph.getReifier().getTriple(AbstractTestReifier.node("x")));
            AbstractTestReifier.assertFalse(graph.getReifier().hasTriple(triple));
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            if (graph.getReifier() instanceof DBReifier) {
                System.err.println("! Db reifier must fix over-specification problem");
            }
            throw alreadyReifiedException;
        }
    }

    public void testManifestQuadsStandard() {
        this.testManifestQuads(Standard);
    }

    public void testManifestQuadsConvenient() {
        this.testManifestQuads(Convenient);
    }

    public void testManifestQuadsMinimal() {
        this.testManifestQuads(Minimal);
    }

    public void testManifestQuads(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Reifier reifier = graph.getReifier();
        reifier.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        String string = "A rdf:type rdf:Statement; A rdf:subject S; A rdf:predicate P; A rdf:object O";
        AbstractTestReifier.assertIsomorphic(this.graphWithIf(reificationStyle == Standard, string), graph);
    }

    public void testHiddenVsReificationMinimal() {
        this.testHiddenVsReification(Minimal);
    }

    public void testHiddenVsStandard() {
        this.testHiddenVsReification(Standard);
    }

    public void testHiddenVsReificationConvenient() {
        this.testHiddenVsReification(Convenient);
    }

    public void testHiddenVsReification(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Reifier reifier = graph.getReifier();
        reifier.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        AbstractTestReifier.assertEquals(reificationStyle == Standard, reifier.findEither(ALL, false).hasNext());
    }

    public void testRetrieveTriplesByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createAnon();
        Node node2 = Node.createAnon();
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertEquals("gets correct triple", AbstractTestReifier.triple("x R y"), reifier.getTriple(node));
        reifier.reifyAs(node2, AbstractTestReifier.triple("p S q"));
        AbstractTestReifier.assertDiffer("the anon nodes must be distinct", node, node2);
        AbstractTestReifier.assertEquals("gets correct triple", AbstractTestReifier.triple("p S q"), reifier.getTriple(node2));
        AbstractTestReifier.assertTrue("node is known bound", reifier.hasTriple(node2));
        AbstractTestReifier.assertTrue("node is known bound", reifier.hasTriple(node));
        AbstractTestReifier.assertFalse("node is known unbound", reifier.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Triple triple = AbstractTestReifier.triple("x R y");
        Triple triple2 = AbstractTestReifier.triple("y R x");
        Node node = AbstractTestReifier.node("someNode");
        reifier.reifyAs(node, triple);
        AbstractTestReifier.assertTrue("R must have T", reifier.hasTriple(triple));
        AbstractTestReifier.assertFalse("R must not have T2", reifier.hasTriple(triple2));
    }

    public void testReifyAs() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createURI("some:uri");
        AbstractTestReifier.assertEquals("node used", node, reifier.reifyAs(node, AbstractTestReifier.triple("x R y")));
        AbstractTestReifier.assertEquals("retrieves correctly", AbstractTestReifier.triple("x R y"), reifier.getTriple(node));
    }

    public void testAllNodes() {
        Reifier reifier = this.getGraph().getReifier();
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("cows eat grass"));
        reifier.reifyAs(AbstractTestReifier.node("y"), AbstractTestReifier.triple("pigs can fly"));
        reifier.reifyAs(AbstractTestReifier.node("z"), AbstractTestReifier.triple("dogs may bark"));
        AbstractTestReifier.assertEquals("", this.nodeSet("z y x"), AbstractTestReifier.iteratorToSet(reifier.allNodes()));
    }

    public void testRemoveByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R a"));
        reifier.reifyAs(node2, AbstractTestReifier.triple("y R a"));
        reifier.remove(node, AbstractTestReifier.triple("x R a"));
        AbstractTestReifier.assertFalse("triple X has gone", reifier.hasTriple(node));
        AbstractTestReifier.assertEquals("triple Y still there", AbstractTestReifier.triple("y R a"), reifier.getTriple(node2));
    }

    public void testRemoveFromNothing() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.delete(AbstractTestReifier.triple("quint rdf:subject S"));
    }

    public void testException() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        try {
            reifier.reifyAs(node, AbstractTestReifier.triple("x R z"));
            AbstractTestReifier.fail("did not detect already reified node");
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    public void testKevinCaseA() {
        Graph graph = this.getGraph(Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("a");
        Node node3 = AbstractTestReifier.node("b");
        Node node4 = AbstractTestReifier.node("c");
        graph.add(Triple.create(node, RDF.Nodes.type, RDF.Nodes.Statement));
        graph.getReifier().reifyAs(node, Triple.create(node2, node3, node4));
    }

    public void testKevinCaseB() {
        Graph graph = this.getGraph(Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        Node node3 = AbstractTestReifier.node("a");
        Node node4 = AbstractTestReifier.node("b");
        Node node5 = AbstractTestReifier.node("c");
        graph.add(Triple.create(node, RDF.Nodes.subject, node2));
        try {
            graph.getReifier().reifyAs(node, Triple.create(node3, node4, node5));
            AbstractTestReifier.fail("X already has subject Y: cannot make it a");
        }
        catch (CannotReifyException cannotReifyException) {
            AbstractTestReifier.pass();
        }
    }

    public void testDynamicHiddenTriples() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Graph graph2 = this.getHiddenTriples(reifier);
        Graph graph3 = AbstractTestReifier.graphWith("x rdf:type rdf:Statement; x rdf:subject a; x rdf:predicate B; x rdf:object c");
        AbstractTestReifier.assertTrue(graph2.isEmpty());
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("a B c"));
        AbstractTestReifier.assertIsomorphic(graph3, graph2);
    }

    protected Graph getHiddenTriples(final Reifier reifier) {
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return reifier.findEither(tripleMatch, true);
            }
        };
    }

    public void testQuadRemove() {
        Graph graph = this.getGraph(Standard);
        AbstractTestReifier.assertEquals(0, graph.size());
        Triple triple = Triple.create("x rdf:subject s");
        Triple triple2 = Triple.create("x rdf:predicate p");
        Triple triple3 = Triple.create("x rdf:object o");
        Triple triple4 = Triple.create("x rdf:type rdf:Statement");
        graph.add(triple);
        graph.add(triple2);
        graph.add(triple3);
        graph.add(triple4);
        AbstractTestReifier.assertEquals(4, graph.size());
        graph.delete(triple);
        graph.delete(triple2);
        graph.delete(triple3);
        graph.delete(triple4);
        AbstractTestReifier.assertEquals(0, graph.size());
    }

    public void testReifierSize() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        AbstractTestReifier.assertEquals(0, reifier.size());
    }

    public void testEmpty() {
        Graph graph = this.getGraph(Standard);
        AbstractTestReifier.assertTrue(graph.isEmpty());
        AbstractTestReifier.graphAdd(graph, "x rdf:type rdf:Statement");
        AbstractTestReifier.assertFalse(graph.isEmpty());
        AbstractTestReifier.graphAdd(graph, "x rdf:subject Deconstruction");
        AbstractTestReifier.assertFalse(graph.isEmpty());
        AbstractTestReifier.graphAdd(graph, "x rdf:predicate rdfs:subTypeOf");
        AbstractTestReifier.assertFalse(graph.isEmpty());
        AbstractTestReifier.graphAdd(graph, "x rdf:object LiteraryCriticism");
        AbstractTestReifier.assertFalse(graph.isEmpty());
    }

    public void testReifierEmptyFind() {
        Graph graph = this.getGraph(Standard);
        Reifier reifier = graph.getReifier();
        AbstractTestReifier.assertEquals(CollectionFactory.createHashedSet(), AbstractTestReifier.iteratorToSet(reifier.findExposed(AbstractTestReifier.triple("?? ?? ??"))));
    }

    public void testReifierFindSubject() {
        this.testReifierFind("x rdf:subject S");
    }

    public void testReifierFindObject() {
        this.testReifierFind("x rdf:object O");
    }

    public void testReifierFindPredicate() {
        this.testReifierFind("x rdf:predicate P");
    }

    public void testReifierFindComplete() {
        this.testReifierFind("x rdf:predicate P; x rdf:subject S; x rdf:object O; x rdf:type rdf:Statement");
    }

    public void testReifierFindFilter() {
        Graph graph = this.getGraph(Standard);
        Reifier reifier = graph.getReifier();
        AbstractTestReifier.graphAdd(graph, "s rdf:subject S");
        AbstractTestReifier.assertEquals(AbstractTestReifier.tripleSet(""), AbstractTestReifier.iteratorToSet(reifier.findExposed(AbstractTestReifier.triple("s otherPredicate S"))));
    }

    protected void testReifierFind(String string) {
        this.testReifierFind(string, "?? ?? ??");
    }

    protected void testReifierFind(String string, String string2) {
        Graph graph = this.getGraph(Standard);
        Reifier reifier = graph.getReifier();
        AbstractTestReifier.graphAdd(graph, string);
        AbstractTestReifier.assertEquals(AbstractTestReifier.tripleSet(string), AbstractTestReifier.iteratorToSet(reifier.findExposed(AbstractTestReifier.triple(string2))));
    }
}

