/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class RecordingListener
implements GraphListener {
    public List history = new ArrayList();

    public void notifyAddTriple(Graph graph, Triple triple) {
        this.record("add", graph, triple);
    }

    public void notifyAddArray(Graph graph, Triple[] tripleArray) {
        this.record("add[]", graph, tripleArray);
    }

    public void notifyAddList(Graph graph, List list) {
        this.record("addList", graph, list);
    }

    public void notifyAddIterator(Graph graph, Iterator iterator) {
        this.record("addIterator", graph, GraphTestBase.iteratorToList(iterator));
    }

    public void notifyAddGraph(Graph graph, Graph graph2) {
        this.record("addGraph", graph, graph2);
    }

    public void notifyDeleteTriple(Graph graph, Triple triple) {
        this.record("delete", graph, triple);
    }

    public void notifyDeleteArray(Graph graph, Triple[] tripleArray) {
        this.record("delete[]", graph, tripleArray);
    }

    public void notifyDeleteList(Graph graph, List list) {
        this.record("deleteList", graph, list);
    }

    public void notifyDeleteIterator(Graph graph, Iterator iterator) {
        this.record("deleteIterator", graph, GraphTestBase.iteratorToList(iterator));
    }

    public void notifyDeleteGraph(Graph graph, Graph graph2) {
        this.record("deleteGraph", graph, graph2);
    }

    public void notifyEvent(Graph graph, Object object) {
        this.record("someEvent", graph, object);
    }

    protected void record(String string, Object object, Object object2) {
        this.history.add(string);
        this.history.add(object);
        this.history.add(object2);
    }

    protected void record(String string, Object object) {
        this.history.add(string);
        this.history.add(object);
    }

    public void clear() {
        this.history.clear();
    }

    public boolean has(List list) {
        return ((Object)this.history).equals(list);
    }

    public boolean hasStart(List list) {
        return list.size() <= this.history.size() && ((Object)list).equals(this.history.subList(0, list.size()));
    }

    public boolean hasEnd(List list) {
        return list.size() <= this.history.size() && ((Object)list).equals(this.history.subList(this.history.size() - list.size(), this.history.size()));
    }

    public boolean has(Object[] objectArray) {
        return this.has(Arrays.asList(objectArray));
    }

    public void assertHas(List list) {
        if (!this.has(list)) {
            Assert.fail("expected " + list + " but got " + this.history);
        }
    }

    public void assertHas(Object[] objectArray) {
        this.assertHas(Arrays.asList(objectArray));
    }

    public void assertHasStart(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        if (!this.hasStart(list)) {
            Assert.fail("expected " + list + " at the beginning of " + this.history);
        }
    }

    public void assertHasEnd(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        if (!this.hasEnd(list)) {
            Assert.fail("expected " + list + " at the end of " + this.history);
        }
    }
}

