/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.test.AbstractTestGraphMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import junit.framework.TestSuite;

public class TestFileGraphMaker
extends AbstractTestGraphMaker {
    public TestFileGraphMaker(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileGraphMaker.class);
    }

    public GraphMaker getGraphMaker() {
        String string = FileUtils.getScratchDirectory("jena-test-FileGraphMaker").getPath();
        return new FileGraphMaker(string, ReificationStyle.Minimal, true);
    }

    public void testToFilename() {
        TestFileGraphMaker.assertEquals("plain", FileGraphMaker.toFilename("plain"));
        TestFileGraphMaker.assertEquals("with_Sslash", FileGraphMaker.toFilename("with/slash"));
        TestFileGraphMaker.assertEquals("with_Ccolon", FileGraphMaker.toFilename("with:colon"));
        TestFileGraphMaker.assertEquals("with_Uunderbar", FileGraphMaker.toFilename("with_underbar"));
        TestFileGraphMaker.assertEquals("with_Stwo_Sslashes", FileGraphMaker.toFilename("with/two/slashes"));
        TestFileGraphMaker.assertEquals("with_Sa_Cmixture_U...", FileGraphMaker.toFilename("with/a:mixture_..."));
    }

    public void testToGraphname() {
        TestFileGraphMaker.assertEquals("plain", FileGraphMaker.toGraphname("plain"));
        TestFileGraphMaker.assertEquals("with/slash", FileGraphMaker.toGraphname("with_Sslash"));
        TestFileGraphMaker.assertEquals("with:colon", FileGraphMaker.toGraphname("with_Ccolon"));
        TestFileGraphMaker.assertEquals("with_underbar", FileGraphMaker.toGraphname("with_Uunderbar"));
        TestFileGraphMaker.assertEquals("a/mixture_of:things", FileGraphMaker.toGraphname("a_Smixture_Uof_Cthings"));
        TestFileGraphMaker.assertEquals("with/two/slashes", FileGraphMaker.toGraphname("with_Stwo_Sslashes"));
    }

    public void testDetectsExistingFiles() {
        File file = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-already");
        Graph graph = TestFileGraphMaker.graphWith("something hasProperty someValue");
        FileGraphMaker fileGraphMaker = new FileGraphMaker(file.getPath());
        FileGraphMaker fileGraphMaker2 = new FileGraphMaker(file.getPath());
        FileGraph fileGraph = (FileGraph)fileGraphMaker.createGraph("already", true);
        fileGraph.getBulkUpdateHandler().add(graph);
        fileGraph.close();
        FileGraph fileGraph2 = (FileGraph)fileGraphMaker2.openGraph("already", false);
        TestFileGraphMaker.assertIsomorphic(graph, fileGraph2);
        fileGraph2.close();
        fileGraph2.delete();
        fileGraph.delete();
    }
}

