/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestGraphExtract
extends GraphTestBase {
    public TestGraphExtract(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphExtract.class);
    }

    public void testExtractNothing() {
        this.testExtract("", "x", "");
        this.testExtract("", "x", "a R b");
        this.testExtract("", "x", "a R x");
        this.testExtract("", "x", "a x y");
    }

    public void testExtractOneLevel() {
        this.testExtract("a R b", "a", "a R b");
        this.testExtract("a R b; a R c", "a", "a R b; a R c");
        this.testExtract("a R b; a S d", "a", "a R b; a S d");
    }

    public void testNoJunk() {
        this.testExtract("a R b", "a", "a R b; x R y");
    }

    public void testExtractTwoLevels() {
        this.testExtract("a R b; b S c", "a", "a R b; b S c");
        this.testExtract("a R b; b S c", "a", "a R b; b S c; x P y");
        this.testExtract("a R b; b S c; b T d", "a", "a R b; b S c; b T d");
        this.testExtract("a R b; b S c; a T d", "a", "a R b; a T d; b S c");
    }

    public void testExtractSeveralLevels() {
        this.testExtract("a R b; b S c; c T d; d U e", "a", "a R b; b S c; c T d; d U e");
    }

    public void testExtractNoLoop() {
        this.testExtract("a R a", "a", "a R a");
        this.testExtract("a R b; b R a", "a", "a R b; b R a; z P a");
        this.testExtract("a R b; b S c; c T a", "a", "a R b; b S c; c T a; junk P junk");
    }

    public void testTripleFilter() {
        TestGraphExtract.assertTrue(TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a R _b")));
        TestGraphExtract.assertFalse(TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a R b")));
        TestGraphExtract.assertFalse(TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("a _R b")));
        TestGraphExtract.assertFalse(TripleBoundary.stopAtAnonObject.stopAt(TestGraphExtract.triple("_a R b")));
    }

    public void testExtractBoundary() {
        this.testExtract("a R b; b S _c", "a", "a R b; b S _c; _c T d", TripleBoundary.stopAtAnonObject);
    }

    public void testPartialUpdate() {
        Graph graph = TestGraphExtract.graphWith("a R b; b S e");
        Graph graph2 = TestGraphExtract.graphWith("b R d");
        GraphExtract graphExtract = new GraphExtract(TripleBoundary.stopNowhere);
        graphExtract.extractInto(graph2, TestGraphExtract.node("a"), graph);
        TestGraphExtract.assertIsomorphic(TestGraphExtract.graphWith("a R b; b S e; b R d"), graph2);
    }

    public void testExtract(String string, String string2, String string3) {
        this.testExtract(string, string2, string3, TripleBoundary.stopNowhere);
    }

    private void testExtract(String string, String string2, String string3, TripleBoundary tripleBoundary) {
        TestGraphExtract.assertIsomorphic(TestGraphExtract.graphWith(string), this.extract(TestGraphExtract.node(string2), tripleBoundary, TestGraphExtract.graphWith(string3)));
    }

    public Graph extract(Node node, TripleBoundary tripleBoundary, Graph graph) {
        return new GraphExtract(tripleBoundary).extract(node, graph);
    }
}

