/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestNode
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);
    private static final AnonId A = new AnonId();
    static String[] someURIs = new String[]{"http://domainy.thing/stuff/henry", "http://whatever.com/stingy-beast/bee", "ftp://erewhon/12345", "potatoe:rhubarb"};
    protected static String[] someNodes = new String[]{"42", "'hello'", "_anon", "'robotic'tick", "'teriffic'abc:def"};

    public TestNode(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNode.class);
    }

    public void testBlanks() {
        TestNode.assertTrue("anonymous nodes are blank", Node.createAnon().isBlank());
        TestNode.assertFalse("anonymous nodes aren't literal", Node.createAnon().isLiteral());
        TestNode.assertFalse("anonymous nodes aren't URIs", Node.createAnon().isURI());
        TestNode.assertFalse("anonymous nodes aren't variables", Node.createAnon().isVariable());
        TestNode.assertEquals("anonymous nodes have the right id", Node.createAnon(A).getBlankNodeId(), A);
    }

    public void testLiterals() {
        TestNode.assertFalse("literal nodes aren't blank", Node.createLiteral(L).isBlank());
        TestNode.assertTrue("literal nodes are literal", Node.createLiteral(L).isLiteral());
        TestNode.assertFalse("literal nodes aren't variables", Node.createLiteral(L).isVariable());
        TestNode.assertFalse("literal nodes aren't URIs", Node.createLiteral(L).isURI());
        TestNode.assertEquals("literal nodes preserve value", Node.createLiteral(L).getLiteral(), L);
    }

    public void testURIs() {
        TestNode.assertFalse("URI nodes aren't blank", Node.createURI(U).isBlank());
        TestNode.assertFalse("URI nodes aren't literal", Node.createURI(U).isLiteral());
        TestNode.assertFalse("URI nodes aren't variables", Node.createURI(U).isVariable());
        TestNode.assertTrue("URI nodes are URIs", Node.createURI(U).isURI());
        TestNode.assertEquals("URI nodes preserve URI", Node.createURI(U).getURI(), U);
    }

    public void testVariables() {
        TestNode.assertFalse("variable nodes aren't blank", Node.createVariable(N).isBlank());
        TestNode.assertFalse("variable nodes aren't literal", Node.createVariable(N).isLiteral());
        TestNode.assertFalse("variable nodes aren't URIs", Node.createVariable(N).isURI());
        TestNode.assertTrue("variable nodes are variable", Node.createVariable(N).isVariable());
        TestNode.assertEquals("variable nodes keep their name", N, Node.createVariable(N).getName());
        TestNode.assertEquals("variable nodes keep their name", "Alicex", Node.createVariable("Alicex").getName());
    }

    public void testANY() {
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        TestNode.assertFalse("ANY nodes aren't literals", Node.ANY.isLiteral());
        TestNode.assertFalse("ANY nodes aren't URIs", Node.ANY.isURI());
        TestNode.assertFalse("ANY nodes aren't variables", Node.ANY.isVariable());
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] eqTestCases() {
        try {
            Node.cache(false);
            AnonId anonId = new AnonId();
            LiteralLabel literalLabel = new LiteralLabel(anonId.toString(), "", false);
            String string = anonId.toString();
            String string2 = anonId.toString();
            Object[][] objectArray = new Object[][]{{Node.ANY, "0"}, {Node.createAnon(anonId), "1"}, {Node.createAnon(), "2"}, {Node.createAnon(anonId), "1"}, {Node.createLiteral(L), "3"}, {Node.createLiteral(literalLabel), "4"}, {Node.createLiteral(L), "3"}, {Node.createURI(U), "5"}, {Node.createURI(string), "6"}, {Node.createURI(U), "5"}, {Node.createVariable(N), "7"}, {Node.createVariable(string2), "8"}, {Node.createVariable(N), "7"}};
            return objectArray;
        }
        finally {
            Node.cache(true);
        }
    }

    public void testNodeEquals() {
        Object[][] objectArray = this.eqTestCases();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = objectArray[i];
            TestNode.assertFalse(objectArray2[0] + " should not equal null", objectArray2[0].equals(null));
            TestNode.assertFalse(objectArray2[0] + "should not equal 'String'", objectArray2[0].equals("String"));
            for (int j = 0; j < objectArray.length; ++j) {
                Object[] objectArray3 = objectArray[j];
                this.testEquality(objectArray2[1].equals(objectArray3[1]), objectArray2[0], objectArray3[0]);
            }
        }
    }

    private void testEquality(boolean bl, Object object, Object object2) {
        String string = this.getType(object) + " " + object + " and " + this.getType(object2) + " " + object2;
        if (bl) {
            TestNode.assertEquals(string + "should be equal", object, object2);
        } else {
            TestNode.assertDiffer(string + " should differ", object, object2);
        }
    }

    private String getType(Object object) {
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquals() {
        try {
            Node.cache(false);
            TestNode.assertDiffer("different variables", Node.createVariable("xx"), Node.createVariable("yy"));
            TestNode.assertEquals("same vars", Node.createVariable("aa"), Node.createVariable("aa"));
            TestNode.assertEquals("same URI", Node.createURI(U), Node.createURI(U));
            TestNode.assertEquals("same anon", Node.createAnon(A), Node.createAnon(A));
            TestNode.assertEquals("same literal", Node.createLiteral(L), Node.createLiteral(L));
            TestNode.assertFalse("distinct URIs", Node.createURI(U) == Node.createURI(U));
            TestNode.assertFalse("distinct blanks", Node.createAnon(A) == Node.createAnon(A));
            TestNode.assertFalse("distinct literals", Node.createLiteral(L) == Node.createLiteral(L));
            TestNode.assertFalse("distinct vars", Node.createVariable("aa") == Node.createVariable("aa"));
        }
        finally {
            Node.cache(true);
        }
    }

    public void testLabels() {
        AnonId anonId = new AnonId();
        TestNode.assertEquals("get URI value", U, Node.createURI(U).getURI());
        TestNode.assertEquals("get blank value", anonId, Node.createAnon(anonId).getBlankNodeId());
        TestNode.assertEquals("get literal value", L, Node.createLiteral(L).getLiteral());
        TestNode.assertEquals("get variable name", N, Node.createVariable(N).getName());
    }

    public void testFailingLabels() {
        Node node = Node.createURI(U);
        Node node2 = Node.createAnon();
        Node node3 = Node.createLiteral(L);
        Node node4 = Node.createVariable(N);
        Node node5 = Node.ANY;
        this.testGetURIFails(node5);
        this.testGetURIFails(node2);
        this.testGetURIFails(node3);
        this.testGetURIFails(node4);
        this.testGetLiteralFails(node5);
        this.testGetLiteralFails(node);
        this.testGetLiteralFails(node2);
        this.testGetLiteralFails(node4);
        this.testGetNameFails(node5);
        this.testGetNameFails(node);
        this.testGetNameFails(node2);
        this.testGetNameFails(node3);
        this.testGetBlankNodeIdFails(node5);
        this.testGetBlankNodeIdFails(node);
        this.testGetBlankNodeIdFails(node3);
        this.testGetBlankNodeIdFails(node4);
    }

    public void testGetBlankNodeIdFails(Node node) {
        try {
            node.getBlankNodeId();
            TestNode.fail(node.getClass() + " should fail getName()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetURIFails(Node node) {
        try {
            node.getURI();
            TestNode.fail(node.getClass() + " should fail getURI()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetNameFails(Node node) {
        try {
            node.getName();
            TestNode.fail(node.getClass() + " should fail getName()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetLiteralFails(Node node) {
        try {
            node.getLiteral();
            TestNode.fail(node.getClass() + " should fail getLiteral()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testVariableSupport() {
        TestNode.assertEquals(Node_Variable.variable("xxx"), Node_Variable.variable("xxx"));
        TestNode.assertDiffer(Node_Variable.variable("xxx"), Node_Variable.variable("yyy"));
        TestNode.assertEquals(Node_Variable.variable("aaa"), Node_Variable.variable("aaa"));
        TestNode.assertDiffer(Node_Variable.variable("aaa"), Node_Variable.variable("yyy"));
    }

    public void testCache() {
        TestNode.assertEquals(Node_Variable.variable("xxx"), Node_Variable.variable("xxx"));
        TestNode.assertTrue("remembers URI", Node.createURI(U) == Node.createURI(U));
        TestNode.assertTrue("remembers literal", Node.createLiteral(L) == Node.createLiteral(L));
        TestNode.assertTrue("remembers blanks", Node.createAnon(A) == Node.createAnon(A));
        TestNode.assertTrue("remembers variables", Node.createVariable(N) == Node.createVariable(N));
        TestNode.assertFalse("is not confused", Node.createVariable(N) == Node.createURI(N));
    }

    public void testCreateBadString() {
        try {
            Node.create(null);
            TestNode.fail("must catch null argument");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
        try {
            Node.create("");
            TestNode.fail("must catch empty argument");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testCreateAnon() {
        String string = "_xxx";
        String string2 = "_yyy";
        Node node = Node.create(string);
        Node node2 = Node.create(string2);
        TestNode.assertTrue("both must be bnodes", node.isBlank() && node2.isBlank());
        TestNode.assertEquals(new AnonId(string), node.getBlankNodeId());
        TestNode.assertEquals(new AnonId(string2), node2.getBlankNodeId());
    }

    public void testCreateVariable() {
        String string = "wobbly";
        Node node = Node.create("?" + string);
        TestNode.assertTrue("must be a variable", node.isVariable());
        TestNode.assertEquals("name must be correct", string, node.getName());
    }

    public void testCreateANY() {
        TestNode.assertEquals("?? must denote ANY", Node.ANY, Node.create("??"));
    }

    public void testCreatePlainLiteralSIngleQuotes() {
        Node node = Node.create("'xxx'");
        TestNode.assertEquals("xxx", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("", node.getLiteral().language());
        TestNode.assertEquals(null, node.getLiteral().getDatatypeURI());
    }

    public void testCreatePlainLiteralDoubleQuotes() {
        Node node = Node.create("\"xxx\"");
        TestNode.assertEquals("xxx", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("", node.getLiteral().language());
        TestNode.assertEquals(null, node.getLiteral().getDatatypeURI());
    }

    public void testCreateLiteralBackslashEscape() {
        this.testStringConversion("xx\\x", "'xx\\\\x'");
        this.testStringConversion("xx\\x\\y", "'xx\\\\x\\\\y'");
        this.testStringConversion("\\xyz\\", "'\\\\xyz\\\\'");
    }

    public void testCreateLiteralQuoteEscapes() {
        this.testStringConversion("x'y", "'x\\'y'");
        this.testStringConversion("x\"y", "'x\\\"y'");
        this.testStringConversion("x'y\"z", "'x\\'y\\\"z'");
    }

    public void testCreateLiteralOtherEscapes() {
        this.testStringConversion(" ", "'\\s'");
        this.testStringConversion("\t", "'\\t'");
        this.testStringConversion("\n", "'\\n'");
    }

    protected void testStringConversion(String string, String string2) {
        Node node = Node.create(string2);
        TestNode.assertEquals(string, node.getLiteral().getLexicalForm());
        TestNode.assertEquals("", node.getLiteral().language());
        TestNode.assertEquals(null, node.getLiteral().getDatatypeURI());
    }

    public void testCreateLanguagedLiteralEN() {
        Node node = Node.create("'chat'en-UK");
        TestNode.assertEquals("chat", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("en-UK", node.getLiteral().language());
        TestNode.assertEquals(null, node.getLiteral().getDatatypeURI());
    }

    public void testCreateLanguagedLiteralXY() {
        Node node = Node.create("\"chat\"xy-AB");
        TestNode.assertEquals("chat", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("xy-AB", node.getLiteral().language());
        TestNode.assertEquals(null, node.getLiteral().getDatatypeURI());
    }

    public void testCreateTypedLiteralInteger() {
        Node node = Node.create("'42'xsd:integer");
        TestNode.assertEquals("42", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("", node.getLiteral().language());
        TestNode.assertEquals(this.expand("xsd:integer"), node.getLiteral().getDatatypeURI());
    }

    public void testCreateTypedLiteralBoolean() {
        Node node = Node.create("\"true\"xsd:boolean");
        TestNode.assertEquals("true", node.getLiteral().getLexicalForm());
        TestNode.assertEquals("", node.getLiteral().language());
        TestNode.assertEquals(this.expand("xsd:boolean"), node.getLiteral().getDatatypeURI());
    }

    public void testTypesExpandPrefix() {
        this.testTypeExpandsPrefix("rdf:spoo");
        this.testTypeExpandsPrefix("rdfs:bar");
        this.testTypeExpandsPrefix("owl:henry");
        this.testTypeExpandsPrefix("xsd:bool");
        this.testTypeExpandsPrefix("unknown:spoo");
    }

    private void testTypeExpandsPrefix(String string) {
        Node node = Node.create("'stuff'" + string);
        String string2 = PrefixMapping.Extended.expandPrefix(string);
        TestNode.assertEquals(string2, node.getLiteral().getDatatypeURI());
    }

    public void testCreateURI() {
        String string = "http://www.electric-hedgehog.net/";
        this.testCreateURI(string);
        this.testCreateURI("rdf:trinket", "http://www.w3.org/1999/02/22-rdf-syntax-ns#trinket");
        this.testCreateURI("rdfs:device", "http://www.w3.org/2000/01/rdf-schema#device");
        this.testCreateURI("dc:creator", DC.getURI() + "creator");
        this.testCreateURI("rss:something", RSS.getURI() + "something");
        this.testCreateURI("vcard:TITLE", VCARD.getURI() + "TITLE");
        this.testCreateURI("owl:wol", OWL.NAMESPACE + "wol");
    }

    public void testCreateURIOtherMap() {
        String string = "eh:foo/bar#";
        String string2 = "something";
        PrefixMapping prefixMapping = PrefixMapping.Factory.create().setNsPrefix("mine", string);
        Node node = Node.create(prefixMapping, "mine:" + string2);
        TestNode.assertEquals(string + string2, node.getURI());
    }

    private void testCreateURI(String string) {
        this.testCreateURI(string, string);
    }

    private void testCreateURI(String string, String string2) {
        String string3 = Node.create(string).getURI();
        if (!string2.equals(string3)) {
            if (string.equals(string2)) {
                TestNode.fail("should preserve " + string);
            } else {
                TestNode.fail("should translate " + string + " to " + string2 + " not " + string3);
            }
        }
    }

    public void testCreatePrefixed() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        Node.create(prefixMapping, "xyz");
    }

    public void testToStringWithPrefixMapping() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        String string = "spoo";
        String string2 = "abc:def/ghi#";
        prefixMapping.setNsPrefix(string, string2);
        String string3 = "bamboozle";
        TestNode.assertEquals(string + ":" + string3, Node.create(string2 + string3).toString(prefixMapping));
    }

    public void testNodeHelp() {
        TestNode.assertTrue("node() making URIs", TestNode.node("hello").isURI());
        TestNode.assertTrue("node() making literals", TestNode.node("123").isLiteral());
        TestNode.assertTrue("node() making literals", TestNode.node("'hello'").isLiteral());
        TestNode.assertTrue("node() making blanks", TestNode.node("_x").isBlank());
        TestNode.assertTrue("node() making variables", TestNode.node("?x").isVariable());
    }

    public void testVisitorPatternNode() {
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                return node_ANY;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                return node_Blank;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                return node_Literal;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                return node_URI;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                return node_Variable;
            }
        };
        this.testVisitorPatternNode("sortOfURI", nodeVisitor);
        this.testVisitorPatternNode("?variable", nodeVisitor);
        this.testVisitorPatternNode("_anon", nodeVisitor);
        this.testVisitorPatternNode("11", nodeVisitor);
        this.testVisitorPatternNode("??", nodeVisitor);
    }

    private void testVisitorPatternNode(String string, NodeVisitor nodeVisitor) {
        Node node = TestNode.node(string);
        TestNode.assertEquals(node, node.visitWith(nodeVisitor));
    }

    private void visitExamples(NodeVisitor nodeVisitor) {
        TestNode.node("sortOfURI").visitWith(nodeVisitor);
        TestNode.node("?variableI").visitWith(nodeVisitor);
        TestNode.node("_anon").visitWith(nodeVisitor);
        TestNode.node("11").visitWith(nodeVisitor);
        TestNode.node("??").visitWith(nodeVisitor);
    }

    public void testVisitorPatternValue() {
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                return null;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                Assert.assertTrue(node_Blank.getBlankNodeId() == anonId);
                return null;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                Assert.assertTrue(node_Literal.getLiteral() == literalLabel);
                return null;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                Assert.assertTrue(node_URI.getURI() == string);
                return null;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                Assert.assertEquals(node_Variable.getName(), string);
                return null;
            }
        };
        this.visitExamples(nodeVisitor);
    }

    public void testVisitorPatternCalled() {
        final String[] stringArray = new String[]{""};
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                stringArray[0] = stringArray[0] + " any";
                return null;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                stringArray[0] = stringArray[0] + " blank";
                return null;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                stringArray[0] = stringArray[0] + " literal";
                return null;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                stringArray[0] = stringArray[0] + " uri";
                return null;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                stringArray[0] = stringArray[0] + " variable";
                return null;
            }
        };
        String string = " uri variable blank literal any";
        this.visitExamples(nodeVisitor);
        TestNode.assertEquals("all vists must have been made", string, stringArray[0]);
    }

    public void testSimpleMatches() {
        TestNode.assertTrue(Node.create("S").matches(Node.create("S")));
        TestNode.assertFalse("", Node.create("S").matches(Node.create("T")));
        TestNode.assertFalse("", Node.create("S").matches(null));
        TestNode.assertTrue(Node.create("_X").matches(Node.create("_X")));
        TestNode.assertFalse("", Node.create("_X").matches(Node.create("_Y")));
        TestNode.assertFalse("", Node.create("_X").matches(null));
        TestNode.assertTrue(Node.create("10").matches(Node.create("10")));
        TestNode.assertFalse("", Node.create("10").matches(Node.create("11")));
        TestNode.assertFalse("", Node.create("10").matches(null));
        TestNode.assertTrue(Node.ANY.matches(Node.create("S")));
        TestNode.assertTrue(Node.ANY.matches(Node.create("_X")));
        TestNode.assertTrue(Node.ANY.matches(Node.create("10")));
        TestNode.assertFalse("", Node.ANY.matches(null));
    }

    public void testDataMatches() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getTypeByValue(new Integer(10));
        RDFDatatype rDFDatatype2 = typeMapper.getTypeByValue(new Short(10));
        Node node = Node.createLiteral("10", "", rDFDatatype);
        Node node2 = Node.createLiteral("10", "", rDFDatatype2);
        TestNode.assertDiffer("types must make a difference", node, node2);
        TestNode.assertTrue("A and B must express the same value", node.sameValueAs(node2));
        TestNode.assertTrue("matching literals must respect sameValueAs", node.matches(node2));
    }

    public void testLiteralToString() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getTypeByValue(new Integer(10));
        Node node = Node.createLiteral("rhubarb", "", false);
        Node node2 = Node.createLiteral("eccentric", "en_UK", false);
        Node node3 = Node.createLiteral("10", "", rDFDatatype);
        TestNode.assertEquals("\"rhubarb\"", node.toString());
        TestNode.assertEquals("rhubarb", node.toString(false));
        TestNode.assertEquals("\"eccentric\"@en_UK", node2.toString());
        TestNode.assertEquals("10^^http://www.w3.org/2001/XMLSchema#int", node3.toString(false));
    }

    public void testConcrete() {
        TestNode.assertTrue(Node.create("S").isConcrete());
        TestNode.assertTrue(Node.create("_P").isConcrete());
        TestNode.assertTrue(Node.create("11").isConcrete());
        TestNode.assertTrue(Node.create("'hello'").isConcrete());
        TestNode.assertFalse(Node.create("??").isConcrete());
        TestNode.assertFalse(Node.create("?x").isConcrete());
    }

    public void testNamespace() {
        for (int i = 0; i < someURIs.length; ++i) {
            String string = someURIs[i];
            int n = Util.splitNamespace(string);
            Node node = Node.create(string);
            TestNode.assertEquals("check namespace", string.substring(0, n), node.getNameSpace());
            TestNode.assertEquals("check localname", string.substring(n), node.getLocalName());
        }
    }

    public void testHasURI() {
        int n;
        for (n = 0; n < someURIs.length; ++n) {
            this.testHasURI(someURIs[n]);
        }
        for (n = 0; n < someNodes.length; ++n) {
            this.testHasURI(someNodes[n]);
        }
    }

    private void testHasURI(String string) {
        Node node = Node.create(string);
        TestNode.assertTrue(string, !node.isURI() || node.hasURI(string));
        TestNode.assertFalse(string, node.hasURI(string + "x"));
    }

    private String expand(String string) {
        return PrefixMapping.Extended.expandPrefix(string);
    }
}

