/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeCache;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestNodeCache
extends GraphTestBase {
    protected static String[] someURIs = TestNodeCache.inventURIs();

    public TestNodeCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNodeCache.class);
    }

    public static void main(String[] stringArray) {
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String[] stringArray2 = new String[32000];
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 0; j < string.length(); ++j) {
                int n;
                String string2 = "" + string.charAt(i) + string.charAt(j);
                if (i == 10 && j == 10) {
                    System.err.println(string2);
                }
                if (stringArray2[n = string2.hashCode()] == null) {
                    stringArray2[n] = string2;
                    continue;
                }
                System.out.println(">> " + stringArray2[n] + " and " + string2 + " both hash to " + n);
            }
        }
    }

    public void testClashettes() {
        TestNodeCache.assertEquals("eg:aa".hashCode(), "eg:bB".hashCode());
        TestNodeCache.assertEquals("eg:ab".hashCode(), "eg:bC".hashCode());
        TestNodeCache.assertEquals("eg:ac".hashCode(), "eg:bD".hashCode());
        TestNodeCache.assertEquals("eg:Yv".hashCode(), "eg:ZW".hashCode());
        TestNodeCache.assertEquals("eg:Yx".hashCode(), "eg:ZY".hashCode());
    }

    protected static String[] inventURIs() {
        String[] stringArray = new String[]{"a", "mig", "spoo-", "gilbert", "124c41+"};
        String[] stringArray2 = new String[]{"b", "class", "procedure", "spindizzy", "rake"};
        String[] stringArray3 = new String[]{"c", "bucket", "42", "+1", "#mark"};
        int n = 0;
        String[] stringArray4 = new String[stringArray.length * stringArray2.length * stringArray3.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                for (int k = 0; k < stringArray3.length; ++k) {
                    stringArray4[n++] = "eg:" + stringArray[i] + stringArray2[j] + stringArray3[k];
                }
            }
        }
        return stringArray4;
    }

    public void testNewCacheEmpty() {
        NodeCache nodeCache = new NodeCache();
        for (int i = 0; i < someURIs.length; ++i) {
            TestNodeCache.assertEquals(null, nodeCache.get(someURIs[i]));
        }
    }

    public void testNewCacheUpdates() {
        NodeCache nodeCache = new NodeCache();
        for (int i = 0; i < someURIs.length; ++i) {
            Node node = Node.createURI(someURIs[i]);
            nodeCache.put(someURIs[i], node);
            TestNodeCache.assertEquals(node, nodeCache.get(someURIs[i]));
        }
    }

    public void testClashing() {
        String string = "eg:aa";
        String string2 = "eg:bB";
        TestNodeCache.assertEquals(string.hashCode(), string2.hashCode());
        NodeCache nodeCache = new NodeCache();
        nodeCache.put(string, Node.createURI(string));
        TestNodeCache.assertEquals(null, nodeCache.get(string2));
        nodeCache.put(string2, Node.createURI(string2));
        TestNodeCache.assertEquals(Node.createURI(string2), nodeCache.get(string2));
    }
}

