/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.NodeToTriplesMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

public class TestNodeToTriplesMap
extends GraphTestBase {
    protected NodeToTriplesMap ntS = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getSubject();
        }
    };
    protected NodeToTriplesMap ntP = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getPredicate();
        }
    };
    protected NodeToTriplesMap ntO = new NodeToTriplesMap(){

        public Node getIndexNode(Triple triple) {
            return triple.getObject();
        }
    };
    protected static final Node x = TestNodeToTriplesMap.node("x");
    protected static final Node y = TestNodeToTriplesMap.node("y");

    public TestNodeToTriplesMap(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNodeToTriplesMap.class);
    }

    public void testZeroSize() {
        this.testZeroSize("fresh NTM", this.ntS);
    }

    protected void testZeroSize(String string, NodeToTriplesMap nodeToTriplesMap) {
        TestNodeToTriplesMap.assertEquals(string + " should have size 0", 0, nodeToTriplesMap.size());
        TestNodeToTriplesMap.assertEquals(string + " should be isEmpty()", true, nodeToTriplesMap.isEmpty());
        TestNodeToTriplesMap.assertEquals(string + " should have empty domain", false, nodeToTriplesMap.domain().hasNext());
    }

    public void testAddOne() {
        this.ntS.add(x, TestNodeToTriplesMap.triple("x P y"));
        this.testJustOne(x, this.ntS);
    }

    public void testAddOneTwice() {
        this.addTriples(this.ntS, "x P y; x P y");
        this.testJustOne(x, this.ntS);
    }

    protected void testJustOne(Node node, NodeToTriplesMap nodeToTriplesMap) {
        TestNodeToTriplesMap.assertEquals(1, nodeToTriplesMap.size());
        TestNodeToTriplesMap.assertEquals(false, nodeToTriplesMap.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(node), TestNodeToTriplesMap.iteratorToSet(nodeToTriplesMap.domain()));
    }

    public void testAddTwoUnshared() {
        this.addTriples(this.ntS, "x P a; y Q b");
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(false, this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.both(x, y), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testAddTwoShared() {
        this.addTriples(this.ntS, "x P a; x Q b");
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(false, this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(x), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testClear() {
        this.addTriples(this.ntS, "x P a; x Q b; y R z");
        this.ntS.clear();
        this.testZeroSize("cleared NTM", this.ntS);
    }

    public void testAllIterator() {
        String string = "x P b; y P d; y P f";
        this.addTriples(this.ntS, string);
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(string), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator()));
    }

    public void testOneIterator() {
        this.addTriples(this.ntS, "x P b; y P d; y P f");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(x)));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P d; y P f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(y)));
    }

    public void testRemove() {
        this.addTriples(this.ntS, "x P b; y P d; y R f");
        this.ntS.remove(y, TestNodeToTriplesMap.triple("y P d"));
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b; y R f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator()));
    }

    public void testRemoveByIterator() {
        this.addTriples(this.ntS, "x nice a; a nasty b; x nice c");
        this.addTriples(this.ntS, "y nice d; y nasty e; y nice f");
        ExtendedIterator extendedIterator = this.ntS.iterator();
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            if (!triple.getPredicate().equals(TestNodeToTriplesMap.node("nasty"))) continue;
            extendedIterator.remove();
        }
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x nice a; x nice c; y nice d; y nice f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator()));
    }

    public void testIteratorWIthPatternOnEmpty() {
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(""), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(TestNodeToTriplesMap.triple("a P b"))));
    }

    public void testIteratorWIthPatternOnSomething() {
        this.addTriples(this.ntS, "x P a; y P b; y R c");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(TestNodeToTriplesMap.triple("x P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P b; y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(TestNodeToTriplesMap.triple("y ?? ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y P b"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(TestNodeToTriplesMap.triple("?? P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(TestNodeToTriplesMap.triple("?? ?? c"))));
    }

    public void testSpecificIteratorWithPatternOnEmpty() {
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(""), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(x, TestNodeToTriplesMap.triple("x P b"))));
    }

    public void testSpecificIteratorWithPatternOnSomething() {
        this.addTriples(this.ntS, "x P a; y P b; y R c");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(x, TestNodeToTriplesMap.triple("x P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P b; y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(y, TestNodeToTriplesMap.triple("y ?? ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(x, TestNodeToTriplesMap.triple("?? P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(y, TestNodeToTriplesMap.triple("?? ?? c"))));
    }

    public void testUnspecificRemoveS() {
        this.addTriples(this.ntS, "x P a; y Q b; z R c");
        this.ntS.remove(TestNodeToTriplesMap.triple("x P a"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y Q b; z R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator()));
    }

    public void testUnspecificRemoveP() {
        this.addTriples(this.ntP, "x P a; y Q b; z R c");
        this.ntP.remove(TestNodeToTriplesMap.triple("y Q b"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; z R c"), TestNodeToTriplesMap.iteratorToSet(this.ntP.iterator()));
    }

    public void testUnspecificRemoveO() {
        this.addTriples(this.ntO, "x P a; y Q b; z R c");
        this.ntO.remove(TestNodeToTriplesMap.triple("z R c"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y Q b"), TestNodeToTriplesMap.iteratorToSet(this.ntO.iterator()));
    }

    public void testAddBooleanResult() {
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(x, TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(x, TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(y, TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(y, TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(y, TestNodeToTriplesMap.triple("y R s")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(y, TestNodeToTriplesMap.triple("y R s")));
    }

    public void testRemoveBooleanResult() {
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        this.ntS.add(x, TestNodeToTriplesMap.triple("x P y"));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x Q y")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
    }

    public void testContains() {
        this.addTriples(this.ntS, "x P y; a P b");
        TestNodeToTriplesMap.assertTrue(this.ntS.contains(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertTrue(this.ntS.contains(TestNodeToTriplesMap.triple("a P b")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("x P z")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("y P y")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("x R y")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("e T f")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("_x F 17")));
    }

    protected void addTriples(NodeToTriplesMap nodeToTriplesMap, String string) {
        Triple[] tripleArray = TestNodeToTriplesMap.tripleArray(string);
        for (int i = 0; i < tripleArray.length; ++i) {
            nodeToTriplesMap.add(nodeToTriplesMap.getIndexNode(tripleArray[i]), tripleArray[i]);
        }
    }

    protected static Set just(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        return hashSet;
    }

    protected static Set both(Object object, Object object2) {
        Set set = TestNodeToTriplesMap.just(object);
        set.add(object2);
        return set;
    }
}

