/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierTripleMap;
import com.hp.hpl.jena.graph.test.AbstractTestReifier;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import junit.framework.TestSuite;

public class TestReifier
extends AbstractTestReifier {
    protected final Class graphClass;
    protected final ReificationStyle style;

    public TestReifier(String string) {
        super(string);
        this.graphClass = null;
        this.style = null;
    }

    public TestReifier(Class clazz, String string, ReificationStyle reificationStyle) {
        super(string);
        this.graphClass = clazz;
        this.style = reificationStyle;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(MetaTestGraph.suite(TestReifier.class, GraphMem.class));
        return testSuite;
    }

    public Graph getGraph(ReificationStyle reificationStyle) {
        try {
            Constructor constructor = TestReifier.getConstructor(this.graphClass, new Class[]{ReificationStyle.class});
            if (constructor != null) {
                return (Graph)constructor.newInstance(reificationStyle);
            }
            Constructor constructor2 = TestReifier.getConstructor(this.graphClass, new Class[]{this.getClass(), ReificationStyle.class});
            if (constructor2 != null) {
                return (Graph)constructor2.newInstance(this, reificationStyle);
            }
            throw new JenaException("no suitable graph constructor found for " + this.graphClass);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public void testExtendedConstructorExists() {
        GraphBase graphBase = new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return null;
            }
        };
        SimpleReifierTripleMap simpleReifierTripleMap = new SimpleReifierTripleMap();
        SimpleReifierFragmentsMap simpleReifierFragmentsMap = new SimpleReifierFragmentsMap();
        SimpleReifier simpleReifier = new SimpleReifier(graphBase, simpleReifierTripleMap, simpleReifierFragmentsMap, ReificationStyle.Minimal);
    }
}

