/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleCache;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestTripleCache
extends GraphTestBase {
    protected static Triple[] someTriples = TestTripleCache.makeTriples();

    public TestTripleCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTripleCache.class);
    }

    protected static Triple[] makeTriples() {
        Node[] nodeArray = new Node[]{TestTripleCache.node("x"), TestTripleCache.node("gooseberry"), TestTripleCache.node("_who")};
        Node[] nodeArray2 = new Node[]{TestTripleCache.node("p"), TestTripleCache.node("ramshackle"), TestTripleCache.node("_what")};
        Node[] nodeArray3 = new Node[]{TestTripleCache.node("o"), TestTripleCache.node("42"), TestTripleCache.node("'alpha'greek"), TestTripleCache.node("_o")};
        int n = 0;
        Triple[] tripleArray = new Triple[nodeArray.length * nodeArray2.length * nodeArray3.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            for (int j = 0; j < nodeArray2.length; ++j) {
                for (int k = 0; k < nodeArray3.length; ++k) {
                    tripleArray[n++] = new Triple(nodeArray[i], nodeArray2[j], nodeArray3[k]);
                }
            }
        }
        return tripleArray;
    }

    public void testEmptyTripleCache() {
        TripleCache tripleCache = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            Triple triple = someTriples[i];
            TestTripleCache.assertEquals(null, tripleCache.get(triple.getSubject(), triple.getPredicate(), triple.getObject()));
        }
    }

    public void testPutReturnsTriple() {
        TripleCache tripleCache = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            TestTripleCache.assertSame(someTriples[i], tripleCache.put(someTriples[i]));
        }
    }

    public void testPutinTripleCache() {
        TripleCache tripleCache = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            Triple triple = someTriples[i];
            tripleCache.put(triple);
            TestTripleCache.assertEquals(triple, tripleCache.get(triple.getSubject(), triple.getPredicate(), triple.getObject()));
        }
    }

    public void testCacheClash() {
        TripleCache tripleCache = new TripleCache();
        Triple triple = new Triple(TestTripleCache.node("eg:Yx"), TestTripleCache.node("p"), TestTripleCache.node("o"));
        Triple triple2 = new Triple(TestTripleCache.node("eg:ZY"), TestTripleCache.node("p"), TestTripleCache.node("o"));
        TestTripleCache.assertEquals(triple.hashCode(), triple2.hashCode());
        tripleCache.put(triple);
        TestTripleCache.assertEquals(null, tripleCache.get(triple2.getSubject(), triple2.getPredicate(), triple2.getObject()));
    }
}

