/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.NullN3EventHandler;
import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.shared.JenaException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import junit.framework.TestCase;

public class N3ExternalTests
extends N3ExternalTestsCom {
    public static boolean VERBOSE = false;

    public N3ExternalTests() {
        this("n3-parser-tests");
    }

    public N3ExternalTests(String string) {
        super("N3 Parser tests", string);
    }

    protected void makeTest(String string, String string2) {
        String string3 = string + "::" + string2;
        if (this.basedir != null) {
            string = this.basedir + "/" + string;
        }
        if (this.basedir != null && string2 != null && !string2.equals("")) {
            string2 = this.basedir + "/" + string2;
        }
        this.addTest(new Test(string3, string, this.basedir + "/" + string2));
    }

    static class Test
    extends TestCase {
        N3Parser parser = null;
        String n3File = null;
        String resultsFile = null;
        Reader rData = null;

        Test(String string, String string2, String string3) {
            super("N3 Parser test: " + string);
            this.n3File = string2;
            this.resultsFile = string3;
            try {
                this.rData = new FileReader(this.n3File);
                this.parser = new N3Parser(new BufferedReader(this.rData), (N3ParserEventHandler)new NullN3EventHandler());
            }
            catch (IOException iOException) {
                System.err.println("IO Exception: " + iOException);
            }
        }

        protected void runTest() throws Throwable {
            try {
                this.parser.parse();
                if (VERBOSE) {
                    PrintWriter printWriter = new PrintWriter(System.out);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.n3File));
                    printWriter.println("+++++++ " + this.getName());
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        printWriter.println(string);
                        string = bufferedReader.readLine();
                    }
                    printWriter.println("+++++++");
                    printWriter.flush();
                }
            }
            catch (Exception exception) {
                throw new JenaException(exception);
            }
        }
    }
}

