/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.LiteralAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.LinkedList;

public class DAMLCommonImpl
extends OntResourceImpl
implements DAMLCommon {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLCommonImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLCommon");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return node.isURI() || node.isBlank();
        }
    };
    private LiteralAccessor m_propLabel = new LiteralAccessorImpl(this.getVocabulary().label(), this);
    private LiteralAccessor m_propComment = new LiteralAccessorImpl(this.getVocabulary().comment(), this);
    private PropertyAccessor m_propEquivalentTo = null;
    private DAMLVocabulary m_vocabulary = null;
    private PropertyAccessor m_propType = null;

    public DAMLCommonImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public DAMLModel getDAMLModel() {
        return (DAMLModel)this.getModel();
    }

    public void setRDFType(Resource resource, boolean bl) {
        if (bl) {
            this.setRDFType(resource);
        } else {
            this.addRDFType(resource);
        }
    }

    public ExtendedIterator getRDFTypes(boolean bl) {
        return this.listRDFTypes(!bl);
    }

    public DAMLVocabulary getVocabulary() {
        if (this.m_vocabulary == null) {
            this.m_vocabulary = VocabularyManager.getVocabulary(this);
        }
        return this.m_vocabulary;
    }

    public ExtendedIterator getEquivalentValues() {
        LinkedList<DAMLCommonImpl> linkedList = new LinkedList<DAMLCommonImpl>();
        linkedList.add(this);
        return UniqueExtendedIterator.create(WrappedIterator.create(linkedList.iterator()).andThen(this.listPropertyValues(this.getProfile().SAME_AS())));
    }

    public ExtendedIterator getEquivalenceSet() {
        HashSet<DAMLCommonImpl> hashSet = new HashSet<DAMLCommonImpl>();
        hashSet.add(this);
        ExtendedIterator extendedIterator = this.getEquivalentValues();
        while (extendedIterator.hasNext()) {
            hashSet.add((DAMLCommonImpl)extendedIterator.next());
        }
        hashSet.remove(this);
        return WrappedIterator.create(hashSet.iterator());
    }

    public LiteralAccessor prop_label() {
        return this.m_propLabel;
    }

    public LiteralAccessor prop_comment() {
        return this.m_propComment;
    }

    public PropertyAccessor prop_equivalentTo() {
        if (this.m_propEquivalentTo == null) {
            this.m_propEquivalentTo = new PropertyAccessorImpl(this.getVocabulary().equivalentTo(), this);
        }
        return this.m_propEquivalentTo;
    }

    public PropertyAccessor prop_type() {
        if (this.m_propType == null) {
            this.m_propType = new PropertyAccessorImpl(RDF.type, this);
        }
        return this.m_propType;
    }
}

