/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DAMLTest
extends TestCase {
    private static Log log = LogFactory.getLog(DAMLTest.class);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;

    public DAMLTest(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void tearDown() {
    }

    public void testLoadOntology() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", dAMLModel.getLoadSuccessful());
        DAMLTest.assertEquals("Count of number of classes in daml store (2001/03, import)", 31, this.countClasses(dAMLModel));
        DAMLTest.assertEquals("Property count ", 68, this.countProperties(dAMLModel));
        dAMLModel = this.getCleanModel();
        dAMLModel.getLoader().setLoadImportedOntologies(false);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", dAMLModel.getLoadSuccessful());
        DAMLTest.assertEquals("Count of number of classes in daml store (2001/03, no import)", 16, this.countClasses(dAMLModel));
        dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/test-instance-load.daml");
        DAMLTest.assertTrue("Load status should be true", dAMLModel.getLoadSuccessful());
        Resource resource = dAMLModel.getResource("http://dickinson-i-4/daml/tests/test-instance-load.daml#pugh");
        DAMLTest.assertNotNull("Resource for officer Pugh should not be null", resource);
        DAMLInstance dAMLInstance = (DAMLInstance)resource.as(DAMLInstance.class);
        DAMLTest.assertNotNull(dAMLInstance);
        dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("Load success status should be true", dAMLModel.getLoadSuccessful());
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModel.getProperty("http://www.daml.org/2001/03/daml+oil-ex#shoesize").as(DAMLProperty.class);
        DAMLTest.assertNotNull("Failed to find shoesize property in example ontology", dAMLProperty);
        DAMLTest.assertEquals("shoesize should be a unique property", true, dAMLProperty.isUnique());
    }

    public void testRDFType() {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml");
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "fido");
        DAMLTest.assertNotNull("fido instance should not be null", dAMLInstance);
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Dog");
        DAMLTest.assertNotNull("Dog class should not be null", dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Vertebrate");
        DAMLTest.assertNotNull("Vertebrate class should not be null", dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Pet");
        DAMLTest.assertNotNull("Pet class should not be null", dAMLClass3);
        DAMLTest.assertTrue("fido should be member of class Dog", dAMLInstance.hasRDFType(dAMLClass));
        DAMLTest.assertTrue("fido should be member of class Vertebrate", dAMLInstance.hasRDFType(dAMLClass2));
        DAMLTest.assertTrue("fido should be member of class Vertebrate (by URL)", dAMLInstance.hasRDFType(string + "Vertebrate"));
        DAMLTest.assertTrue("fido should be member of class Pet", dAMLInstance.hasRDFType(dAMLClass3));
        DAMLTest.assertTrue("fido should not be a class", !dAMLInstance.hasRDFType(DAML_OIL.Class));
        DAMLTest.assertTrue("fido should be a companion", dAMLInstance.hasRDFType(string + "Companion"));
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "A");
        DAMLTest.assertNotNull("Class A should not be null", dAMLClass4);
        DAMLClass dAMLClass5 = dAMLModel.getDAMLClass(string + "B");
        DAMLTest.assertNotNull("Class B should not be null", dAMLClass5);
        DAMLInstance dAMLInstance2 = dAMLModel.getDAMLInstance(string + "ab");
        DAMLTest.assertNotNull("Instance ab should not be null", dAMLInstance2);
        DAMLTest.assertTrue("ab should be an A", dAMLInstance2.hasRDFType(dAMLClass4));
        DAMLTest.assertTrue("ab should be a B", dAMLInstance2.hasRDFType(dAMLClass5));
        DAMLTest.assertEquals("Number of classes fido belongs to (closure) should be 8", 8, this.countIteration(dAMLInstance.getRDFTypes(true), true, "fido member of class "));
        DAMLTest.assertEquals("Number of classes fido belongs to (non-closure) should be 3", 3, this.countIteration(dAMLInstance.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "queen-of");
        DAMLTest.assertNotNull("queen-of property should be defined", dAMLProperty);
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an ObjectProperty", dAMLProperty.hasRDFType(DAML_OIL.UnambiguousProperty));
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an ObjectProperty", dAMLProperty.hasRDFType(DAML_OIL.ObjectProperty));
        DAMLTest.assertTrue("an UnabmbiguousProperty should be an rdf:Property", dAMLProperty.hasRDFType(RDF.Property));
    }

    public void testClass() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull("Person class should not be null", dAMLClass);
        DAMLTest.assertTrue("Person should be a named class", dAMLClass.isNamedClass());
        int n = this.countIteration(dAMLClass.prop_subClassOf().getAll(), true, "super-class of Person (prop_subClassOf) ");
        int n2 = this.countIteration(dAMLClass.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        DAMLTest.assertEquals("person should have 10 super-classes (by prop_subClassOf)", 10, n);
        DAMLTest.assertEquals("person should have 9 super-classes (by getSuperClasses)", 9, n2);
        DAMLTest.assertEquals("person should have 3 sub-classes", 3, this.countIteration(dAMLClass.getSubClasses(), true, "Person super-class of: "));
        DAMLTest.assertTrue("Person should be a disjoint union", dAMLClass.isDisjointUnion());
        DAMLList dAMLList = dAMLClass.prop_disjointUnionOf().getList();
        DAMLTest.assertNotNull("Value of disjoint union should not be null", dAMLList);
        DAMLTest.assertEquals("Person should be a disjoint union of size 2", 2, dAMLList.getCount());
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Female");
        DAMLTest.assertNotNull("Class Female should not be null", dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Male");
        DAMLTest.assertNotNull("Class Male should not be null", dAMLClass3);
        DAMLTest.assertTrue("Female should be disjoint with male", dAMLClass2.prop_disjointWith().hasValue(dAMLClass3));
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "HumanBeing");
        DAMLTest.assertNotNull("Class humanBeing should not be null", dAMLClass4);
        DAMLTest.assertTrue("Person should be same class as HumanBeing", dAMLClass4.prop_sameClassAs().hasValue(dAMLClass));
        DAMLClass dAMLClass5 = dAMLModel.getDAMLClass(string + "TallMan");
        DAMLTest.assertNotNull("Class TallMan should not be null", dAMLClass5);
        DAMLList dAMLList2 = dAMLClass5.prop_intersectionOf().getList();
        DAMLTest.assertNotNull("Value of intersection should not be null", dAMLList2);
        DAMLTest.assertEquals("Tall man should be an intersection of size 2", 2, dAMLList2.getCount());
        DAMLClass dAMLClass6 = dAMLModel.getDAMLClass(string + "Car");
        DAMLTest.assertNotNull("Class Car should not be null", dAMLClass6);
        DAMLClass dAMLClass7 = (DAMLClass)dAMLClass6.getSuperClasses(false).next();
        DAMLTest.assertNotNull("Car should have a super-class", dAMLClass7);
        DAMLTest.assertTrue("Car super-class should be a complement", dAMLClass7.isComplement());
        DAMLTest.assertTrue("Car super-class should be a complement of Person", dAMLClass7.prop_complementOf().hasValue(dAMLClass));
        DAMLClass dAMLClass8 = dAMLModel.getDAMLClass(string + "Height");
        DAMLTest.assertNotNull("Class Height should not be null", dAMLClass8);
        DAMLTest.assertTrue("Height should be an enumeration", dAMLClass8.isEnumeration());
        DAMLTest.assertEquals("Height should be an enumeration of 3 elements", 3, dAMLClass8.prop_oneOf().getList().getCount());
        DAMLModel dAMLModel2 = this.getCleanModel();
        dAMLModel2.getLoader().setLoadImportedOntologies(true);
        dAMLModel2.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        String string2 = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass9 = dAMLModel2.getDAMLClass(string2 + "SubClassBug0");
        DAMLClass dAMLClass10 = dAMLModel2.getDAMLClass(string2 + "SubClassBug1");
        DAMLTest.assertNotNull("Class SubClassBug0 should not be null", dAMLClass9);
        DAMLTest.assertNotNull("Class SubClassBug1 should not be null", dAMLClass10);
        DAMLTest.assertTrue("SubClassBug1 should have SubClassBug0 as a super-class", dAMLClass10.hasSuperClass(dAMLClass9));
        DAMLTest.assertTrue("SubClassBug0 should have SubClassBug1 as a sub-class", dAMLClass9.hasSubClass(dAMLClass10));
        DAMLClass dAMLClass11 = dAMLModel2.getDAMLClass(string2 + "DefProp0");
        DAMLClass dAMLClass12 = dAMLModel2.getDAMLClass(string2 + "DefProp1");
        DAMLClass dAMLClass13 = dAMLModel2.getDAMLClass(string2 + "DefProp2");
        DAMLTest.assertNotNull("Class DefProp0 should not be null", dAMLClass11);
        DAMLTest.assertNotNull("Class DefProp1 should not be null", dAMLClass12);
        DAMLTest.assertNotNull("Class DefProp2 should not be null", dAMLClass13);
        int n4 = this.countIteration(dAMLClass11.getDefinedProperties(), true, "Defined property of DefProp0, closed");
        int n5 = this.countIteration(dAMLClass11.getDefinedProperties(false), true, "Defined property of DefProp0, not closed");
        int n6 = this.countIteration(dAMLClass12.getDefinedProperties(), true, "Defined property of DefProp1, closed");
        int n7 = this.countIteration(dAMLClass12.getDefinedProperties(false), true, "Defined property of DefProp1, not closed");
        int n8 = this.countIteration(dAMLClass13.getDefinedProperties(), true, "Defined property of DefProp2, closed");
        int n9 = this.countIteration(dAMLClass13.getDefinedProperties(false), true, "Defined property of DefProp2, not closed");
        DAMLTest.assertEquals("Defined properties of DefProp0 should number 11", 11, n4);
        DAMLTest.assertEquals("Defined properties of DefProp0 (non-closed) should number 11", 11, n5);
        DAMLTest.assertEquals("Defined properties of DefProp1 should number 11", 11, n6);
        DAMLTest.assertEquals("Defined properties of DefProp1 (non-closed) should number 0", 0, n7);
        DAMLTest.assertEquals("Defined properties of DefProp2 should number 12", 12, n8);
        DAMLTest.assertEquals("Defined properties of DefProp2 (non-closed) should number 1", 1, n9);
        DAMLTest.assertEquals("Defined properties of DefProp2 should number 12", 12, n8);
        DAMLTest.assertEquals("Defined properties of DefProp2 (non-closed) should number 1", 1, n9);
        DAMLClass dAMLClass14 = dAMLModel2.getDAMLClass(string2 + "tl_one");
        DAMLTest.assertNotNull("Class tl_one should not be null", dAMLClass14);
        int n10 = this.countIteration(dAMLClass14.prop_subClassOf().getAll(), true, "prop_subClassOf ");
        int n11 = this.countIteration(dAMLClass14.getSuperClasses(false), true, "getSuperClasses ");
        DAMLTest.assertEquals("Should be four super-classes of tl_one by prop_subClassOf", 4, n10);
        DAMLTest.assertEquals("Should be two super-classes of tl_one by getSuperClasses", 2, n11);
        DAMLClass dAMLClass15 = dAMLModel2.getDAMLClass(string2 + "Researcher");
        DAMLTest.assertNotNull("Class Researcher should not be null", dAMLClass15);
        int n12 = this.countIteration(dAMLClass15.getSuperClasses(false), true, "Super-class of researcher");
        DAMLTest.assertEquals("Should be 2 super-classes of researcher", 2, n12);
    }

    public void testEquivalence() {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "x0");
        DAMLTest.assertNotNull("Instance x0 should not be null", dAMLInstance);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(dAMLInstance.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "C0");
        DAMLTest.assertNotNull("Class C0 should not be null", dAMLClass);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(dAMLClass.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "p0");
        DAMLTest.assertNotNull("Property p0 should not be null", dAMLProperty);
        DAMLTest.assertEquals("Number of elements in equivalence class should be 1", 1, this.countIteration(dAMLProperty.getSameProperties(), true, "sameProperty as p0: "));
        Resource resource = dAMLModel.getResource(string + "CDaml");
        DAMLTest.assertNotNull("Resource dClass should not be null", resource);
        DAMLTest.assertTrue("Resource dClass should be a daml class", resource.canAs(DAMLClass.class));
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "D0");
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "D1");
        DAMLInstance dAMLInstance2 = dAMLModel.getDAMLInstance(string + "d1");
        DAMLTest.assertNotNull("Class D0 should not be null", dAMLClass2);
        DAMLTest.assertNotNull("Class D1 should not be null", dAMLClass3);
        DAMLTest.assertNotNull("Instance d1 should not be null", dAMLInstance2);
        DAMLTest.assertTrue("Instance d1 should have class D1", dAMLInstance2.hasRDFType(dAMLClass3));
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "pd0");
        DAMLProperty dAMLProperty3 = dAMLModel.getDAMLProperty(string + "pd1");
        DAMLTest.assertNotNull("Property pd0 should not be null", dAMLProperty2);
        DAMLTest.assertNotNull("Property pd1 should not be null", dAMLProperty3);
        DAMLInstance dAMLInstance3 = dAMLModel.getDAMLInstance(string + "d2");
        DAMLTest.assertNotNull("Instance d2 should not be null", dAMLInstance3);
        DAMLTest.assertTrue("d2 should have d1 as a value for pd0", dAMLInstance3.accessProperty(dAMLProperty2).hasValue(dAMLInstance2));
        DAMLProperty dAMLProperty4 = dAMLModel.getDAMLProperty(string + "pd2");
        DAMLProperty dAMLProperty5 = dAMLModel.getDAMLProperty(string + "pd3");
        DAMLTest.assertNotNull("Property pd2 should not be null", dAMLProperty4);
        DAMLTest.assertNotNull("Property pd3 should not be null", dAMLProperty5);
        DAMLTest.assertTrue("d2 should have d1 as a value for pd3", dAMLInstance3.accessProperty(dAMLProperty5).hasValue(dAMLInstance2));
        DAMLTest.assertTrue("d2 should have d1 as a value for pd2", dAMLInstance3.accessProperty(dAMLProperty4).hasValue(dAMLInstance2));
    }

    public void testProperty() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "hasMother");
        DAMLTest.assertNotNull("hasMother property should not be null", dAMLProperty);
        DAMLTest.assertTrue("hasMother property should be a unique property", dAMLProperty.isUnique());
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "hasParent");
        DAMLTest.assertNotNull("hasParent property should not be null", dAMLProperty2);
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Female");
        DAMLTest.assertNotNull("Class Female should not be null", dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Animal");
        DAMLTest.assertNotNull("Class Animal should not be null", dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull("Class Person should not be null", dAMLClass3);
        DAMLTest.assertTrue("Mother should have Female as range", dAMLProperty.prop_range().hasValue(dAMLClass));
        DAMLTest.assertTrue("Mother should not have Animal as local domain (prop_domain)", !dAMLProperty.prop_domain().hasValue(dAMLClass2));
        DAMLObjectProperty dAMLObjectProperty = (DAMLObjectProperty)dAMLModel.getDAMLProperty(string + "hasAncestor").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull("hasAncestor should not be null", dAMLObjectProperty);
        DAMLTest.assertTrue("hasAncestor should be transitive", dAMLObjectProperty.isTransitive());
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "Peter");
        DAMLTest.assertNotNull("Instance Peter should not be null", dAMLInstance);
        DAMLProperty dAMLProperty3 = dAMLModel.getDAMLProperty(string + "shoesize");
        DAMLTest.assertNotNull("Property shoesize should not be null", dAMLProperty3);
        PropertyAccessor propertyAccessor = dAMLInstance.accessProperty(dAMLProperty3);
        NodeIterator nodeIterator = propertyAccessor.getAll();
        DAMLTest.assertEquals("iShoes iterator should have at least one value", true, nodeIterator.hasNext());
        Object e = nodeIterator.next();
        DAMLTest.assertNotNull("size returned from property accessor iterator should not be null", e);
        DAMLTest.assertTrue("size object should be a literal", e instanceof Literal);
        boolean bl = false;
        try {
            nodeIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = true;
        }
        DAMLTest.assertEquals("Accessing past end of property iterator should throw no such element exception", true, bl);
        NodeIterator nodeIterator2 = dAMLClass3.prop_subClassOf().getAll();
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", nodeIterator2);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", nodeIterator2.hasNext());
        int n = this.countIteration(nodeIterator2, true, "direct super-class of Person = ");
        DAMLTest.assertEquals("Should be 10 super-classes of Person", 10, n);
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "Male");
        DAMLTest.assertNotNull("Class Male should not be null", dAMLClass4);
        DAMLCommon dAMLCommon = (DAMLCommon)dAMLClass.prop_disjointWith().get();
        DAMLTest.assertNotNull("Value for female.disjointWith should not be null", dAMLCommon);
        DAMLTest.assertTrue("female.disjointWith should be male", dAMLClass4.equals(dAMLCommon));
        dAMLModel.getLoader().setLoadImportedOntologies(false);
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModel.getDAMLValue(string + "subClassCheck3").as(DAMLClass.class);
        DAMLTest.assertNotNull("Class subClassCheck3 should not be null", dAMLClass5);
        ExtendedIterator extendedIterator = dAMLClass5.getSuperClasses(false);
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", nodeIterator2);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", extendedIterator.hasNext());
        n = this.countIteration(extendedIterator, true, "property access on subClassCheck3");
        DAMLTest.assertEquals("Should be 1 non-closed super-classes of subClassCheck3", 1, n);
        extendedIterator = dAMLClass5.getSuperClasses(true);
        DAMLTest.assertNotNull("Iterator over subClassOf values should not be null", nodeIterator2);
        DAMLTest.assertTrue("Iteration of subClassOf should have at least one value", extendedIterator.hasNext());
        n = this.countIteration(extendedIterator, true, "property access on subClassCheck3 with closed = true ");
        DAMLTest.assertEquals("Should be 3 closed super-classes of subClassCheck3", 3, n);
        DAMLProperty dAMLProperty4 = dAMLModel.getDAMLProperty(string + "q");
        DAMLTest.assertNotNull("Property q should not be null", dAMLProperty4);
        DAMLInstance dAMLInstance2 = dAMLModel.getDAMLInstance(string + "qX");
        DAMLTest.assertNotNull("Instance qX should not be null", dAMLInstance2);
        int n2 = dAMLInstance2.accessProperty(dAMLProperty4).count();
        DAMLTest.assertEquals("There should be 1 values for q of qX (equivalence off)", 1, n2);
        DAMLObjectProperty dAMLObjectProperty2 = (DAMLObjectProperty)dAMLModel.getDAMLProperty(string + "TL_PropertyTest").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull("Property should not be null", dAMLObjectProperty2);
        NodeIterator nodeIterator3 = dAMLObjectProperty2.prop_domain().getAll();
        DAMLTest.assertEquals("Property TL_PropertyTest should have a domain of two classes", 2, this.countIteration(nodeIterator3, false, null));
        NodeIterator nodeIterator4 = dAMLObjectProperty2.prop_range().getAll();
        DAMLTest.assertEquals("Property TL_PropertyTest should have a range of two classes", 2, this.countIteration(nodeIterator4, false, null));
        DAMLClass dAMLClass6 = (DAMLClass)dAMLModel.getDAMLValue(string + "HumanBody").as(DAMLClass.class);
        DAMLTest.assertNotNull("Class humanBody should not be null", dAMLClass6);
        PropertyAccessor propertyAccessor2 = dAMLClass6.prop_unionOf();
        DAMLTest.assertNotNull("Property accessor should not be null", propertyAccessor2);
        DAMLTest.assertEquals("Should be two value in union", 1, propertyAccessor2.count());
        DAMLCommon dAMLCommon2 = propertyAccessor2.getDAMLValue();
        DAMLTest.assertNotNull("Union should not be null", dAMLCommon2);
        DAMLTest.assertTrue("Union value should be a list", dAMLCommon2.canAs(DAMLList.class));
        DAMLTest.assertEquals("Should be two values in list", 2, ((DAMLList)dAMLCommon2.as(DAMLList.class)).getCount());
    }

    public void testList() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull("Person class should not be null", dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Man");
        DAMLTest.assertNotNull("Man class should not be null", dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Woman");
        DAMLTest.assertNotNull("Woman class should not be null", dAMLClass3);
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get().as(DAMLList.class);
        DAMLTest.assertNotNull("union should not be null", dAMLList);
        DAMLTest.assertEquals("union should have two values", 2, dAMLList.getCount());
        RDFNode rDFNode = dAMLList.getFirst();
        DAMLTest.assertEquals("Man should be the first element in the list", dAMLClass2, rDFNode);
        DAMLList dAMLList2 = dAMLList.getRest();
        DAMLTest.assertNotNull("Tail of list should not be null", dAMLList2);
        RDFNode rDFNode2 = dAMLList2.getFirst();
        DAMLTest.assertNotNull("head of tail should not be null", rDFNode2);
        DAMLTest.assertEquals("Woman should be the first element in the tail of the list", dAMLClass3, rDFNode2);
        DAMLList dAMLList3 = dAMLList2.getRest();
        DAMLTest.assertNotNull("Tail of tail should not be null", dAMLList3);
        DAMLTest.assertTrue("Remainder of list should be empty", dAMLList3.isEmpty());
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "Car");
        DAMLTest.assertNotNull("Class Car should not be null", dAMLClass4);
        dAMLList.add(dAMLClass4);
        DAMLTest.assertEquals("Union should contain three elements", 3, dAMLList.getCount());
    }

    public void testInstance() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLTest.assertEquals("Number of instances should be 7", 7, this.countIteration(dAMLModel.listDAMLInstances(), false, " instance = "));
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull("Person DAML class should not be null", dAMLClass);
        int n = this.countIteration(dAMLClass.getInstances(), true, "instance of person");
        DAMLTest.assertEquals("There should be 4 instances of Person in the model", 4, n);
    }

    public void testDatatype() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "Ian");
        DAMLTest.assertNotNull("Instance Ian should not be null", dAMLInstance);
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "shirtsize");
        DAMLTest.assertNotNull("Property shirtsize should not be null", dAMLProperty);
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "shoesize");
        DAMLTest.assertNotNull("Property shoesize should not be null", dAMLProperty2);
        DAMLDataInstance dAMLDataInstance = (DAMLDataInstance)dAMLInstance.getRequiredProperty(dAMLProperty).getObject().as(DAMLDataInstance.class);
        DAMLTest.assertNotNull("Object ian should have a shirtsize", dAMLDataInstance);
        Object object = dAMLDataInstance.getValue();
        DAMLTest.assertNotNull("Value of shirtsize should not be null", object);
        DAMLTest.assertEquals("Shirt size should be a string", String.class, object.getClass());
        DAMLTest.assertEquals("Shirt size should be \"12\"", (Object)"12", object);
    }

    public void testDataInstance() {
        DAMLModel dAMLModel = this.getCleanModel();
        DAMLDataInstance dAMLDataInstance = dAMLModel.createDAMLDataInstance(new Integer(9));
        DAMLTest.assertNotNull("Failed to create data instance ", dAMLDataInstance);
        DAMLTest.assertEquals("data instance URI not correct ", TypeMapper.getInstance().getTypeByName(XSD.xint.getURI()), dAMLDataInstance.getDatatype());
        String string = "http://example.org/eg#";
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(string + "Person");
        DAMLInstance dAMLInstance = dAMLModel.createDAMLInstance(dAMLClass, string + "peter");
        DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty(string + "shirtsize");
        dAMLInstance.addProperty((Property)dAMLDatatypeProperty, dAMLDataInstance);
    }

    public void testRemove() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setProcessImports(false);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        ArrayList arrayList = new ArrayList();
        this.checkValidLists(dAMLModel, "baseline");
        Object object = dAMLModel.listDAMLClasses();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLClass)arrayList.remove(0);
            log.debug("Removing class " + object);
            object.remove();
            this.checkValidLists(dAMLModel, "remove class");
        }
        object = dAMLModel.listDAMLInstances();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLInstance)arrayList.remove(0);
            log.debug("Removing instance " + object);
            object.remove();
            this.checkValidLists(dAMLModel, "remove instance");
        }
        object = dAMLModel.listDAMLProperties();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLProperty)arrayList.remove(0);
            log.debug("Removing property " + object);
            object.remove();
            this.checkValidLists(dAMLModel, "remove property");
        }
        boolean bl = false;
        ExtendedIterator extendedIterator = dAMLModel.listDAMLClasses();
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            if (((Object)resource).equals(DAML_OIL.Thing) || ((Object)resource).equals(DAML_OIL.Nothing) || resource.hasProperty(DAML_OIL.complementOf, DAML_OIL.Nothing)) continue;
            log.debug("Unexpected class remains: " + resource);
            StmtIterator stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                log.debug(" ... has prop " + stmtIterator.next());
            }
            bl = true;
        }
        DAMLTest.assertFalse("Should be no more classes", bl);
        DAMLTest.assertFalse("Should be no more properties", dAMLModel.listDAMLProperties().hasNext());
        DAMLTest.assertFalse("Should be no more instances", dAMLModel.listDAMLInstances().hasNext());
    }

    public void testCreate() {
        DAMLModel dAMLModel = this.getCleanModel();
        String string = "http://dickinson-i-4/daml/tests/gen#A";
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(string);
        DAMLTest.assertNotNull("Failed to create new DAML Class " + string, dAMLClass);
        boolean bl = false;
        Object object = dAMLModel.listDAMLClasses();
        while (object.hasNext()) {
            if (!((DAMLClass)object.next()).equals(dAMLClass)) continue;
            bl = true;
        }
        DAMLTest.assertTrue("Could not see class after it was created", bl);
        object = (DAMLInstance)dAMLModel.createDAMLValue("http://dickinson-i-4/daml/tests/gen#x", dAMLClass);
        DAMLTest.assertNotNull("Failed to create new DAML instance", object);
        bl = false;
        ExtendedIterator extendedIterator = dAMLModel.listDAMLInstances();
        while (extendedIterator.hasNext()) {
            if (!((DAMLInstance)extendedIterator.next()).equals(object)) continue;
            bl = true;
        }
        DAMLTest.assertTrue("Could not see instance after it was created", bl);
    }

    public void testRestriction() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        ExtendedIterator extendedIterator = dAMLClass.getSuperClasses();
        while (extendedIterator.hasNext()) {
            DAMLRestriction dAMLRestriction;
            PropertyAccessor propertyAccessor;
            int n;
            Resource resource = (Resource)extendedIterator.next();
            if (!(resource instanceof DAMLRestriction) || (n = (propertyAccessor = (dAMLRestriction = (DAMLRestriction)resource).prop_onProperty()).count()) < 1) continue;
            RDFNode rDFNode = propertyAccessor.get();
            Object object = propertyAccessor.getAll().next();
            DAMLTest.assertNotNull("Failed to access value of property accessor on restriction", rDFNode);
            DAMLTest.assertNotNull("Failed to access value of property accessor on restriction", object);
        }
    }

    public void testModelAdd() {
        DAMLModel dAMLModel = this.getCleanModel();
        dAMLModel.read("file:testing/ontology/daml/test-add-0.daml");
        DAMLTest.assertTrue("loadStatus should be true for successful load", dAMLModel.getLoadSuccessful());
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/ontology/daml/test-add-1.daml");
        DAMLTest.assertEquals("Instance count in DAML model should be 0", 0, this.countIteration(dAMLModel.listDAMLInstances(), true, "instance in test add"));
        dAMLModel.add(model);
        DAMLTest.assertEquals("Instance count in DAML model should be 1", 1, this.countIteration(dAMLModel.listDAMLInstances(), true, "instance in test add"));
    }

    public void testDatatypeProperty() {
        this.eqTest(new EqualityTest("DatatypeProperty"){

            String xml() {
                return "<daml:DatatypeProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatypeProperty(null);
            }
        });
    }

    public void testObjectProperty() {
        this.eqTest(new EqualityTest("ObjectProperty"){

            String xml() {
                return "<daml:ObjectProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLObjectProperty(null);
            }
        });
    }

    public void testPropertyEq() {
        this.eqTest(new EqualityTest("Property"){

            String xml() {
                return "<daml:Property/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLProperty(null);
            }
        });
    }

    public void testDatatypeEq2() {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#string");
            }
        });
    }

    public void testDatatypeRange() {
        this.eqTest(new EqualityTest("Datatype Range"){

            String xml() {
                return "<daml:DatatypeProperty rdf:ID='shoesize'> <rdf:type rdf:resource='http://www.daml.org/2001/03/daml+oil#UniqueProperty'/> <daml:range rdf:resource='http://www.w3.org/2000/10/XMLSchema#decimal'/></daml:DatatypeProperty><daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#decimal'/>";
            }

            void java(DAMLModel dAMLModel) {
                DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty("http://example.org/#shoesize");
                dAMLDatatypeProperty.setIsUnique(true);
                dAMLDatatypeProperty.prop_range().add(dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#decimal"));
            }
        });
    }

    private void eqTest(EqualityTest equalityTest) {
        DAMLModel dAMLModel = this.getCleanModel();
        equalityTest.java(dAMLModel);
        Model model = ModelFactory.createDefaultModel();
        StringReader stringReader = new StringReader("<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>" + equalityTest.xml() + "</rdf:RDF>");
        model.read(stringReader, "http://example.org/");
        if (!dAMLModel.getBaseModel().isIsomorphicWith(model)) {
            System.out.println("Java:");
            dAMLModel.write(System.out, "RDF/XML-ABBREV");
            System.out.println("XML:");
            model.write(System.out, "RDF/XML-ABBREV");
        }
        DAMLTest.assertTrue("java code and xml should be equivalent", dAMLModel.getBaseModel().isIsomorphicWith(model));
    }

    public void dumpModel(Model model) {
        this.dumpModel(model, "model-out.rdf");
    }

    public void dumpModel(Model model, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            model.write(fileOutputStream, "RDF/XML-ABBREV");
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).debug("Exception while dumping model: " + exception, exception);
        }
    }

    private int countIteration(Iterator iterator, boolean bl, String string) {
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                LogFactory.getLog(this.getClass()).debug("counting iteration, " + string + e);
            }
            ++n;
        }
        return n;
    }

    private int countClasses(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLClasses(), true, "class = ");
    }

    private int countProperties(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLProperties(), true, "property = ");
    }

    private DAMLModel getCleanModel() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setProcessImports(true);
        dAMLModel.getDocumentManager().clearCache();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = dAMLModel.getImportModelMaker().listModels();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            dAMLModel.getImportModelMaker().removeModel(string);
            log.debug("Removing " + string);
        }
        return dAMLModel;
    }

    private void checkValidLists(Model model, String string) {
        log.debug("Checking lists in DAMLTest - " + string);
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            if (!(rDFNode instanceof Resource) || !((Resource)rDFNode).canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList) || ((RDFList)rDFNode.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)).isValid()) continue;
            log.debug("!!Found invalid list in " + string + " - " + rDFNode);
            DAMLTest.assertTrue("DAML list not valid ", false);
        }
    }

    private static abstract class EqualityTest {
        String name;

        EqualityTest(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        abstract void java(DAMLModel var1);

        abstract String xml();
    }
}

