/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityQRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.LanguageConsistencyException;
import com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OWLSyntaxChecker;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.QualifiedRestriction;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.event.OntEventManager;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ConfigException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntModelImpl
extends ModelCom
implements OntModel {
    public static String owlSyntaxCheckerClassName = "com.hp.hpl.jena.ontology.tidy.JenaChecker";
    private static Log s_log = LogFactory.getLog(OntModelImpl.class);
    private static Class owlSyntaxCheckerClass;
    protected OntModelSpec m_spec;
    protected Set m_imported = new HashSet();
    protected BindingQueryPlan m_individualsQueryNoInf0;
    protected BindingQueryPlan m_individualsQueryNoInf1;
    protected boolean m_strictMode = true;
    protected MultiUnion m_union = new MultiUnion();
    protected ImportsListener m_importsListener = null;
    protected OntEventManager m_ontEventMgr = null;
    private Model m_deductionsModel = null;

    public OntModelImpl(OntModelSpec ontModelSpec, Model model) {
        this(ontModelSpec, OntModelImpl.makeBaseModel(ontModelSpec, model), false);
    }

    public OntModelImpl(OntModelSpec ontModelSpec) {
        this(ontModelSpec, ontModelSpec.createBaseModel(), false);
    }

    private OntModelImpl(OntModelSpec ontModelSpec, Model model, boolean bl) {
        super(OntModelImpl.generateGraph(ontModelSpec, model.getGraph()), BuiltinPersonalities.model);
        this.m_spec = ontModelSpec;
        this.m_union = this.getGraph() instanceof MultiUnion ? (MultiUnion)this.getGraph() : (MultiUnion)((InfGraph)this.getGraph()).getRawGraph();
        this.m_individualsQueryNoInf0 = this.queryXTypeOfType(this.getProfile().CLASS());
        this.m_individualsQueryNoInf1 = this.queryXTypeOfType(this.getProfile().RESTRICTION());
        if (this.getDocumentManager().useDeclaredPrefixes()) {
            this.withDefaultMappings(this.getDocumentManager().getDeclaredPrefixMapping());
        }
        this.getDocumentManager().loadImports(this);
        this.rebind();
    }

    public OntDocumentManager getDocumentManager() {
        return this.m_spec.getDocumentManager();
    }

    public ExtendedIterator listOntologies() {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().ONTOLOGY(), Ontology.class));
    }

    public ExtendedIterator listOntProperties() {
        return UniqueExtendedIterator.create(this.findByTypeAs(RDF.Property, OntProperty.class));
    }

    public ExtendedIterator listObjectProperties() {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().OBJECT_PROPERTY(), ObjectProperty.class));
    }

    public ExtendedIterator listDatatypeProperties() {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().DATATYPE_PROPERTY(), DatatypeProperty.class));
    }

    public ExtendedIterator listFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().FUNCTIONAL_PROPERTY(), FunctionalProperty.class));
    }

    public ExtendedIterator listTransitiveProperties() {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().TRANSITIVE_PROPERTY(), TransitiveProperty.class));
    }

    public ExtendedIterator listSymmetricProperties() {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().SYMMETRIC_PROPERTY(), SymmetricProperty.class));
    }

    public ExtendedIterator listInverseFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), InverseFunctionalProperty.class));
    }

    public ExtendedIterator listIndividuals() {
        boolean bl = false;
        if (this.getGraph() instanceof InfGraph) {
            bl = ((InfGraph)this.getGraph()).getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP);
        }
        if (!bl || this.getProfile().THING() == null || ((Object)this.getProfile().CLASS()).equals(RDFS.Class)) {
            ExtendedIterator extendedIterator = this.queryFor(this.m_individualsQueryNoInf0, null, Individual.class);
            if (this.m_individualsQueryNoInf1 != null) {
                extendedIterator = extendedIterator.andThen(this.queryFor(this.m_individualsQueryNoInf1, null, Individual.class));
            }
            if (this.getProfile().THING() != null) {
                extendedIterator = extendedIterator.andThen(this.findByTypeAs(this.getProfile().THING(), Individual.class));
            }
            return UniqueExtendedIterator.create(extendedIterator);
        }
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().THING(), Individual.class));
    }

    public ExtendedIterator listClasses() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().getClassDescriptionTypes(), OntClass.class));
    }

    public ExtendedIterator listHierarchyRootClasses() {
        Model model;
        if (this.getReasoner() != null && (model = this.getReasoner().getReasonerCapabilities()).contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf) && this.getProfile().THING() != null) {
            return this.listStatements(null, ReasonerVocabulary.directSubClassOf, this.getProfile().THING()).mapWith(new OntResourceImpl.SubjectAsMapper(OntClass.class));
        }
        return this.listClasses().filterDrop(new Filter(){

            public boolean accept(Object object) {
                return ((OntResource)object).isOntLanguageTerm();
            }
        }).filterKeep(new Filter(){

            public boolean accept(Object object) {
                return ((OntClass)object).isHierarchyRoot();
            }
        });
    }

    public ExtendedIterator listEnumeratedClasses() {
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().ONE_OF(), EnumeratedClass.class));
    }

    public ExtendedIterator listUnionClasses() {
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().UNION_OF(), UnionClass.class));
    }

    public ExtendedIterator listComplementClasses() {
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().COMPLEMENT_OF(), ComplementClass.class));
    }

    public ExtendedIterator listIntersectionClasses() {
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().INTERSECTION_OF(), IntersectionClass.class));
    }

    public ExtendedIterator listNamedClasses() {
        return this.listClasses().filterDrop(new Filter(){

            public boolean accept(Object object) {
                return ((Resource)object).isAnon();
            }
        });
    }

    public ExtendedIterator listRestrictions() {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().RESTRICTION(), Restriction.class));
    }

    public ExtendedIterator listAllDifferent() {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().ALL_DIFFERENT(), AllDifferent.class));
    }

    public ExtendedIterator listDataRanges() {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().DATARANGE(), DataRange.class));
    }

    public ExtendedIterator listAnnotationProperties() {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        Resource resource = this.getProfile().ANNOTATION_PROPERTY();
        if (resource == null) {
            return NullIterator.instance;
        }
        return UniqueExtendedIterator.create(this.findByType(resource).andThen(WrappedIterator.create(this.getProfile().getAnnotationProperties())).mapWith(new SubjectNodeAs(AnnotationProperty.class)));
    }

    public Ontology getOntology(String string) {
        return (Ontology)this.findByURIAs(string, Ontology.class);
    }

    public Individual getIndividual(String string) {
        return (Individual)this.findByURIAs(string, Individual.class);
    }

    public OntProperty getOntProperty(String string) {
        return (OntProperty)this.findByURIAs(string, OntProperty.class);
    }

    public ObjectProperty getObjectProperty(String string) {
        return (ObjectProperty)this.findByURIAs(string, ObjectProperty.class);
    }

    public TransitiveProperty getTransitiveProperty(String string) {
        return (TransitiveProperty)this.findByURIAs(string, TransitiveProperty.class);
    }

    public SymmetricProperty getSymmetricProperty(String string) {
        return (SymmetricProperty)this.findByURIAs(string, SymmetricProperty.class);
    }

    public InverseFunctionalProperty getInverseFunctionalProperty(String string) {
        return (InverseFunctionalProperty)this.findByURIAs(string, InverseFunctionalProperty.class);
    }

    public DatatypeProperty getDatatypeProperty(String string) {
        return (DatatypeProperty)this.findByURIAs(string, DatatypeProperty.class);
    }

    public AnnotationProperty getAnnotationProperty(String string) {
        return (AnnotationProperty)this.findByURIAs(string, AnnotationProperty.class);
    }

    public OntClass getOntClass(String string) {
        return (OntClass)this.findByURIAs(string, OntClass.class);
    }

    public ComplementClass getComplementClass(String string) {
        return (ComplementClass)this.findByURIAs(string, ComplementClass.class);
    }

    public EnumeratedClass getEnumeratedClass(String string) {
        return (EnumeratedClass)this.findByURIAs(string, EnumeratedClass.class);
    }

    public UnionClass getUnionClass(String string) {
        return (UnionClass)this.findByURIAs(string, UnionClass.class);
    }

    public IntersectionClass getIntersectionClass(String string) {
        return (IntersectionClass)this.findByURIAs(string, IntersectionClass.class);
    }

    public Restriction getRestriction(String string) {
        return (Restriction)this.findByURIAs(string, Restriction.class);
    }

    public HasValueRestriction getHasValueRestriction(String string) {
        return (HasValueRestriction)this.findByURIAs(string, HasValueRestriction.class);
    }

    public SomeValuesFromRestriction getSomeValuesFromRestriction(String string) {
        return (SomeValuesFromRestriction)this.findByURIAs(string, SomeValuesFromRestriction.class);
    }

    public AllValuesFromRestriction getAllValuesFromRestriction(String string) {
        return (AllValuesFromRestriction)this.findByURIAs(string, AllValuesFromRestriction.class);
    }

    public CardinalityRestriction getCardinalityRestriction(String string) {
        return (CardinalityRestriction)this.findByURIAs(string, CardinalityRestriction.class);
    }

    public MinCardinalityRestriction getMinCardinalityRestriction(String string) {
        return (MinCardinalityRestriction)this.findByURIAs(string, MinCardinalityRestriction.class);
    }

    public MaxCardinalityRestriction getMaxCardinalityRestriction(String string) {
        return (MaxCardinalityRestriction)this.findByURIAs(string, MaxCardinalityRestriction.class);
    }

    public QualifiedRestriction getQualifiedRestriction(String string) {
        return (QualifiedRestriction)this.findByURIAs(string, QualifiedRestriction.class);
    }

    public CardinalityQRestriction getCardinalityQRestriction(String string) {
        return (CardinalityQRestriction)this.findByURIAs(string, CardinalityQRestriction.class);
    }

    public MinCardinalityQRestriction getMinCardinalityQRestriction(String string) {
        return (MinCardinalityQRestriction)this.findByURIAs(string, MinCardinalityQRestriction.class);
    }

    public MaxCardinalityQRestriction getMaxCardinalityQRestriction(String string) {
        return (MaxCardinalityQRestriction)this.findByURIAs(string, MaxCardinalityQRestriction.class);
    }

    public Ontology createOntology(String string) {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return (Ontology)this.createOntResource(Ontology.class, this.getProfile().ONTOLOGY(), string);
    }

    public Individual createIndividual(Resource resource) {
        return (Individual)this.createOntResource(Individual.class, resource, null);
    }

    public Individual createIndividual(String string, Resource resource) {
        return (Individual)this.createOntResource(Individual.class, resource, string);
    }

    public OntProperty createOntProperty(String string) {
        Property property = this.createProperty(string);
        property.addProperty(RDF.type, this.getProfile().PROPERTY());
        return (OntProperty)property.as(OntProperty.class);
    }

    public ObjectProperty createObjectProperty(String string) {
        return this.createObjectProperty(string, false);
    }

    public ObjectProperty createObjectProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        ObjectProperty objectProperty = (ObjectProperty)this.createOntResource(ObjectProperty.class, this.getProfile().OBJECT_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            objectProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return objectProperty;
    }

    public TransitiveProperty createTransitiveProperty(String string) {
        return this.createTransitiveProperty(string, false);
    }

    public TransitiveProperty createTransitiveProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        TransitiveProperty transitiveProperty = (TransitiveProperty)this.createOntResource(TransitiveProperty.class, this.getProfile().TRANSITIVE_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            transitiveProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return transitiveProperty;
    }

    public SymmetricProperty createSymmetricProperty(String string) {
        return this.createSymmetricProperty(string, false);
    }

    public SymmetricProperty createSymmetricProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        SymmetricProperty symmetricProperty = (SymmetricProperty)this.createOntResource(SymmetricProperty.class, this.getProfile().SYMMETRIC_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            symmetricProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return symmetricProperty;
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String string) {
        return this.createInverseFunctionalProperty(string, false);
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        InverseFunctionalProperty inverseFunctionalProperty = (InverseFunctionalProperty)this.createOntResource(InverseFunctionalProperty.class, this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            inverseFunctionalProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return inverseFunctionalProperty;
    }

    public DatatypeProperty createDatatypeProperty(String string) {
        return this.createDatatypeProperty(string, false);
    }

    public DatatypeProperty createDatatypeProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        DatatypeProperty datatypeProperty = (DatatypeProperty)this.createOntResource(DatatypeProperty.class, this.getProfile().DATATYPE_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            datatypeProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return datatypeProperty;
    }

    public AnnotationProperty createAnnotationProperty(String string) {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        return (AnnotationProperty)this.createOntResource(AnnotationProperty.class, this.getProfile().ANNOTATION_PROPERTY(), string);
    }

    public OntClass createClass() {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), null);
    }

    public OntClass createClass(String string) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), string);
    }

    public ComplementClass createComplementClass(String string, Resource resource) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        ontClass.addProperty(this.getProfile().COMPLEMENT_OF(), resource == null ? this.getProfile().NOTHING() : resource);
        return (ComplementClass)ontClass.as(ComplementClass.class);
    }

    public EnumeratedClass createEnumeratedClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        ontClass.addProperty(this.getProfile().ONE_OF(), rDFList == null ? this.createList() : rDFList);
        return (EnumeratedClass)ontClass.as(EnumeratedClass.class);
    }

    public UnionClass createUnionClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        ontClass.addProperty(this.getProfile().UNION_OF(), rDFList == null ? this.createList() : rDFList);
        return (UnionClass)ontClass.as(UnionClass.class);
    }

    public IntersectionClass createIntersectionClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        ontClass.addProperty(this.getProfile().INTERSECTION_OF(), rDFList == null ? this.createList() : rDFList);
        return (IntersectionClass)ontClass.as(IntersectionClass.class);
    }

    public Restriction createRestriction(Property property) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), null);
        if (property != null) {
            restriction.setOnProperty(property);
        }
        return restriction;
    }

    public Restriction createRestriction(String string, Property property) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property != null) {
            restriction.setOnProperty(property);
        }
        return restriction;
    }

    public HasValueRestriction createHasValueRestriction(String string, Property property, RDFNode rDFNode) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null || rDFNode == null) {
            throw new IllegalArgumentException("Cannot create hasValueRestriction with a null property or value");
        }
        this.checkProfileEntry(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().HAS_VALUE(), rDFNode);
        return (HasValueRestriction)restriction.as(HasValueRestriction.class);
    }

    public SomeValuesFromRestriction createSomeValuesFromRestriction(String string, Property property, Resource resource) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null || resource == null) {
            throw new IllegalArgumentException("Cannot create someValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().SOME_VALUES_FROM(), resource);
        return (SomeValuesFromRestriction)restriction.as(SomeValuesFromRestriction.class);
    }

    public AllValuesFromRestriction createAllValuesFromRestriction(String string, Property property, Resource resource) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null || resource == null) {
            throw new IllegalArgumentException("Cannot create allValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().ALL_VALUES_FROM(), resource);
        return (AllValuesFromRestriction)restriction.as(AllValuesFromRestriction.class);
    }

    public CardinalityRestriction createCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create cardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().CARDINALITY(), "CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().CARDINALITY(), this.createTypedLiteral(n));
        return (CardinalityRestriction)restriction.as(CardinalityRestriction.class);
    }

    public MinCardinalityRestriction createMinCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create minCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MIN_CARDINALITY(), this.createTypedLiteral(n));
        return (MinCardinalityRestriction)restriction.as(MinCardinalityRestriction.class);
    }

    public MaxCardinalityRestriction createMaxCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create maxCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MAX_CARDINALITY(), this.createTypedLiteral(n));
        return (MaxCardinalityRestriction)restriction.as(MaxCardinalityRestriction.class);
    }

    public MaxCardinalityQRestriction createMaxCardinalityQRestriction(String string, Property property, int n, OntClass ontClass) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (property == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null property");
        }
        if (ontClass == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null class");
        }
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MAX_CARDINALITY_Q(), this.createTypedLiteral(n));
        restriction.addProperty(this.getProfile().HAS_CLASS_Q(), ontClass);
        return (MaxCardinalityQRestriction)restriction.as(MaxCardinalityQRestriction.class);
    }

    public MinCardinalityQRestriction createMinCardinalityQRestriction(String string, Property property, int n, OntClass ontClass) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (property == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null property");
        }
        if (ontClass == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null class");
        }
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MIN_CARDINALITY_Q(), this.createTypedLiteral(n));
        restriction.addProperty(this.getProfile().HAS_CLASS_Q(), ontClass);
        return (MinCardinalityQRestriction)restriction.as(MinCardinalityQRestriction.class);
    }

    public CardinalityQRestriction createCardinalityQRestriction(String string, Property property, int n, OntClass ontClass) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (property == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null property");
        }
        if (ontClass == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null class");
        }
        Restriction restriction = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), string);
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().CARDINALITY_Q(), this.createTypedLiteral(n));
        restriction.addProperty(this.getProfile().HAS_CLASS_Q(), ontClass);
        return (CardinalityQRestriction)restriction.as(CardinalityQRestriction.class);
    }

    public DataRange createDataRange(RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        DataRange dataRange = (DataRange)this.createOntResource(DataRange.class, this.getProfile().DATARANGE(), null);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        dataRange.addProperty(this.getProfile().ONE_OF(), rDFList == null ? this.createList() : rDFList);
        return dataRange;
    }

    public AllDifferent createAllDifferent() {
        return this.createAllDifferent(null);
    }

    public AllDifferent createAllDifferent(RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        AllDifferent allDifferent = (AllDifferent)this.createOntResource(AllDifferent.class, this.getProfile().ALL_DIFFERENT(), null);
        allDifferent.setDistinctMembers(rDFList == null ? this.createList() : rDFList);
        return allDifferent;
    }

    public OntResource createOntResource(Class clazz, Resource resource, String string) {
        return (OntResource)this.getResourceWithType(string, resource).as(clazz);
    }

    public OntResource createOntResource(String string) {
        return (OntResource)this.getResource(string).as(OntResource.class);
    }

    public RDFList createList() {
        Resource resource = this.getResource(this.getProfile().NIL().getURI());
        return (RDFList)resource.as(RDFList.class);
    }

    public Profile getProfile() {
        return this.m_spec.getProfile();
    }

    public boolean hasLoadedImport(String string) {
        return this.m_imported.contains(string);
    }

    public void addLoadedImport(String string) {
        this.m_imported.add(string);
    }

    public void removeLoadedImport(String string) {
        this.m_imported.remove(string);
    }

    public Set listImportedOntologyURIs() {
        return this.listImportedOntologyURIs(false);
    }

    public Set listImportedOntologyURIs(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Model> arrayList = new ArrayList<Model>();
        arrayList.add(this.getBaseModel());
        while (!arrayList.isEmpty()) {
            Model model = (Model)arrayList.remove(0);
            if (this.getProfile().ONTOLOGY() == null || this.getProfile().IMPORTS() == null) continue;
            StmtIterator stmtIterator = model.listStatements(null, this.getProfile().IMPORTS(), (RDFNode)null);
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                String string = statement.getResource().getURI();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                Model model2 = this.getDocumentManager().getModel(string);
                if (!bl || model2 == null || arrayList.contains(model2)) continue;
                arrayList.add(model2);
            }
        }
        return hashSet;
    }

    public ModelMaker getImportModelMaker() {
        return this.m_spec.getImportModelMaker();
    }

    public ModelMaker getModelMaker() {
        return this.getImportModelMaker();
    }

    public Resource getOWLLanguageLevel(List list) {
        OntModelImpl.initSyntaxCheckerClass();
        try {
            return ((OWLSyntaxChecker)owlSyntaxCheckerClass.newInstance()).getOWLLanguageLevel(this, list);
        }
        catch (InstantiationException instantiationException) {
            throw new BrokenException("Syntax Checker misconfigured: ", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BrokenException("Syntax Checker misconfigured: ", illegalAccessException);
        }
    }

    public Model read(String string) {
        return this.read(string, null);
    }

    public Model read(Reader reader, String string) {
        super.read(reader, string);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream inputStream, String string) {
        super.read(inputStream, string);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(String string, String string2) {
        return this.read(string, string, string2);
    }

    public Model read(String string, String string2, String string3) {
        if (s_log.isDebugEnabled()) {
            s_log.debug("Noting already loaded import URI " + string);
        }
        this.addLoadedImport(string);
        String string4 = this.getDocumentManager().doAltURLMapping(string);
        super.read(string4, string2, string3);
        this.getDocumentManager().addModel(string, this);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(Reader reader, String string, String string2) {
        super.read(reader, string, string2);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream inputStream, String string, String string2) {
        super.read(inputStream, string, string2);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public List getSubGraphs() {
        return this.getUnionGraph().getSubGraphs();
    }

    public ExtendedIterator listImportedModels() {
        ExtendedIterator extendedIterator = WrappedIterator.create(this.getSubGraphs().iterator());
        return extendedIterator.mapWith(new Map1(){

            public Object map1(Object object) {
                Graph graph = (Graph)object;
                Model model = ModelFactory.createModelForGraph(graph);
                return ModelFactory.createOntologyModel(OntModelImpl.this.m_spec, model);
            }
        });
    }

    public OntModel getImportedModel(String string) {
        Model model;
        if (this.listImportedOntologyURIs(true).contains(string) && (model = this.getDocumentManager().getModel(string)) != null) {
            if (model instanceof OntModel) {
                return (OntModel)model;
            }
            return ModelFactory.createOntologyModel(this.m_spec, model);
        }
        return null;
    }

    public Graph getBaseGraph() {
        return this.getUnionGraph().getBaseGraph();
    }

    public Model getBaseModel() {
        Model model = ModelFactory.createModelForGraph(this.getBaseGraph());
        model.setNsPrefixes(this);
        return model;
    }

    public void addSubModel(Model model) {
        this.addSubModel(model, true);
    }

    public void addSubModel(Model model, boolean bl) {
        this.getUnionGraph().addGraph(model.getGraph());
        if (bl) {
            this.rebind();
        }
    }

    public void removeSubModel(Model model) {
        this.removeSubModel(model, true);
    }

    public void removeSubModel(Model model, boolean bl) {
        Graph graph = model.getGraph();
        if (graph instanceof MultiUnion) {
            graph = ((MultiUnion)graph).getBaseGraph();
        }
        this.getUnionGraph().removeGraph(graph);
        if (bl) {
            this.rebind();
        }
    }

    public boolean isInBaseModel(RDFNode rDFNode) {
        Node node = rDFNode.asNode();
        Graph graph = this.getBaseGraph();
        return graph.contains(node, Node.ANY, Node.ANY) || graph.contains(Node.ANY, node, Node.ANY) || graph.contains(Node.ANY, Node.ANY, node);
    }

    public boolean isInBaseModel(Statement statement) {
        Node node = statement.getSubject().asNode();
        Node node2 = statement.getPredicate().asNode();
        Node node3 = statement.getObject().asNode();
        Graph graph = this.getBaseGraph();
        return graph.contains(node, node2, node3);
    }

    public boolean strictMode() {
        return this.m_strictMode;
    }

    public void setStrictMode(boolean bl) {
        this.m_strictMode = bl;
    }

    public void setDynamicImports(boolean bl) {
        if (bl) {
            if (this.m_importsListener == null) {
                this.m_importsListener = new ImportsListener();
                this.register(this.m_importsListener);
            }
        } else if (this.m_importsListener != null) {
            this.unregister(this.m_importsListener);
            this.m_importsListener = null;
        }
    }

    public boolean getDynamicImports() {
        return this.m_importsListener != null;
    }

    public OntModelSpec getSpecification() {
        return this.m_spec;
    }

    public OntEventManager getEventManager() {
        if (this.m_ontEventMgr == null) {
            this.m_ontEventMgr = new OntEventManager(this);
        }
        return this.m_ontEventMgr;
    }

    public ExtendedIterator queryFor(BindingQueryPlan bindingQueryPlan, List list, Class clazz) {
        GetBinding getBinding = new GetBinding(0);
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings().mapWith(getBinding);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtendedIterator extendedIterator2 = ((BindingQueryPlan)iterator.next()).executeBindings().mapWith(getBinding);
                extendedIterator = extendedIterator.andThen(extendedIterator2);
            }
        }
        return extendedIterator.filterKeep(new SubjectNodeCanAs(clazz)).mapWith(new SubjectNodeAs(clazz));
    }

    public Model write(Writer writer) {
        return this.getBaseModel().write(writer);
    }

    public Model write(Writer writer, String string) {
        return this.getBaseModel().write(writer, string);
    }

    public Model write(Writer writer, String string, String string2) {
        return this.getBaseModel().write(writer, string, string2);
    }

    public Model write(OutputStream outputStream) {
        return this.getBaseModel().write(outputStream);
    }

    public Model write(OutputStream outputStream, String string) {
        return this.getBaseModel().write(outputStream, string);
    }

    public Model write(OutputStream outputStream, String string, String string2) {
        return this.getBaseModel().write(outputStream, string, string2);
    }

    public Model writeAll(Writer writer, String string, String string2) {
        return super.write(writer, string, string2);
    }

    public Model writeAll(OutputStream outputStream, String string, String string2) {
        return super.write(outputStream, string, string2);
    }

    public Model getRawModel() {
        return this.getBaseModel();
    }

    public Reasoner getReasoner() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getReasoner() : null;
    }

    public void rebind() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).rebind();
        }
    }

    public void prepare() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).prepare();
        }
    }

    public void reset() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).reset();
        }
    }

    public Model getDeductionsModel() {
        Graph graph;
        InfGraph infGraph;
        if (this.m_deductionsModel == null && (infGraph = this.getInfGraph()) != null && (graph = infGraph.getDeductionsGraph()) != null) {
            this.m_deductionsModel = ModelFactory.createModelForGraph(graph);
        }
        return this.m_deductionsModel;
    }

    public ValidityReport validate() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).validate() : null;
    }

    public StmtIterator listStatements(Resource resource, Property property, RDFNode rDFNode, Model model) {
        if (this.getGraph() instanceof InfGraph) {
            ExtendedIterator extendedIterator = ((InfGraph)this.getGraph()).find(resource.asNode(), property.asNode(), rDFNode.asNode(), model.getGraph());
            return IteratorFactory.asStmtIterator(extendedIterator, this);
        }
        return null;
    }

    public void setDerivationLogging(boolean bl) {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).setDerivationLogging(bl);
        }
    }

    public Iterator getDerivation(Statement statement) {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getDerivation(statement.asTriple()) : null;
    }

    private static void initSyntaxCheckerClass() {
        if (owlSyntaxCheckerClass == null) {
            try {
                owlSyntaxCheckerClass = Class.forName(owlSyntaxCheckerClassName);
                OWLSyntaxChecker oWLSyntaxChecker = (OWLSyntaxChecker)owlSyntaxCheckerClass.newInstance();
            }
            catch (Exception exception) {
                throw new ConfigException("owlsyntax.jar must be on the classpath.", exception);
            }
        }
    }

    private static Graph generateGraph(OntModelSpec ontModelSpec, Graph graph) {
        MultiUnion multiUnion = new MultiUnion();
        multiUnion.addGraph(graph);
        multiUnion.setBaseGraph(graph);
        Reasoner reasoner = ontModelSpec.getReasoner();
        return reasoner == null ? multiUnion : reasoner.bind(multiUnion);
    }

    protected MultiUnion getUnionGraph() {
        return this.m_union;
    }

    protected Resource findByURIAs(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get() ontology value with a null URI");
        }
        Node node = Node.createURI(string);
        if (this.getGraph().contains(node, Node.ANY, Node.ANY)) {
            try {
                return (Resource)((Object)this.getNodeAs(node, clazz));
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExtendedIterator findByType(Resource resource) {
        return this.getGraph().find(null, RDF.type.asNode(), resource.asNode());
    }

    protected ExtendedIterator findByType(Resource resource, Iterator iterator) {
        ExtendedIterator extendedIterator = this.findByType(resource);
        if (iterator != null) {
            while (iterator.hasNext()) {
                extendedIterator = extendedIterator.andThen(this.findByType((Resource)iterator.next()));
            }
        }
        return UniqueExtendedIterator.create(extendedIterator);
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Iterator iterator, Class clazz) {
        return this.findByType(resource, iterator).mapWith(new SubjectNodeAs(clazz));
    }

    protected ExtendedIterator findByTypeAs(Iterator iterator, Class clazz) {
        return this.findByTypeAs((Resource)iterator.next(), iterator, clazz);
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Class clazz) {
        return this.findByType(resource).mapWith(new SubjectNodeAs(clazz));
    }

    protected BindingQueryPlan queryXTypeOfType(Resource resource) {
        if (resource != null) {
            Query query = new Query();
            query.addMatch(Query.Y, RDF.type.asNode(), resource.asNode());
            query.addMatch(Query.X, RDF.type.asNode(), Query.Y);
            return this.queryHandler().prepareBindings(query, new Node[]{Query.X});
        }
        return null;
    }

    protected ExtendedIterator findByDefiningProperty(Property property) {
        return this.getGraph().find(null, property.getNode(), null);
    }

    protected ExtendedIterator findByDefiningPropertyAs(Property property, Class clazz) {
        return this.findByDefiningProperty(property).mapWith(new SubjectNodeAs(clazz));
    }

    protected Resource getResourceWithType(String string, Resource resource) {
        Resource resource2 = this.getResource(string);
        if (resource != null) {
            resource2.addProperty(RDF.type, resource);
        }
        return resource2;
    }

    public OntResource getOntResource(String string) {
        Resource resource = this.getResource(string);
        if (this.containsResource(resource)) {
            return (OntResource)resource.as(OntResource.class);
        }
        return null;
    }

    public OntResource getOntResource(Resource resource) {
        return (OntResource)resource.inModel(this).as(OntResource.class);
    }

    protected void checkProfileEntry(Object object, String string) {
        if (object == null) {
            throw new ProfileException(string, this.getProfile());
        }
    }

    protected void checkListMembersRdfType(RDFList rDFList, Resource resource) {
        if (this.strictMode() && !((Boolean)rDFList.reduce(new RdfTypeTestFn(resource), Boolean.TRUE)).booleanValue()) {
            throw new LanguageConsistencyException("The members of the given list are expected to be of rdf:type " + ((Object)resource).toString());
        }
    }

    private static Model makeBaseModel(OntModelSpec ontModelSpec, Model model) {
        return model == null ? ontModelSpec.createBaseModel() : model;
    }

    private InfGraph getInfGraph() {
        return this.getGraph() instanceof InfGraph ? (InfGraph)this.getGraph() : null;
    }

    protected class ImportsListener
    extends StatementListener {
        protected ImportsListener() {
        }

        public void addedStatement(Statement statement) {
            if (statement.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().loadImport(OntModelImpl.this, statement.getResource().getURI());
            }
        }

        public void removedStatement(Statement statement) {
            if (statement.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().unloadImport(OntModelImpl.this, statement.getResource().getURI());
            }
        }
    }

    protected class RdfTypeTestFn
    implements RDFList.ReduceFn {
        protected Resource m_type;

        protected RdfTypeTestFn(Resource resource) {
            this.m_type = resource;
        }

        public Object reduce(RDFNode rDFNode, Object object) {
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                Resource resource = (Resource)rDFNode;
                return new Boolean(resource.hasProperty(RDF.type, this.m_type));
            }
            return bl;
        }
    }

    protected class GetBinding
    implements Map1 {
        protected int m_index;

        protected GetBinding(int n) {
            this.m_index = n;
        }

        public Object map1(Object object) {
            return ((List)object).get(this.m_index);
        }
    }

    protected class SubjectNodeCanAs
    implements Filter {
        protected Class m_asKey;

        protected SubjectNodeCanAs(Class clazz) {
            this.m_asKey = clazz;
        }

        public boolean accept(Object object) {
            Node node = object instanceof Triple ? ((Triple)object).getSubject() : (object instanceof EnhNode ? ((EnhNode)object).asNode() : (Node)object);
            try {
                OntModelImpl.this.getNodeAs(node, this.m_asKey);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }

    protected class SubjectNodeAs
    implements Map1 {
        protected Class m_asKey;

        protected SubjectNodeAs(Class clazz) {
            this.m_asKey = clazz;
        }

        public Object map1(Object object) {
            Node node = object instanceof Triple ? ((Triple)object).getSubject() : (object instanceof EnhNode ? ((EnhNode)object).asNode() : (Node)object);
            return OntModelImpl.this.getNodeAs(node, this.m_asKey);
        }
    }
}

