/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;

public class TestOntClass
extends ModelTestBase {
    private static final String NS = "http://example.com/test#";

    public TestOntClass(String string) {
        super(string);
    }

    public void testSuperClassNE() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        TestOntClass.assertNull(ontClass.getSuperClass());
        TestOntClass.assertFalse(ontClass.hasSuperClass());
    }

    public void testSubClassNE() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        TestOntClass.assertNull(ontClass.getSubClass());
        TestOntClass.assertFalse(ontClass.hasSubClass());
    }

    public void testCreateIndividual() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        Individual individual = ontClass.createIndividual("http://example.com/test#i");
        TestOntClass.assertTrue(individual.hasRDFType(ontClass));
        Individual individual2 = ontClass.createIndividual();
        TestOntClass.assertTrue(individual2.hasRDFType(ontClass));
    }

    public void testIsHierarchyRoot0() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot1() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot2() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot3() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_TRANS_INF);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot4() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot5() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot6() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot7() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot8() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }

    public void testIsHierarchyRoot9() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_RDFS_INF);
        OntClass ontClass = ontModel.createClass("http://example.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://example.com/test#B");
        ontClass.addSubClass(ontClass2);
        TestOntClass.assertTrue(ontClass.isHierarchyRoot());
        TestOntClass.assertFalse(ontClass2.isHierarchyRoot());
    }
}

