/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OntDocManagerVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOntDocumentManager
extends TestCase {
    private static Boolean F = Boolean.FALSE;
    private static Boolean T = Boolean.TRUE;
    public static Object[][] s_testData = new Object[][]{{"testing/ontology/testImport1", TestOntDocumentManager.cnt(1), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(1), F, null}, {"testing/ontology/testImport3", TestOntDocumentManager.cnt(3), T, null}, {"testing/ontology/testImport4", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport5", TestOntDocumentManager.cnt(2), T, "file:testing/ontology/testImport5/ont-policy.rdf"}};

    public static final Integer cnt(int n) {
        return new Integer(n);
    }

    public TestOntDocumentManager(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestOntDocumentManager");
        testSuite.addTestSuite(TestOntDocumentManager.class);
        for (int i = 0; i < s_testData.length; ++i) {
            testSuite.addTest(new DocManagerImportTest((String)s_testData[i][0], (Integer)s_testData[i][1], (Boolean)s_testData[i][2], (String)s_testData[i][3]));
        }
        return testSuite;
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testInitialisation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue("Should be at least one specification loaded", ontDocumentManager.listDocuments().hasNext());
        TestOntDocumentManager.assertNotNull("cache URL for owl should not be null", ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("cache URL for owl not correct", "file:vocabularies/owl.owl", ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("prefix for owl not correct", "owl", ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        ontDocumentManager = new OntDocumentManager("");
        TestOntDocumentManager.assertTrue("Should be no specification loaded", !ontDocumentManager.listDocuments().hasNext());
        ontDocumentManager = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue("Should be no specification loaded", !ontDocumentManager.listDocuments().hasNext());
    }

    public void testReset() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue(ontDocumentManager.getProcessImports());
        ontDocumentManager.setProcessImports(false);
        TestOntDocumentManager.assertFalse(ontDocumentManager.getProcessImports());
        ontDocumentManager.reset();
        TestOntDocumentManager.assertTrue(ontDocumentManager.getProcessImports());
        TestOntDocumentManager.assertEquals("file:ont-policy.rdf;file:etc/ont-policy.rdf", ontDocumentManager.getMetadataSearchPath());
        ontDocumentManager.setMetadataSearchPath("file:foo.xml", true);
        TestOntDocumentManager.assertEquals("file:foo.xml", ontDocumentManager.getMetadataSearchPath());
        ontDocumentManager.reset();
        TestOntDocumentManager.assertEquals("file:ont-policy.rdf;file:etc/ont-policy.rdf", ontDocumentManager.getMetadataSearchPath());
        TestOntDocumentManager.assertTrue(ontDocumentManager.getCacheModels());
        ontDocumentManager.setCacheModels(false);
        TestOntDocumentManager.assertFalse(ontDocumentManager.getCacheModels());
        ontDocumentManager.reset();
        TestOntDocumentManager.assertTrue(ontDocumentManager.getCacheModels());
        TestOntDocumentManager.assertTrue(ontDocumentManager.useDeclaredPrefixes());
        ontDocumentManager.setUseDeclaredPrefixes(false);
        TestOntDocumentManager.assertFalse(ontDocumentManager.useDeclaredPrefixes());
        ontDocumentManager.reset();
        TestOntDocumentManager.assertTrue(ontDocumentManager.useDeclaredPrefixes());
    }

    public void testConfigure() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource();
        model.add(resource, RDF.type, OntDocManagerVocab.DocumentManagerPolicy);
        model.add(resource, OntDocManagerVocab.cacheModels, false);
        OntDocumentManager ontDocumentManager = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue(ontDocumentManager.getCacheModels());
        ontDocumentManager.configure(model);
        TestOntDocumentManager.assertFalse("Docmgr configure() should have updated cache models flag", ontDocumentManager.getCacheModels());
    }

    public void testManualAssociation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager((String)null);
        ontDocumentManager.addPrefixMapping("http://www.w3.org/2002/07/owl#", "owl");
        TestOntDocumentManager.assertEquals("prefix for owl not correct", "owl", ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertEquals("URI for owl not correct", "http://www.w3.org/2002/07/owl#", ontDocumentManager.getURIForPrefix("owl"));
        ontDocumentManager.addAltEntry("http://www.w3.org/2002/07/owl", "file:foo.bar");
        TestOntDocumentManager.assertEquals("Failed to retrieve cache location", "file:foo.bar", ontDocumentManager.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        ontDocumentManager.addLanguageEntry("http://www.w3.org/2002/07/owl", "http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals("Failed to retrieve language", "http://www.w3.org/2002/07/owl", ontDocumentManager.getLanguage("http://www.w3.org/2002/07/owl"));
    }

    public void testIgnoreImport() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        ontDocumentManager.addIgnoreImport("file:testing/ontology/testImport3/c.owl");
        OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, ProfileRegistry.OWL_LANG);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        TestOntDocumentManager.assertNotNull("Ontology model should not be null", ontModel);
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(ontModel));
    }

    public void testRemoveImport1() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport3/c.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse("c should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testRemoveImport2() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport3/b.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 1, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse("c should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testRemoveImport3() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
        TestOntDocumentManager.assertTrue("d should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        ontModel.getDocumentManager().unloadImport(ontModel, "file:testing/ontology/testImport6/b.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue("d should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
    }

    public void testDynamicImports1() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.add(resource, ontModel.getProfile().IMPORTS(), resource2);
        TestOntDocumentManager.assertEquals("Marker count not correct", 0, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse("c should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports2() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.setDynamicImports(true);
        ontModel.add(resource, ontModel.getProfile().IMPORTS(), resource2);
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports3() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertTrue("c should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        ontModel.setDynamicImports(true);
        Resource resource = ontModel.getResource("file:testing/ontology/testImport3/a.owl");
        Resource resource2 = ontModel.getResource("file:testing/ontology/testImport3/b.owl");
        ontModel.remove(ontModel.createStatement(resource, ontModel.getProfile().IMPORTS(), resource2));
        TestOntDocumentManager.assertEquals("Marker count not correct", 1, TestOntDocumentManager.countMarkers(ontModel));
        TestOntDocumentManager.assertFalse("c should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", ontModel.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testSearchPath() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", ontDocumentManager.getLoadedPolicyURL());
        OntDocumentManager ontDocumentManager2 = new OntDocumentManager("file:etc/ont-policy-test.notexist.rdf;file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", ontDocumentManager2.getLoadedPolicyURL());
        OntDocumentManager ontDocumentManager3 = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertNull("Most recent policy should be null", ontDocumentManager3.getLoadedPolicyURL());
        ontDocumentManager3.setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", ontDocumentManager2.getLoadedPolicyURL());
        ontDocumentManager3.setMetadataSearchPath("file:etc/ont-policy-test.notexist.rdf", true);
        TestOntDocumentManager.assertNull("Most recent policy should be null", ontDocumentManager3.getLoadedPolicyURL());
    }

    public void testAddModel0() {
        OntDocumentManager ontDocumentManager = OntDocumentManager.getInstance();
        Model model = ModelFactory.createDefaultModel();
        String string = "http://example.com/test#m";
        TestOntDocumentManager.assertNull(ontDocumentManager.getModel(string));
        ontDocumentManager.addModel(string, model);
        TestOntDocumentManager.assertSame(model, ontDocumentManager.getModel(string));
    }

    public void testAddModel1() {
        OntDocumentManager ontDocumentManager = OntDocumentManager.getInstance();
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        String string = "http://example.com/test#m";
        TestOntDocumentManager.assertNull(ontDocumentManager.getModel(string));
        ontDocumentManager.addModel(string, model);
        ontDocumentManager.addModel(string, model2);
        TestOntDocumentManager.assertSame(model, ontDocumentManager.getModel(string));
        ontDocumentManager.addModel(string, model2, true);
        TestOntDocumentManager.assertSame(model2, ontDocumentManager.getModel(string));
    }

    public static int countMarkers(Model model) {
        int n = 0;
        Resource resource = model.getResource("http://jena.hpl.hp.com/2003/03/testont#Marker");
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, resource);
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        return n;
    }

    static class DocManagerImportTest
    extends TestCase {
        String m_dir;
        int m_count;
        String m_path;
        boolean m_processImports;

        DocManagerImportTest(String string, int n, boolean bl, String string2) {
            super(string);
            this.m_dir = string;
            this.m_count = n;
            this.m_path = string2;
            this.m_processImports = bl;
        }

        public void runTest() {
            OntDocumentManager ontDocumentManager = new OntDocumentManager();
            ontDocumentManager.setProcessImports(this.m_processImports);
            if (this.m_path != null) {
                ontDocumentManager.setMetadataSearchPath(this.m_path, true);
            }
            OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, ProfileRegistry.OWL_LANG);
            OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
            DocManagerImportTest.assertNotNull("Ontology model should not be null", ontModel);
            ontModel.read("file:" + this.m_dir + "/a.owl");
            DocManagerImportTest.assertEquals("Marker count not correct", this.m_count, TestOntDocumentManager.countMarkers(ontModel));
        }
    }
}

