/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import junit.framework.TestSuite;

public class TestOntology
extends OntTestBase {
    public static TestSuite suite() {
        return new TestOntology("TestOntology");
    }

    public TestOntology(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Ontology.imports", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Ontology ontology = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology ontology2 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology ontology3 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                ontology.addImport(ontology2);
                1.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.IMPORTS()));
                1.assertEquals("x should import y", ontology2, ontology.getImport());
                ontology.addImport(ontology3);
                1.assertEquals("Cardinality should be 2", 2, ontology.getCardinality(profile.IMPORTS()));
                this.iteratorTest(ontology.listImports(), new Object[]{ontology2, ontology3});
                ontology.setImport(ontology3);
                1.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.IMPORTS()));
                1.assertEquals("x should import z", ontology3, ontology.getImport());
                ontology.removeImport(ontology2);
                1.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.IMPORTS()));
                ontology.removeImport(ontology3);
                1.assertEquals("Cardinality should be 0", 0, ontology.getCardinality(profile.IMPORTS()));
            }
        }, new OntTestBase.OntTestCase("Ontology.backwardCompatibleWith", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Ontology ontology = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology ontology2 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology ontology3 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                ontology.addBackwardCompatibleWith(ontology2);
                2.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals("x should be back comp with y", ontology2, ontology.getBackwardCompatibleWith());
                ontology.addBackwardCompatibleWith(ontology3);
                2.assertEquals("Cardinality should be 2", 2, ontology.getCardinality(profile.BACKWARD_COMPATIBLE_WITH()));
                this.iteratorTest(ontology.listBackwardCompatibleWith(), new Object[]{ontology2, ontology3});
                ontology.setBackwardCompatibleWith(ontology3);
                2.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals("x should be back comp with z", ontology3, ontology.getBackwardCompatibleWith());
                ontology.removeBackwardCompatibleWith(ontology2);
                2.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.BACKWARD_COMPATIBLE_WITH()));
                ontology.removeBackwardCompatibleWith(ontology3);
                2.assertEquals("Cardinality should be 0", 0, ontology.getCardinality(profile.BACKWARD_COMPATIBLE_WITH()));
            }
        }, new OntTestBase.OntTestCase("Ontology.priorVersion", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Ontology ontology = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology ontology2 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology ontology3 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                ontology.addPriorVersion(ontology2);
                3.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.PRIOR_VERSION()));
                3.assertEquals("x should have prior y", ontology2, ontology.getPriorVersion());
                ontology.addPriorVersion(ontology3);
                3.assertEquals("Cardinality should be 2", 2, ontology.getCardinality(profile.PRIOR_VERSION()));
                this.iteratorTest(ontology.listPriorVersion(), new Object[]{ontology2, ontology3});
                ontology.setPriorVersion(ontology3);
                3.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.PRIOR_VERSION()));
                3.assertEquals("x should have prior z", ontology3, ontology.getPriorVersion());
                ontology.removePriorVersion(ontology2);
                3.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.PRIOR_VERSION()));
                ontology.removePriorVersion(ontology3);
                3.assertEquals("Cardinality should be 0", 0, ontology.getCardinality(profile.PRIOR_VERSION()));
            }
        }, new OntTestBase.OntTestCase("Ontology.incompatibleWith", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                Ontology ontology = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology ontology2 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology ontology3 = ontModel.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                ontology.addIncompatibleWith(ontology2);
                4.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.INCOMPATIBLE_WITH()));
                4.assertEquals("x should be in comp with y", ontology2, ontology.getIncompatibleWith());
                ontology.addIncompatibleWith(ontology3);
                4.assertEquals("Cardinality should be 2", 2, ontology.getCardinality(profile.INCOMPATIBLE_WITH()));
                this.iteratorTest(ontology.listIncompatibleWith(), new Object[]{ontology2, ontology3});
                ontology.setIncompatibleWith(ontology3);
                4.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.INCOMPATIBLE_WITH()));
                4.assertEquals("x should be incomp with z", ontology3, ontology.getIncompatibleWith());
                ontology.removeIncompatibleWith(ontology2);
                4.assertEquals("Cardinality should be 1", 1, ontology.getCardinality(profile.INCOMPATIBLE_WITH()));
                ontology.removeIncompatibleWith(ontology3);
                4.assertEquals("Cardinality should be 0", 0, ontology.getCardinality(profile.INCOMPATIBLE_WITH()));
            }
        }};
    }
}

