/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestResource
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;

    public static TestSuite suite() {
        return new TestResource("TestResource");
    }

    public TestResource(String string) {
        super(string);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntResource.sameAs", true, false, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource3 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addSameAs(ontResource2);
                1.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SAME_AS()));
                1.assertEquals("a should be sameAs b", ontResource2, ontResource.getSameAs());
                ontResource.addSameAs(ontResource3);
                1.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.SAME_AS()));
                this.iteratorTest(ontResource.listSameAs(), new Object[]{ontResource2, ontResource3});
                1.assertTrue("a should be the same as b", ontResource.isSameAs(ontResource2));
                1.assertTrue("a should be the same as c", ontResource.isSameAs(ontResource3));
                ontResource.setSameAs(ontResource2);
                1.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SAME_AS()));
                1.assertEquals("a should be sameAs b", ontResource2, ontResource.getSameAs());
                ontResource.removeSameAs(ontResource3);
                1.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SAME_AS()));
                ontResource.removeSameAs(ontResource2);
                1.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.SAME_AS()));
            }
        }, new OntTestBase.OntTestCase("OntResource.differentFrom", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource3 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addDifferentFrom(ontResource2);
                2.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.DIFFERENT_FROM()));
                2.assertEquals("a should be differentFrom b", ontResource2, ontResource.getDifferentFrom());
                ontResource.addDifferentFrom(ontResource3);
                2.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.DIFFERENT_FROM()));
                this.iteratorTest(ontResource.listDifferentFrom(), new Object[]{ontResource2, ontResource3});
                2.assertTrue("a should be diff from b", ontResource.isDifferentFrom(ontResource2));
                2.assertTrue("a should be diff from c", ontResource.isDifferentFrom(ontResource3));
                ontResource.setDifferentFrom(ontResource2);
                2.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.DIFFERENT_FROM()));
                2.assertEquals("a should be differentFrom b", ontResource2, ontResource.getDifferentFrom());
                ontResource.removeDifferentFrom(ontResource3);
                2.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.DIFFERENT_FROM()));
                ontResource.removeDifferentFrom(ontResource2);
                2.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.DIFFERENT_FROM()));
            }
        }, new OntTestBase.OntTestCase("OntResource.seeAlso", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource3 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addSeeAlso(ontResource2);
                3.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SEE_ALSO()));
                3.assertEquals("a should be seeAlso b", ontResource2, ontResource.getSeeAlso());
                ontResource.addSeeAlso(ontResource3);
                3.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.SEE_ALSO()));
                this.iteratorTest(ontResource.listSeeAlso(), new Object[]{ontResource2, ontResource3});
                3.assertTrue("a should have seeAlso b", ontResource.hasSeeAlso(ontResource2));
                3.assertTrue("a should have seeAlso c", ontResource.hasSeeAlso(ontResource3));
                ontResource.setSeeAlso(ontResource2);
                3.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SEE_ALSO()));
                3.assertEquals("a should be seeAlso b", ontResource2, ontResource.getSeeAlso());
                ontResource.removeSeeAlso(ontResource3);
                3.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.SEE_ALSO()));
                ontResource.removeSeeAlso(ontResource2);
                3.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.SEE_ALSO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.isDefinedBy", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource2 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource ontResource3 = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addIsDefinedBy(ontResource2);
                4.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.IS_DEFINED_BY()));
                4.assertEquals("a should be isDefinedBy b", ontResource2, ontResource.getIsDefinedBy());
                ontResource.addIsDefinedBy(ontResource3);
                4.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.IS_DEFINED_BY()));
                this.iteratorTest(ontResource.listIsDefinedBy(), new Object[]{ontResource2, ontResource3});
                4.assertTrue("a should be defined by b", ontResource.isDefinedBy(ontResource2));
                4.assertTrue("a should be defined by c", ontResource.isDefinedBy(ontResource3));
                ontResource.setIsDefinedBy(ontResource2);
                4.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.IS_DEFINED_BY()));
                4.assertEquals("a should be isDefinedBy b", ontResource2, ontResource.getIsDefinedBy());
                ontResource.removeDefinedBy(ontResource3);
                4.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.IS_DEFINED_BY()));
                ontResource.removeDefinedBy(ontResource2);
                4.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.IS_DEFINED_BY()));
            }
        }, new OntTestBase.OntTestCase("OntResource.versionInfo", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addVersionInfo("some info");
                5.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.VERSION_INFO()));
                5.assertEquals("a has wrong version info", "some info", ontResource.getVersionInfo());
                ontResource.addVersionInfo("more info");
                5.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.VERSION_INFO()));
                this.iteratorTest(ontResource.listVersionInfo(), new Object[]{"some info", "more info"});
                5.assertTrue("a should have some info", ontResource.hasVersionInfo("some info"));
                5.assertTrue("a should have more info", ontResource.hasVersionInfo("more info"));
                ontResource.setVersionInfo("new info");
                5.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.VERSION_INFO()));
                5.assertEquals("a has wrong version info", "new info", ontResource.getVersionInfo());
                ontResource.removeVersionInfo("old info");
                5.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.VERSION_INFO()));
                ontResource.removeVersionInfo("new info");
                5.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.VERSION_INFO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.nolang", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addLabel("some info", null);
                6.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.LABEL()));
                6.assertEquals("a has wrong label", "some info", ontResource.getLabel(null));
                ontResource.addLabel("more info", null);
                6.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.LABEL()));
                this.iteratorTest(ontResource.listLabels(null), new Object[]{ontModel.createLiteral("some info"), ontModel.createLiteral("more info")});
                6.assertTrue("a should have label some info", ontResource.hasLabel("some info", null));
                6.assertTrue("a should have label more info", ontResource.hasLabel("more info", null));
                ontResource.setLabel("new info", null);
                6.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.LABEL()));
                6.assertEquals("a has wrong label", "new info", ontResource.getLabel(null));
                ontResource.removeLabel("foo", null);
                6.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.LABEL()));
                ontResource.removeLabel("new info", null);
                6.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.lang", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addLabel("good", "EN");
                7.assertEquals("wrong label", "good", ontResource.getLabel(null));
                ontResource.addLabel("bon", "FR");
                7.assertEquals("wrong label", "good", ontResource.getLabel("EN"));
                7.assertEquals("wrong label", null, ontResource.getLabel("EN-GB"));
                7.assertEquals("wrong label", "bon", ontResource.getLabel("FR"));
                7.assertTrue("a should have label good", ontResource.hasLabel("good", "EN"));
                7.assertTrue("a should have label bon", ontResource.hasLabel("bon", "FR"));
                7.assertTrue("a should note have label good (DE)", !ontResource.hasLabel("good", "DE"));
                ontResource.addLabel("spiffing", "EN-GB");
                ontResource.addLabel("duude", "EN-US");
                7.assertEquals("wrong label", "spiffing", ontResource.getLabel("EN-GB"));
                7.assertEquals("wrong label", "duude", ontResource.getLabel("EN-US"));
                7.assertEquals("wrong label", null, ontResource.getLabel("DE"));
                ontResource.addLabel("abcdef", "AB-CD");
                7.assertEquals("wrong label", "abcdef", ontResource.getLabel("AB"));
                7.assertEquals("wrong label", null, ontResource.getLabel("AB-XY"));
                ontResource.removeLabel("abcde", "AB-CD");
                7.assertEquals("Cardinality should be 5", 5, ontResource.getCardinality(ontResource.getProfile().LABEL()));
                ontResource.removeLabel("abcdef", "AB-CD");
                7.assertEquals("Cardinality should be 4", 4, ontResource.getCardinality(ontResource.getProfile().LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.nolang", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Profile profile = ontModel.getProfile();
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addComment("some info", null);
                8.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.COMMENT()));
                8.assertEquals("a has wrong comment", "some info", ontResource.getComment(null));
                ontResource.addComment("more info", null);
                8.assertEquals("Cardinality should be 2", 2, ontResource.getCardinality(profile.COMMENT()));
                this.iteratorTest(ontResource.listComments(null), new Object[]{ontModel.createLiteral("some info"), ontModel.createLiteral("more info")});
                8.assertTrue("a should have comment some info", ontResource.hasComment("some info", null));
                8.assertTrue("a should have comment more info", ontResource.hasComment("more info", null));
                ontResource.setComment("new info", null);
                8.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.COMMENT()));
                8.assertEquals("a has wrong comment", "new info", ontResource.getComment(null));
                ontResource.removeComment("foo", null);
                8.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(profile.COMMENT()));
                ontResource.removeComment("new info", null);
                8.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(profile.COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.lang", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                ontResource.addComment("good", "EN");
                9.assertEquals("wrong comment", "good", ontResource.getComment(null));
                ontResource.addComment("bon", "FR");
                9.assertEquals("wrong comment", "good", ontResource.getComment("EN"));
                9.assertEquals("wrong comment", null, ontResource.getComment("EN-GB"));
                9.assertEquals("wrong comment", "bon", ontResource.getComment("FR"));
                9.assertTrue("a should have label good", ontResource.hasComment("good", "EN"));
                9.assertTrue("a should have label bon", ontResource.hasComment("bon", "FR"));
                9.assertTrue("a should note have label good (DE)", !ontResource.hasComment("good", "DE"));
                ontResource.addComment("spiffing", "EN-GB");
                ontResource.addComment("duude", "EN-US");
                9.assertEquals("wrong comment", "spiffing", ontResource.getComment("EN-GB"));
                9.assertEquals("wrong comment", "duude", ontResource.getComment("EN-US"));
                9.assertEquals("wrong comment", null, ontResource.getComment("DE"));
                ontResource.addComment("abcdef", "AB-CD");
                9.assertEquals("wrong comment", "abcdef", ontResource.getComment("AB"));
                9.assertEquals("wrong comment", null, ontResource.getComment("AB-XY"));
                ontResource.removeComment("abcde", "AB-CD");
                9.assertEquals("Cardinality should be 5", 5, ontResource.getCardinality(ontResource.getProfile().COMMENT()));
                ontResource.removeComment("abcdef", "AB-CD");
                9.assertEquals("Cardinality should be 4", 4, ontResource.getCardinality(ontResource.getProfile().COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.type (no inference)", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ontClass.addSubClass(ontClass2);
                OntResource ontResource = (OntResource)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                10.assertEquals("Cardinality of rdf:type is wrong", 0, ontResource.getCardinality(RDF.type));
                ontResource.addRDFType(ontClass2);
                10.assertEquals("rdf:type of a is wrong", ontClass2, ontResource.getRDFType());
                10.assertEquals("rdf:type of a is wrong", ontClass2, ontResource.getRDFType(false));
                this.iteratorTest(ontResource.listRDFTypes(false), new Object[]{ontClass2});
                this.iteratorTest(ontResource.listRDFTypes(true), new Object[]{ontClass2});
                ontResource.addRDFType(ontClass);
                this.iteratorTest(ontResource.listRDFTypes(false), new Object[]{ontClass, ontClass2});
                this.iteratorTest(ontResource.listRDFTypes(true), new Object[]{ontClass2});
                10.assertTrue("a should not be of class A direct", !ontResource.hasRDFType(ontClass, true));
                10.assertTrue("a should not be of class B direct", ontResource.hasRDFType(ontClass2, true));
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                ontResource.setRDFType(ontClass3);
                10.assertTrue("a should be of class C", ontResource.hasRDFType(ontClass3, false));
                10.assertTrue("a should not be of class A", !ontResource.hasRDFType(ontClass, false));
                10.assertTrue("a should not be of class B", !ontResource.hasRDFType(ontClass2, false));
                ontResource.removeRDFType(ontClass2);
                10.assertEquals("Cardinality should be 1", 1, ontResource.getCardinality(RDF.type));
                ontResource.removeRDFType(ontClass3);
                10.assertEquals("Cardinality should be 0", 0, ontResource.getCardinality(RDF.type));
            }
        }, new OntTestBase.OntTestCase("OntResource.remove", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#D");
                OntClass ontClass5 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#E");
                ontClass.addSubClass(ontClass2);
                ontClass.addSubClass(ontClass3);
                ontClass3.addSubClass(ontClass4);
                ontClass3.addSubClass(ontClass5);
                11.assertTrue("super-class of E", ontClass5.hasSuperClass(ontClass3, false));
                this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass2, ontClass3});
                ontClass3.remove();
                11.assertTrue("super-class of D", !ontClass4.hasSuperClass(ontClass3, false));
                11.assertTrue("super-class of E", !ontClass5.hasSuperClass(ontClass3, false));
                this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass2});
            }
        }, new OntTestBase.OntTestCase("OntResource.asClass", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().CLASS());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                boolean bl = this.owlFull();
                12.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                12.assertFalse("should not be all different", ontResource.isAllDifferent());
                12.assertTrue("should be class", ontResource.isClass());
                12.assertFalse("should not be property", ontResource.isProperty());
                12.assertFalse("should not be object property", ontResource.isObjectProperty());
                12.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                12.assertTrue("should not be individual", this.owlFull() || !ontResource.isIndividual());
                12.assertFalse("should not be data range", ontResource.isDataRange());
                12.assertFalse("should not be ontology", ontResource.isOntology());
                OntClass ontClass = ontResource.asClass();
                12.assertTrue("Should be OntClass", ontClass instanceof OntClass);
            }
        }, new OntTestBase.OntTestCase("OntResource.asAnnotationProperty", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().ANNOTATION_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().ANNOTATION_PROPERTY());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                13.assertTrue("should be annotation prop", ontResource.isAnnotationProperty());
                13.assertFalse("should not be all different", ontResource.isAllDifferent());
                13.assertFalse("should not be class", ontResource.isClass());
                13.assertTrue("should be property", ontResource.isProperty());
                13.assertFalse("should not be object property", ontResource.isObjectProperty());
                13.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                13.assertFalse("should not be individual", ontResource.isIndividual());
                13.assertFalse("should not be data range", ontResource.isDataRange());
                13.assertFalse("should not be ontology", ontResource.isOntology());
                AnnotationProperty annotationProperty = ontResource.asAnnotationProperty();
                13.assertTrue("Should be AnnotationProperty", annotationProperty instanceof AnnotationProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asObjectProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().OBJECT_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().OBJECT_PROPERTY());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                14.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                14.assertFalse("should not be all different", ontResource.isAllDifferent());
                14.assertFalse("should not be class", ontResource.isClass());
                14.assertTrue("should be property", ontResource.isProperty());
                14.assertTrue("should be object property", ontResource.isObjectProperty());
                14.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                14.assertFalse("should not be individual", ontResource.isIndividual());
                14.assertFalse("should not be data range", ontResource.isDataRange());
                14.assertFalse("should not be ontology", ontResource.isOntology());
                ObjectProperty objectProperty = ontResource.asObjectProperty();
                14.assertTrue("Should be ObjectProperty", objectProperty instanceof ObjectProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().DATATYPE_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().DATATYPE_PROPERTY());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                15.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                15.assertFalse("should not be all different", ontResource.isAllDifferent());
                15.assertFalse("should not be class", ontResource.isClass());
                15.assertTrue("should be property", ontResource.isProperty());
                15.assertFalse("should not be object property", ontResource.isObjectProperty());
                15.assertTrue("should be datatype property", ontResource.isDatatypeProperty());
                15.assertFalse("should not be individual", ontResource.isIndividual());
                15.assertFalse("should not be data range", ontResource.isDataRange());
                15.assertFalse("should not be ontology", ontResource.isOntology());
                DatatypeProperty datatypeProperty = ontResource.asDatatypeProperty();
                15.assertTrue("Should be DatatypeProperty", datatypeProperty instanceof DatatypeProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asAllDifferent", true, true, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().ALL_DIFFERENT() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().ALL_DIFFERENT());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                16.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                16.assertTrue("should be all different", ontResource.isAllDifferent());
                16.assertFalse("should not be class", ontResource.isClass());
                16.assertFalse("should not be property", ontResource.isProperty());
                16.assertFalse("should not be object property", ontResource.isObjectProperty());
                16.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                16.assertFalse("should not be individual", ontResource.isIndividual());
                16.assertFalse("should not be data range", ontResource.isDataRange());
                16.assertFalse("should not be ontology", ontResource.isOntology());
                AllDifferent allDifferent = ontResource.asAllDifferent();
                16.assertTrue("Should be AnnotationProperty", allDifferent instanceof AllDifferent);
            }
        }, new OntTestBase.OntTestCase("OntResource.asProperty", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().PROPERTY());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                17.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                17.assertFalse("should not be all different", ontResource.isAllDifferent());
                17.assertFalse("should not be class", ontResource.isClass());
                17.assertTrue("should be property", ontResource.isProperty());
                17.assertFalse("should not be object property", ontResource.isObjectProperty());
                17.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                17.assertFalse("should not be individual", ontResource.isIndividual());
                17.assertFalse("should not be data range", ontResource.isDataRange());
                17.assertFalse("should not be ontology", ontResource.isOntology());
                OntProperty ontProperty = ontResource.asProperty();
                17.assertTrue("Should be OntProperty", ontProperty instanceof OntProperty);
            }
        }, new OntTestBase.OntTestCase("OntResource.asIndividual", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                Resource resource = ontModel.createResource();
                Resource resource2 = ontModel.createResource();
                resource2.addProperty(RDF.type, ontModel.getProfile().CLASS());
                resource.addProperty(RDF.type, resource2);
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                18.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                18.assertFalse("should not be all different", ontResource.isAllDifferent());
                18.assertFalse("should not be class", ontResource.isClass());
                18.assertFalse("should not be property", ontResource.isProperty());
                18.assertFalse("should not be object property", ontResource.isObjectProperty());
                18.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                18.assertTrue("should be individual", ontResource.isIndividual());
                18.assertFalse("should not be data range", ontResource.isDataRange());
                18.assertFalse("should not be ontology", ontResource.isOntology());
                Individual individual = ontResource.asIndividual();
                18.assertTrue("Should be individual", individual instanceof Individual);
            }
        }, new OntTestBase.OntTestCase("OntResource.asDataRange", true, false, false, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().DATARANGE() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().DATARANGE());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                19.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                19.assertFalse("should not be all different", ontResource.isAllDifferent());
                19.assertFalse("should not be class", ontResource.isClass());
                19.assertFalse("should not be property", ontResource.isProperty());
                19.assertFalse("should not be object property", ontResource.isObjectProperty());
                19.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                19.assertFalse("should not be individual", ontResource.isIndividual());
                19.assertTrue("should be data range", ontResource.isDataRange());
                19.assertFalse("should not be ontology", ontResource.isOntology());
                DataRange dataRange = ontResource.asDataRange();
                19.assertTrue("Should be DataRange", dataRange instanceof DataRange);
            }
        }, new OntTestBase.OntTestCase("OntResource.asOntology", true, true, true, false){

            public void ontTest(OntModel ontModel) throws Exception {
                if (ontModel.getProfile().ONTOLOGY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource resource = ontModel.createResource();
                resource.addProperty(RDF.type, ontModel.getProfile().ONTOLOGY());
                OntResource ontResource = (OntResource)resource.as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                20.assertFalse("should not be annotation prop", ontResource.isAnnotationProperty());
                20.assertFalse("should not be all different", ontResource.isAllDifferent());
                20.assertFalse("should not be class", ontResource.isClass());
                20.assertFalse("should not be property", ontResource.isProperty());
                20.assertFalse("should not be object property", ontResource.isObjectProperty());
                20.assertFalse("should not be datatype property", ontResource.isDatatypeProperty());
                20.assertFalse("should not be individual", ontResource.isIndividual());
                20.assertFalse("should not be data range", ontResource.isDataRange());
                20.assertTrue("should be ontology", ontResource.isOntology());
                Ontology ontology = ontResource.asOntology();
                20.assertTrue("Should be Ontology", ontology instanceof Ontology);
            }
        }, new OntTestBase.OntTestCase("OntResource.isLanguageTerm", true, true, true, true){

            public void ontTest(OntModel ontModel) throws Exception {
                OntResource ontResource = (OntResource)ontModel.getProfile().CLASS().inModel(ontModel).as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestResource.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                21.assertTrue("should be a lang term", ontResource.isOntLanguageTerm());
                ontResource = ontModel.createOntResource("http://foo/bar");
                21.assertFalse("should not be a lang term", ontResource.isOntLanguageTerm());
            }
        }};
    }
}

