/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPConfig;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.ExtendedHandler;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.SingleThreadedParser;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ARP
implements ARPConfig {
    private final SingleThreadedParser arpf = SingleThreadedParser.create();

    public Locator getLocator() {
        return this.arpf.getLocator();
    }

    public void load(Reader reader, String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        this.arpf.parse(inputSource);
    }

    void load(InputSource inputSource) throws SAXException, IOException {
        this.arpf.parse(inputSource);
    }

    public void load(InputStream inputStream, String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.arpf.parse(inputSource, string);
    }

    public void load(InputStream inputStream) throws SAXException, IOException {
        this.load(inputStream, "");
    }

    public void load(Reader reader) throws SAXException, IOException {
        this.load(reader, "");
    }

    public ARPHandlers getHandlers() {
        return this.arpf.getHandlers();
    }

    public void setHandlersWith(ARPHandlers aRPHandlers) {
        this.arpf.setHandlersWith(aRPHandlers);
    }

    public ARPOptions getOptions() {
        return this.arpf.getOptions();
    }

    public void setOptionsWith(ARPOptions aRPOptions) {
        this.arpf.setOptionsWith(aRPOptions);
    }

    public ExtendedHandler setExtendedHandler(ExtendedHandler extendedHandler) {
        return this.getHandlers().setExtendedHandler(extendedHandler);
    }

    public NamespaceHandler setNamespaceHandler(NamespaceHandler namespaceHandler) {
        return this.getHandlers().setNamespaceHandler(namespaceHandler);
    }

    public StatementHandler setStatementHandler(StatementHandler statementHandler) {
        return this.getHandlers().setStatementHandler(statementHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getHandlers().setErrorHandler(errorHandler);
    }

    public int setErrorMode(int n, int n2) {
        return this.getOptions().setErrorMode(n, n2);
    }

    public void setDefaultErrorMode() {
        this.getOptions().setDefaultErrorMode();
    }

    public void setLaxErrorMode() {
        this.getOptions().setLaxErrorMode();
    }

    public void setStrictErrorMode() {
        this.getOptions().setStrictErrorMode();
    }

    public void setStrictErrorMode(int n) {
        this.getOptions().setStrictErrorMode(n);
    }

    public void setEmbedding(boolean bl) {
        this.getOptions().setEmbedding(bl);
    }
}

