/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.JenaHandler;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.SAX2RDF;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import org.xml.sax.SAXException;

public class SAX2Model
extends SAX2RDF {
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private final JenaHandler handler;
    private boolean closed = false;

    public static SAX2Model newInstance(String string, Model model) throws MalformedURIException {
        return new SAX2Model(string, model, "");
    }

    public static SAX2Model newInstance(String string, Model model, String string2) throws MalformedURIException {
        return new SAX2Model(string, model, string2);
    }

    public void startPrefixMapping(String string, String string2) {
        super.startPrefixMapping(string, string2);
    }

    protected SAX2Model(String string, Model model, String string2) throws MalformedURIException {
        super(string, string2);
        this.handler = new JenaHandler(model, this.errorHandler);
        this.handler.useWith(this.getHandlers());
    }

    public void close() throws SAXException {
        if (!this.closed) {
            super.close();
            this.handler.bulkUpdate();
            this.closed = true;
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        if (this.handler != null) {
            this.handler.setErrorHandler(rDFErrorHandler);
        }
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) throws JenaException {
        Object object2 = object;
        if (string.startsWith("http:") && string.startsWith("http://jena.hpl.hp.com/arp/properties/")) {
            string = string.substring(JenaReader.arpPropertiesURLLength);
        }
        return this.setArpProperty(string, object2);
    }

    private Object setArpProperty(String string, Object object) {
        return JenaReader.setArpProperty(this.getOptions(), string, object, this.errorHandler);
    }
}

