/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.RelativeURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.rdf.arp.XMLHandler;
import java.util.Map;

class XMLNullContext
extends XMLContext
implements ARPErrorNumbers {
    final XMLHandler forErrors;
    final int errno;
    final String errmsg;

    XMLNullContext(XMLHandler xMLHandler, int n) {
        super(null, null);
        this.forErrors = xMLHandler;
        this.errno = n;
        this.errmsg = n == 211 ? "Base URI is null, but there are relative URIs to resolve." : "Base URI is \"\", relative URIs left as relative.";
    }

    private XMLNullContext(XMLContext xMLContext, URI uRI, String string, String string2, Map map, XMLNullContext xMLNullContext) {
        super(xMLContext, uRI, string, string2, map);
        this.forErrors = xMLNullContext.forErrors;
        this.errno = xMLNullContext.errno;
        this.errmsg = xMLNullContext.errmsg;
    }

    XMLContext clone(XMLContext xMLContext, URI uRI, String string, String string2, Map map) {
        return new XMLNullContext(xMLContext, uRI, string, string2, map, this);
    }

    String resolve(Location location, String string) throws MalformedURIException, ParseException {
        try {
            URI uRI = new URI(string);
            return uRI.getURIString();
        }
        catch (RelativeURIException relativeURIException) {
            this.forErrors.parseWarning(this.errno, location, this.errmsg);
            return string;
        }
    }

    String resolveSameDocRef(Location location, String string) throws ParseException {
        this.forErrors.parseWarning(this.errno, location, this.errmsg);
        return string;
    }

    boolean isSameAsDocument() {
        return this == this.document;
    }
}

