/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ExceptionTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    public static Test suite() {
        TestSuite testSuite = new TestSuite("ARP Exceptions");
        testSuite.addTest(new ExceptionTests("testDefaultFatal"));
        testSuite.addTest(new ExceptionTests("testDefaultError"));
        testSuite.addTest(new ExceptionTests("testDefaultWarning"));
        testSuite.addTest(new ExceptionTests("testDefaultDemotedFatal"));
        testSuite.addTest(new ExceptionTests("testDefaultPromotedError"));
        testSuite.addTest(new ExceptionTests("testDefaultPromotedWarning"));
        testSuite.addTest(new ExceptionTests("testNonExceptionFatal"));
        testSuite.addTest(new ExceptionTests("testExceptionError"));
        testSuite.addTest(new ExceptionTests("testExceptionWarning"));
        return testSuite;
    }

    ExceptionTests(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultFatal() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/arp/error-msgs/test06.rdf");
            ExceptionTests.fail("Fatal error did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultError() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/wg/rdfms-abouteach/error002.rdf");
        }
        catch (JenaException jenaException) {
            ExceptionTests.fail("Error threw exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultWarning() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            model.read("file:testing/arp/qname-in-ID/bug74_0.rdf");
        }
        catch (JenaException jenaException) {
            ExceptionTests.fail("Warning threw exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultDemotedFatal() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setProperty("ERR_SAX_FATAL_ERROR", "EM_ERROR");
            rDFReader.read(model, "file:testing/arp/error-msgs/test06.rdf");
        }
        catch (JenaException jenaException) {
            ExceptionTests.fail("Demoted fatal error threw an exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultPromotedError() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setProperty("ERR_BAD_RDF_ATTRIBUTE", "EM_FATAL");
            rDFReader.read(model, "file:testing/wg/rdfms-abouteach/error002.rdf");
            ExceptionTests.fail("Promoted error did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultPromotedWarning() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setProperty("WARN_BAD_NAME", "EM_FATAL");
            rDFReader.read(model, "file:testing/arp/qname-in-ID/bug74_0.rdf");
            ExceptionTests.fail("Promoted warning did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    public void testNonExceptionFatal() {
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setErrorHandler(this);
            rDFReader.read(model, "file:testing/arp/error-msgs/test06.rdf");
        }
        catch (JenaException jenaException) {
            ExceptionTests.fail("Fatal error threw an exception with non-exception handler");
        }
    }

    public void testExceptionError() {
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setErrorHandler(this);
            rDFReader.read(model, "file:testing/wg/rdfms-abouteach/error002.rdf");
            ExceptionTests.fail("Error did not throw exception with non-standard handler");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testExceptionWarning() {
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader();
            rDFReader.setErrorHandler(this);
            rDFReader.read(model, "file:testing/arp/qname-in-ID/bug74_0.rdf");
            ExceptionTests.fail("Warning did not throw exception with non-standard handler");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void warning(Exception exception) {
        throw new JenaException(exception);
    }

    public void error(Exception exception) {
        throw new JenaException(exception);
    }

    public void fatalError(Exception exception) {
    }
}

