/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.SAX2Model;
import com.hp.hpl.jena.rdf.arp.SAX2RDF;
import com.hp.hpl.jena.rdf.arp.test.SAX2RDFTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SAX2RDFMoreTests
extends TestCase {
    public SAX2RDFMoreTests(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLang() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        Model model2 = ModelFactory.createDefaultModel();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-xmllang/test004.rdf");
        SAX2RDFTest.RDFEHArray rDFEHArray = new SAX2RDFTest.RDFEHArray();
        RDFReader rDFReader = model.getReader();
        rDFReader.setErrorHandler(rDFEHArray);
        rDFReader.read(model, fileInputStream, "http://example.org/");
        ((InputStream)fileInputStream).close();
        fileInputStream = new FileInputStream("testing/wg/rdfms-xmllang/test003.rdf");
        SAX2RDFTest.RDFEHArray rDFEHArray2 = new SAX2RDFTest.RDFEHArray();
        SAXParser sAXParser = new SAXParser();
        SAX2Model sAX2Model = SAX2Model.newInstance("http://example.org/", model2, "fr");
        SAX2RDF.installHandlers(sAXParser, sAX2Model);
        sAX2Model.setErrorHandler(rDFEHArray2);
        InputSource inputSource = new InputSource(fileInputStream);
        inputSource.setSystemId("http://example.org/");
        try {
            try {
                sAXParser.parse(inputSource);
            }
            finally {
                sAX2Model.close();
            }
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
        ((InputStream)fileInputStream).close();
        if (rDFEHArray.v.size() == 0) {
            SAX2RDFMoreTests.assertTrue("Not isomorphic", model.isIsomorphicWith(model2));
        }
        SAX2RDFMoreTests.assertEquals("Different number of errors", rDFEHArray.v.size(), rDFEHArray2.v.size());
        Object[] objectArray = rDFEHArray.v.toArray();
        Object[] objectArray2 = rDFEHArray2.v.toArray();
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        for (int i = 0; i < rDFEHArray.v.size(); ++i) {
            SAX2RDFMoreTests.assertEquals("Error " + i + " different.", objectArray[i], objectArray2[i]);
        }
    }
}

