/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.Iterator;
import java.util.List;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    public ModelListenerAdapter(ModelCom modelCom, ModelChangedListener modelChangedListener) {
        this.m = modelCom;
        this.L = modelChangedListener;
    }

    public void notifyAddArray(Graph graph, Triple[] tripleArray) {
        this.L.addedStatements(this.m.asStatements(tripleArray));
    }

    public void notifyDeleteArray(Graph graph, Triple[] tripleArray) {
        this.L.removedStatements(this.m.asStatements(tripleArray));
    }

    public void notifyAddTriple(Graph graph, Triple triple) {
        this.L.addedStatement(this.m.asStatement(triple));
    }

    public void notifyAddList(Graph graph, List list) {
        this.L.addedStatements(this.m.asStatements(list));
    }

    public void notifyAddIterator(Graph graph, Iterator iterator) {
        this.L.addedStatements(this.m.asStatements(iterator));
    }

    public void notifyAddGraph(Graph graph, Graph graph2) {
        this.L.addedStatements(this.m.asModel(graph2));
    }

    public void notifyDeleteIterator(Graph graph, Iterator iterator) {
        this.L.removedStatements(this.m.asStatements(iterator));
    }

    public void notifyDeleteTriple(Graph graph, Triple triple) {
        this.L.removedStatement(this.m.asStatement(triple));
    }

    public void notifyAddIterator(Graph graph, List list) {
        this.L.addedStatements(this.m.asStatements(list));
    }

    public void notifyDeleteList(Graph graph, List list) {
        this.L.removedStatements(this.m.asStatements(list));
    }

    public void notifyDeleteGraph(Graph graph, Graph graph2) {
        this.L.removedStatements(this.m.asModel(graph2));
    }

    public void notifyEvent(Graph graph, Object object) {
        this.L.notifyEvent(this.m, object);
    }

    public boolean equals(Object object) {
        return object instanceof ModelListenerAdapter && ((ModelListenerAdapter)object).sameAs(this);
    }

    public boolean sameAs(ModelListenerAdapter modelListenerAdapter) {
        return this.L.equals(modelListenerAdapter.L) && this.m.equals(modelListenerAdapter.m);
    }
}

