/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTripleWriter
implements RDFWriter {
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    protected static Log logger = LogFactory.getLog(NTripleWriter.class);
    private static boolean[] okURIChars = new boolean[128];

    public void write(Model model, OutputStream outputStream, String string) {
        try {
            Writer writer;
            try {
                writer = new OutputStreamWriter(outputStream, "ascii");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.warn("ASCII is not supported: in NTripleWriter.write", unsupportedEncodingException);
                writer = FileUtils.asUTF8(outputStream);
            }
            this.write(model, writer, string);
            writer.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public void write(Model model, Writer writer, String string) {
        try {
            Model model2 = ModelFactory.withHiddenStatements(model);
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            StmtIterator stmtIterator = model2.listStatements();
            Statement statement = null;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                NTripleWriter.writeResource(statement.getSubject(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeResource(statement.getPredicate(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeNode(statement.getObject(), printWriter);
                printWriter.println(" .");
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public Object setProperty(String string, Object object) {
        throw new UnknownPropertyException(string);
    }

    public void setNsPrefix(String string, String string2) {
    }

    public String getPrefixFor(String string) {
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public static void write(Model model, PrintWriter printWriter) throws IOException {
        StmtIterator stmtIterator = model.listStatements();
        Statement statement = null;
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.nextStatement();
            NTripleWriter.writeResource(statement.getSubject(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeResource(statement.getPredicate(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeNode(statement.getObject(), printWriter);
            printWriter.println(" .");
        }
    }

    protected static void writeResource(Resource resource, PrintWriter printWriter) {
        if (resource.isAnon()) {
            printWriter.print(NTripleWriter.anonName(resource.getId()));
        } else {
            printWriter.print("<");
            NTripleWriter.writeURIString(resource.getURI(), printWriter);
            printWriter.print(">");
        }
    }

    private static void writeURIString(String string, PrintWriter printWriter) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < okURIChars.length && okURIChars[c]) {
                printWriter.print(c);
                continue;
            }
            String string2 = Integer.toHexString(c).toUpperCase();
            printWriter.print("\\u");
            for (int j = 4 - string2.length(); j > 0; --j) {
                printWriter.print("0");
            }
            printWriter.print(string2);
        }
    }

    private static void writeString(String string, PrintWriter printWriter) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                printWriter.print('\\');
                printWriter.print(c);
                continue;
            }
            if (c == '\n') {
                printWriter.print("\\n");
                continue;
            }
            if (c == '\r') {
                printWriter.print("\\r");
                continue;
            }
            if (c == '\t') {
                printWriter.print("\\t");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                printWriter.print(c);
                continue;
            }
            String string2 = Integer.toHexString(c).toUpperCase();
            printWriter.print("\\u");
            for (int j = 4 - string2.length(); j > 0; --j) {
                printWriter.print("0");
            }
            printWriter.print(string2);
        }
    }

    protected static void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string;
        String string2 = literal.getString();
        printWriter.print('\"');
        NTripleWriter.writeString(string2, printWriter);
        printWriter.print('\"');
        String string3 = literal.getLanguage();
        if (string3 != null && !string3.equals("")) {
            printWriter.print("@" + string3);
        }
        if ((string = literal.getDatatypeURI()) != null && !string.equals("")) {
            printWriter.print("^^<" + string + ">");
        }
    }

    protected static void writeNode(RDFNode rDFNode, PrintWriter printWriter) {
        if (rDFNode instanceof Literal) {
            NTripleWriter.writeLiteral((Literal)rDFNode, printWriter);
        } else {
            NTripleWriter.writeResource((Resource)rDFNode, printWriter);
        }
    }

    protected static String anonName(AnonId anonId) {
        String string = "_:A";
        String string2 = anonId.toString();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            string = c == 'X' ? string + "XX" : (Character.isLetterOrDigit(c) ? string + c : string + "X" + Integer.toHexString(c) + "X");
        }
        return string;
    }

    static {
        for (int i = 32; i < 127; ++i) {
            NTripleWriter.okURIChars[i] = true;
        }
        NTripleWriter.okURIChars[60] = false;
        NTripleWriter.okURIChars[62] = false;
        NTripleWriter.okURIChars[92] = false;
    }
}

