/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import java.util.Properties;

public class RDFWriterFImpl
implements RDFWriterF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N3", "N3-PP", "N3-PLAIN", "N3-TRIPLES", "N3-TRIPLE", "TURTLE"};
    protected static final String[] DEFAULTWRITERS = new String[]{"com.hp.hpl.jena.xmloutput.impl.Basic", "com.hp.hpl.jena.xmloutput.impl.Abbreviated", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "com.hp.hpl.jena.n3.N3JenaWriter", "com.hp.hpl.jena.n3.N3JenaWriterPP", "com.hp.hpl.jena.n3.N3JenaWriterPlain", "com.hp.hpl.jena.n3.N3JenaWriterTriples", "com.hp.hpl.jena.n3.N3JenaWriterTriples", "com.hp.hpl.jena.n3.TurtleJenaWriter"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "com.hp.hpl.jena.writer.";

    public RDFWriter getWriter() {
        return this.getWriter(DEFAULTLANG);
    }

    public RDFWriter getWriter(String string) {
        String string2;
        if (string == null || string.equals("")) {
            string = LANGS[0];
        }
        if ((string2 = langToClassName.getProperty(string)) == null || string2.equals("")) {
            throw new NoWriterForLangException(string);
        }
        try {
            return (RDFWriter)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public String setWriterClassName(String string, String string2) {
        String string3 = langToClassName.getProperty(string);
        langToClassName.setProperty(string, string2);
        return string3;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTWRITERS[i]));
        }
    }
}

