/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.Command;

public abstract class AbstractTestModel
extends ModelTestBase {
    private Model model;
    protected String[][] cases = new String[][]{{"x R y", "x R y", ""}, {"x R y; a P b", "x R y", "a P b"}, {"x R y; a P b", "?? R y", "a P b"}, {"x R y; a P b", "x R ??", "a P b"}, {"x R y; a P b", "x ?? y", "a P b"}, {"x R y; a P b", "?? ?? ??", ""}, {"x R y; a P b; c P d", "?? P ??", "x R y"}, {"x R y; a P b; x S y", "x ?? ??", "a P b"}};
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public AbstractTestModel(String string) {
        super(string);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
    }

    public void tearDown() {
        this.model.close();
    }

    public void testTransactions() {
        Command command = new Command(){

            public Object execute() {
                return null;
            }
        };
        if (this.model.supportsTransactions()) {
            this.model.executeInTransaction(command);
        }
    }

    public void testCreateResourceFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("spoo:S"));
        AbstractTestModel.assertTrue(rDFNode instanceof Resource);
        AbstractTestModel.assertEquals("spoo:S", ((Resource)rDFNode).getURI());
    }

    public void testCreateLiteralFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("42"));
        AbstractTestModel.assertTrue(rDFNode instanceof Literal);
        AbstractTestModel.assertEquals("42", ((Literal)rDFNode).getLexicalForm());
    }

    public void testCreateBlankFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("_Blank"));
        AbstractTestModel.assertTrue(rDFNode instanceof Resource);
        AbstractTestModel.assertEquals(new AnonId("_Blank"), ((Resource)rDFNode).getId());
    }

    public void testIsEmpty() {
        Statement statement = AbstractTestModel.statement(this.model, "model rdf:type nonEmpty");
        Statement statement2 = AbstractTestModel.statement(this.model, "pinky rdf:type Pig");
        AbstractTestModel.assertTrue(this.model.isEmpty());
        this.model.add(statement);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.add(statement2);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.remove(statement);
        AbstractTestModel.assertFalse(this.model.isEmpty());
        this.model.remove(statement2);
        AbstractTestModel.assertTrue(this.model.isEmpty());
    }

    public void testContainsResource() {
        AbstractTestModel.modelAdd(this.model, "x R y; _a P _b");
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "x")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "R")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "y")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "_a")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "P")));
        AbstractTestModel.assertTrue(this.model.containsResource(AbstractTestModel.resource(this.model, "_b")));
        AbstractTestModel.assertFalse(this.model.containsResource(AbstractTestModel.resource(this.model, "i")));
        AbstractTestModel.assertFalse(this.model.containsResource(AbstractTestModel.resource(this.model, "_j")));
    }

    public void testGetProperty() {
        AbstractTestModel.modelAdd(this.model, "x P a; x P b; x R c");
        Resource resource = AbstractTestModel.resource(this.model, "x");
        AbstractTestModel.assertEquals(AbstractTestModel.resource(this.model, "c"), resource.getProperty(AbstractTestModel.property(this.model, "R")).getObject());
        RDFNode rDFNode = resource.getProperty(AbstractTestModel.property(this.model, "P")).getObject();
        AbstractTestModel.assertTrue(rDFNode.equals(AbstractTestModel.resource(this.model, "a")) || rDFNode.equals(AbstractTestModel.resource(this.model, "b")));
        AbstractTestModel.assertNull(resource.getProperty(AbstractTestModel.property(this.model, "noSuchPropertyHere")));
    }

    public void testToStatement() {
        Triple triple = AbstractTestModel.triple("a P b");
        Statement statement = this.model.asStatement(triple);
        AbstractTestModel.assertEquals(AbstractTestModel.node("a"), statement.getSubject().asNode());
        AbstractTestModel.assertEquals(AbstractTestModel.node("P"), statement.getPredicate().asNode());
        AbstractTestModel.assertEquals(AbstractTestModel.node("b"), statement.getObject().asNode());
    }

    public void testAsRDF() {
        RDFNode rDFNode = this.model.asRDFNode(AbstractTestModel.node("a"));
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a RR b");
        this.testRemoveAll("x P y; a Q b; c R 17; _d S 'e'");
        this.testRemoveAll("subject Predicate 'object'; http://nowhere/x scheme:cunning not:plan");
    }

    protected void testRemoveAll(String string) {
        AbstractTestModel.modelAdd(this.model, string);
        AbstractTestModel.assertSame(this.model, this.model.removeAll());
        AbstractTestModel.assertEquals("model should have size 0 following removeAll(): ", 0L, this.model.size());
    }

    public void testRemoveSPO() {
        ModelCom modelCom = (ModelCom)ModelFactory.createDefaultModel();
        for (int i = 0; i < this.cases.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Model model = this.getModel();
                Model model2 = this.copy(model);
                AbstractTestModel.modelAdd(model, this.cases[i][0]);
                Triple triple = AbstractTestModel.triple(this.cases[i][1]);
                Node node = triple.getSubject();
                Node node2 = triple.getPredicate();
                Node node3 = triple.getObject();
                Resource resource = (Resource)(node.equals(Node.ANY) ? null : modelCom.getRDFNode(node));
                Property property = (Property)(node2.equals(Node.ANY) ? null : modelCom.getRDFNode(node2).as(class$com$hp$hpl$jena$rdf$model$Property == null ? AbstractTestModel.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property));
                RDFNode rDFNode = node3.equals(Node.ANY) ? null : modelCom.getRDFNode(node3);
                Model model3 = AbstractTestModel.modelWithStatements(this.cases[i][2]);
                model.removeAll(resource, property, rDFNode);
                Model model4 = this.copy(model).remove(model2);
                this.assertIsoModels(this.cases[i][1], model3, model4);
            }
        }
    }

    protected Model copy(Model model) {
        return ModelFactory.createDefaultModel().add(model);
    }
}

