/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Set;

public abstract class AbstractTestReifiedStatements
extends ModelTestBase {
    private Model model;
    private Resource S;
    private Property P;
    private RDFNode O;
    private Statement SPO;
    private Statement SPO2;
    private static final String aURI = "jena:test/reifying#someURI";
    private static final String anotherURI = "jena:test/reifying#anotherURI";
    private static final String anchor = "jena:test/Reifying#";
    protected static Set empty = CollectionFactory.createHashedSet();

    public AbstractTestReifiedStatements(String string) {
        super(string);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
        Resource resource = this.model.createResource("jena:test/Reifying#subject2");
        this.S = this.model.createResource("jena:test/Reifying#subject");
        this.P = this.model.createProperty("jena:test/Reifying#predicate");
        this.O = this.model.createLiteral("jena:test/Reifying#object");
        this.SPO = this.model.createStatement(this.S, this.P, this.O);
        this.SPO2 = this.model.createStatement(resource, this.P, this.O);
    }

    public void testBasicReification() {
        if (this.model.getReificationStyle() != ModelFactory.Minimal) {
            Resource resource = this.model.createResource(aURI);
            this.model.add(resource, RDF.type, RDF.Statement);
            this.model.add(resource, RDF.subject, this.S);
            this.model.add(resource, RDF.predicate, this.P);
            this.model.add(resource, RDF.object, this.O);
            RDFNode rDFNode = resource.as(ReifiedStatement.class);
            AbstractTestReifiedStatements.assertEquals("can recover statement", this.SPO, ((ReifiedStatement)rDFNode).getStatement());
        }
    }

    public void testReificationCombinations() {
        Resource resource = this.model.createResource(aURI);
        Resource resource2 = this.model.createResource(anotherURI);
        Property property = (Property)resource.as(Property.class);
        Object[][] objectArray = new Object[][]{{this.model.createStatement(resource, RDF.type, RDF.Statement), new Integer(1)}, {this.model.createStatement(resource, RDF.subject, resource2), new Integer(2)}, {this.model.createStatement(resource, RDF.predicate, property), new Integer(4)}, {this.model.createStatement(resource, RDF.object, this.O), new Integer(8)}, {this.model.createStatement(resource2, property, this.O), new Integer(16)}, {this.model.createStatement(resource, property, this.O), new Integer(32)}, {this.model.createStatement(resource2, RDF.subject, resource2), new Integer(64)}, {this.model.createStatement(resource2, RDF.predicate, property), new Integer(128)}, {this.model.createStatement(resource2, RDF.object, this.O), new Integer(256)}, {this.model.createStatement(resource2, RDF.type, RDF.Statement), new Integer(512)}};
        if (this.model.getReificationStyle() != ModelFactory.Minimal) {
            this.testCombinations(this.model, resource, 0, objectArray, objectArray.length);
        }
    }

    private void testCombinations(Model model, Resource resource, int n, Object[][] objectArray, int n2) {
        if (n2 == 0) {
            try {
                ReifiedStatement reifiedStatement = (ReifiedStatement)resource.as(ReifiedStatement.class);
                AbstractTestReifiedStatements.assertTrue("should not reify: not all components present [" + n + "]: " + reifiedStatement, (n & 0xF) == 15);
            }
            catch (DoesNotReifyException doesNotReifyException) {
                AbstractTestReifiedStatements.assertFalse("should reify: all components present", n == 15);
            }
        } else {
            int n4 = n2 - 1;
            Statement statement = (Statement)objectArray[n4][0];
            int n5 = (Integer)objectArray[n4][1];
            this.testCombinations(model, resource, n, objectArray, n4);
            model.add(statement);
            this.testCombinations(model, resource, n + n5, objectArray, n4);
            model.remove(statement);
        }
    }

    public void testThisWillBreak() {
        Resource resource = this.model.createResource(aURI);
        this.SPO.createReifiedStatement(aURI);
        this.model.add(resource, RDF.subject, resource);
    }

    public void testDirtyReification() {
        Resource resource = this.model.createResource(aURI);
        this.model.add(resource, RDF.type, RDF.Statement);
        this.model.add(resource, RDF.subject, this.S);
        this.model.add(resource, RDF.subject, this.P);
        this.testDoesNotReify("boo", resource);
    }

    public void testDoesNotReify(String string, Resource resource) {
        try {
            resource.as(ReifiedStatement.class);
            AbstractTestReifiedStatements.fail(string + " (" + resource + ")");
        }
        catch (DoesNotReifyException doesNotReifyException) {
            // empty catch block
        }
    }

    public void testConversion() {
        this.model.createReifiedStatement("spoo:handle", this.SPO);
        ReifiedStatement reifiedStatement = (ReifiedStatement)this.model.createResource("spoo:handle").as(ReifiedStatement.class);
        AbstractTestReifiedStatements.assertEquals("recover statement", this.SPO, reifiedStatement.getStatement());
    }

    public void testDoesNotReifyUnknown() {
        this.testDoesNotReify("model should not reify rubbish", this.model.createResource("spoo:rubbish"));
    }

    public void testConstructionByURI() {
        ReifiedStatement reifiedStatement = this.model.createReifiedStatement("spoo:handle", this.SPO);
        ReifiedStatement reifiedStatement2 = this.SPO.createReifiedStatement("spoo:gripper");
        AbstractTestReifiedStatements.assertEquals("recover statement (URI)", this.SPO, reifiedStatement.getStatement());
        AbstractTestReifiedStatements.assertEquals("recover URI", "spoo:handle", reifiedStatement.getURI());
        AbstractTestReifiedStatements.assertEquals("recover URI", "spoo:gripper", reifiedStatement2.getURI());
    }

    public void testStatementAndModel(String string, ReifiedStatement reifiedStatement, Model model, Statement statement) {
        AbstractTestReifiedStatements.assertEquals(string + ": recover statement", statement, reifiedStatement.getStatement());
        AbstractTestReifiedStatements.assertEquals(string + ": recover model", model, reifiedStatement.getModel());
    }

    public void testConstructionFromStatements() {
        this.testStatementAndModel("fromStatement", this.SPO.createReifiedStatement(), this.model, this.SPO);
    }

    public void testConstructionFromModels() {
        this.testStatementAndModel("fromModel", this.model.createReifiedStatement(this.SPO), this.model, this.SPO);
    }

    public Set getSetRS(Model model) {
        return GraphTestBase.iteratorToSet(model.listReifiedStatements());
    }

    public void testListReifiedStatements() {
        AbstractTestReifiedStatements.assertEquals("initially: no reified statements", empty, this.getSetRS(this.model));
        ReifiedStatement reifiedStatement = this.model.createReifiedStatement(aURI, this.SPO);
        this.model.add((Resource)reifiedStatement, this.P, this.O);
        Set set = this.arrayToSet(new Object[]{reifiedStatement});
        AbstractTestReifiedStatements.assertEquals("post-add: one reified statement", set, this.getSetRS(this.model));
        this.model.add(this.S, this.P, reifiedStatement);
        AbstractTestReifiedStatements.assertEquals("post-add: still one reified statement", set, this.getSetRS(this.model));
        ReifiedStatement reifiedStatement2 = this.model.createReifiedStatement(anotherURI, this.SPO2);
        Set set2 = this.arrayToSet(new Object[]{reifiedStatement, reifiedStatement2});
        this.model.add((Resource)reifiedStatement2, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("post-add: still one reified statement", set2, this.getSetRS(this.model));
    }

    public void testListDoesntCrash() {
        this.model.createReifiedStatement(this.SPO);
        this.model.createReifiedStatement(this.SPO2);
        AbstractTestReifiedStatements.assertTrue("should be non-empty", this.model.listReifiedStatements().hasNext());
    }

    public Set getSetRS(Model model, Statement statement) {
        return GraphTestBase.iteratorToSet(model.listReifiedStatements(statement));
    }

    public void testListReifiedSpecificStatements() {
        AbstractTestReifiedStatements.assertEquals("no statements should match st", empty, this.getSetRS(this.model, this.SPO));
        ReifiedStatement reifiedStatement = this.model.createReifiedStatement(aURI, this.SPO);
        ReifiedStatement reifiedStatement2 = this.model.createReifiedStatement(anotherURI, this.SPO2);
        this.model.add((Resource)reifiedStatement, this.P, this.O);
        Set set = this.arrayToSet(new Object[]{reifiedStatement2});
        this.model.add((Resource)reifiedStatement2, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("now one matching statement", set, this.getSetRS(this.model, this.SPO2));
    }

    public void testStatementListReifiedStatements() {
        Statement statement = this.SPO;
        Model model = this.model;
        AbstractTestReifiedStatements.assertEquals("it's not there yet", empty, GraphTestBase.iteratorToSet(statement.listReifiedStatements()));
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        Set set = this.arrayToSet(new Object[]{reifiedStatement});
        model.add((Resource)reifiedStatement, this.P, this.O);
        AbstractTestReifiedStatements.assertEquals("it's here now", set, GraphTestBase.iteratorToSet(statement.listReifiedStatements()));
    }

    public void testIsReified() {
        ReifiedStatement reifiedStatement = this.model.createReifiedStatement(aURI, this.SPO);
        Resource resource = this.model.createResource("jena:test/Reifying#BS");
        Property property = this.model.createProperty("jena:test/Reifying#BP");
        Property property2 = this.model.createProperty("jena:test/Reifying#BO");
        this.model.add((Resource)reifiedStatement, this.P, this.O);
        AbstractTestReifiedStatements.assertTrue("st should be reified now", this.SPO.isReified());
        AbstractTestReifiedStatements.assertTrue("m should have st reified now", this.model.isReified(this.SPO));
        AbstractTestReifiedStatements.assertFalse("this new statement should not be reified", this.model.createStatement(resource, property, property2).isReified());
    }

    public void testGetAny() {
        Resource resource = this.model.getAnyReifiedStatement(this.SPO);
        AbstractTestReifiedStatements.assertTrue("should get reified statement back", resource instanceof ReifiedStatement);
        AbstractTestReifiedStatements.assertEquals("should get me the statement", this.SPO, ((ReifiedStatement)resource).getStatement());
    }

    public void testRemoveReificationWorks() {
        Statement statement = this.SPO;
        Model model = this.model;
        model.createReifiedStatement(aURI, statement);
        AbstractTestReifiedStatements.assertTrue("st is now reified", statement.isReified());
        model.removeAllReifications(statement);
        AbstractTestReifiedStatements.assertFalse("st is no longer reified", statement.isReified());
    }

    public void testLeosBug() {
        Model model = this.getModel();
        Statement statement = AbstractTestReifiedStatements.statement(model, "pigs fly south");
        ReifiedStatement reifiedStatement = statement.createReifiedStatement("eh:pointer");
        model.removeReification(reifiedStatement);
        this.assertIsoModels(ModelFactory.createDefaultModel(), model);
    }

    public void testRR() {
        Statement statement = this.SPO;
        Model model = this.model;
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        ReifiedStatement reifiedStatement2 = model.createReifiedStatement(anotherURI, statement);
        model.removeReification(reifiedStatement);
        this.testNotReifying(model, aURI);
        AbstractTestReifiedStatements.assertTrue("st is still reified", statement.isReified());
        model.removeReification(reifiedStatement2);
        AbstractTestReifiedStatements.assertFalse("st should no longer be reified", statement.isReified());
    }

    private void testNotReifying(Model model, String string) {
        try {
            model.createResource(string).as(ReifiedStatement.class);
            AbstractTestReifiedStatements.fail("there should be no reifiedStatement for " + string);
        }
        catch (DoesNotReifyException doesNotReifyException) {
            // empty catch block
        }
    }

    public void testDoesNotReifyElsewhere() {
        Model model = this.getModel();
        this.model.createReifiedStatement("spoo:rubbish", this.SPO);
        this.testDoesNotReify("blue model should not reify rubbish", model.createResource("spoo:rubbish"));
    }
}

