/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

class RecordingModelListener
implements ModelChangedListener {
    List history = new ArrayList();

    RecordingModelListener() {
    }

    public void addedStatement(Statement statement) {
        this.record("add", statement);
    }

    public void addedStatements(Statement[] statementArray) {
        this.record("add[]", Arrays.asList(statementArray));
    }

    public void addedStatements(List list) {
        this.record("addList", list);
    }

    public void addedStatements(StmtIterator stmtIterator) {
        this.record("addIterator", ModelTestBase.iteratorToList(stmtIterator));
    }

    public void addedStatements(Model model) {
        this.record("addModel", model);
    }

    public void removedStatements(Statement[] statementArray) {
        this.record("remove[]", Arrays.asList(statementArray));
    }

    public void removedStatement(Statement statement) {
        this.record("remove", statement);
    }

    public void removedStatements(List list) {
        this.record("removeList", list);
    }

    public void removedStatements(StmtIterator stmtIterator) {
        this.record("removeIterator", ModelTestBase.iteratorToList(stmtIterator));
    }

    public void removedStatements(Model model) {
        this.record("removeModel", model);
    }

    public void notifyEvent(Model model, Object object) {
        this.record("someEvent", model, object);
    }

    protected void record(String string, Object object, Object object2) {
        this.history.add(string);
        this.history.add(object);
        this.history.add(object2);
    }

    protected void record(String string, Object object) {
        this.history.add(string);
        this.history.add(object);
    }

    boolean has(Object[] objectArray) {
        return ((Object)this.history).equals(Arrays.asList(objectArray));
    }

    void assertHas(Object[] objectArray) {
        if (!this.has(objectArray)) {
            ModelTestBase.fail("expected " + Arrays.asList(objectArray) + " but got " + this.history);
        }
    }

    public boolean has(List list) {
        return ((Object)this.history).equals(list);
    }

    public boolean hasStart(List list) {
        return list.size() <= this.history.size() && ((Object)list).equals(this.history.subList(0, list.size()));
    }

    public boolean hasEnd(List list) {
        return list.size() <= this.history.size() && ((Object)list).equals(this.history.subList(this.history.size() - list.size(), this.history.size()));
    }

    public void assertHas(List list) {
        if (!this.has(list)) {
            Assert.fail("expected " + list + " but got " + this.history);
        }
    }

    public void assertHasStart(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        if (!this.hasStart(list)) {
            Assert.fail("expected " + list + " at the beginning of " + this.history);
        }
    }

    public void assertHasEnd(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        if (!this.hasEnd(list)) {
            Assert.fail("expected " + list + " at the end of " + this.history);
        }
    }
}

