/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestContains
extends ModelTestBase {
    public TestContains(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestContains.class);
    }

    public void testContains(boolean bl, String string, String string2) {
        Model model = TestContains.modelWithStatements(string);
        RDFNode rDFNode = TestContains.rdfNode(model, string2);
        if (TestContains.modelWithStatements(string).containsResource(rDFNode) != bl) {
            TestContains.fail("[" + string + "] should" + (bl ? "" : " not") + " contain " + string2);
        }
    }

    public void testContains() {
        this.testContains(false, "", "x");
        this.testContains(false, "a R b", "x");
        this.testContains(false, "a R b; c P d", "x");
        this.testContains(false, "a R b", "z");
        this.testContains(true, "x R y", "x");
        this.testContains(true, "a P b", "P");
        this.testContains(true, "i  Q  j", "j");
        this.testContains(true, "x R y; a P b; i Q j", "y");
        this.testContains(true, "x R y; a P b; i Q j", "y");
        this.testContains(true, "x R y; a P b; i Q j", "R");
        this.testContains(true, "x R y; a P b; i Q j", "a");
    }

    private Resource res(String string) {
        return ResourceFactory.createResource("eh:/" + string);
    }

    private Property prop(String string) {
        return ResourceFactory.createProperty("eh:/" + string);
    }

    public void testContainsWithNull() {
        this.testCWN(false, "", null, null, null);
        this.testCWN(true, "x R y", null, null, null);
        this.testCWN(false, "x R y", null, null, this.res("z"));
        this.testCWN(true, "x RR y", this.res("x"), this.prop("RR"), null);
        this.testCWN(true, "a BB c", null, this.prop("BB"), this.res("c"));
        this.testCWN(false, "a BB c", null, this.prop("ZZ"), this.res("c"));
    }

    public void testCWN(boolean bl, String string, Resource resource, Property property, RDFNode rDFNode) {
        TestContains.assertEquals(bl, TestContains.modelWithStatements(string).contains(resource, property, rDFNode));
    }
}

